/*
 * Musepack audio compression
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma once

#include "config_types.h"
#include <stdio.h>

// FIXME : define this somewhere else
#ifndef NULL
#define NULL 0
#endif

// bitstream.c
#define FRAMES_PER_BLOCK_PWR 6
#define FRAMES_PER_BLOCK (1 << FRAMES_PER_BLOCK_PWR)
#define BUFFER_FULL         (4352 * FRAMES_PER_BLOCK)         // 34490 bit/frame  1320.3 kbps

typedef struct {
	unsigned int  L [36];
	unsigned int  R [36];
} SubbandQuantTyp;

// TODO : enc/dec common struct
// just the same struct as below, dup ?

typedef struct {
	mpc_uint16_t	Code;        // >= 14 bit
	mpc_uint16_t	Length;      // >=  4 bit
} Huffman_t;

typedef struct {
	mpc_uint_t pos; // next free byte position in the buffer
	mpc_uint_t bitsCount; // number of used bits in bitsBuff
	mpc_uint64_t outputBits; // Counter for the number of written bits in the bitstream
	mpc_uint32_t bitsBuff; // bits buffer
	mpc_uint8_t buffer [BUFFER_FULL]; // Buffer for bitstream-file
	mpc_uint_t framesInBlock;

	FILE * outputFile; // ouput file

	unsigned int  MS_Channelmode;
	unsigned int  Overflows; //       = 0;      // number of internal (filterbank) clippings
 } mpc_encoder_t;

