/*
  Copyright (c) 2005, The Musepack Development Team
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:

  * Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.

  * Neither the name of the The Musepack Development Team nor the
  names of its contributors may be used to endorse or promote
  products derived from this software without specific prior
  written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <mpcdec/mpcdec.h>
#include "internal.h"
#include "huffman.h"

mpc_uint32_t mpc_bits_read(mpc_bits_reader * r, const unsigned int nb_bits)
{
	mpc_uint32_t ret = r->buff[0];

	while(nb_bits > r->count){
		r->buff++;
		ret = (ret << 8) | r->buff[0];
		r->count += 8;
	}

	r->count -= nb_bits;

	return (ret >> r->count) & (-1u >> (32 - nb_bits));
}

// basic huffman decoding routine
// works with maximum lengths up to 16
mpc_int32_t mpc_bits_huff_dec(mpc_bits_reader * r, const mpc_huffman *Table)
{
	mpc_uint32_t code = ((r->buff[0] << 16) | (r->buff[1] << 8) | r->buff[2])
			<< (16 - r->count);

	while (code < Table->Code) Table++;

	int tmp = r->count - Table->Length;
	r->buff -= tmp >> 3;
	r->count = tmp & 0x07;

	return Table->Value;
}

unsigned int mpc_bits_get_size(mpc_bits_reader * r, mpc_uint64_t * p_size)
{
	unsigned char tmp;
	mpc_uint64_t size = 0;
	unsigned int ret = 0;

	do {
		tmp = mpc_bits_read(r, 8);
		size = (size << 7) | (tmp & 0x7F);
		ret++;
	} while((tmp & 0x80));

	*p_size = size;
	return ret;
}

int mpc_bits_get_block(mpc_bits_reader * r, mpc_block * p_block)
{
	int size = 2;

	p_block->size = 0;
	p_block->key[0] = mpc_bits_read(r, 8);
	p_block->key[1] = mpc_bits_read(r, 8);

	size += mpc_bits_get_size(r, &(p_block->size));

	p_block->size -= size;

	return size;
}



