/*
  Copyright (c) 2006, The Musepack Development Team
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:

  * Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.

  * Neither the name of the The Musepack Development Team nor the
  names of its contributors may be used to endorse or promote
  products derived from this software without specific prior
  written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include <stdio.h>
#include <mpcdec/mpcdec.h>
#include <replaygain/gain_analysis.h>

static void usage(const char *exename)
{
	printf("Usage: %s <infile.mpc> [<infile2.mpc> <infile3.mpc> ... ]\n", exename);
}

int main(int argc, char **argv)
{
	mpc_reader reader;
	mpc_demux* demux;
	mpc_streaminfo si;
	mpc_status err;
	MPC_SAMPLE_FORMAT sample_buffer[MPC_DECODER_BUFFER_LENGTH];
	Float_t left_samples[MPC_FRAME_LENGTH * sizeof(Float_t)];
	Float_t right_samples[MPC_FRAME_LENGTH * sizeof(Float_t)];
	int j;

	if(argc < 2) {
		usage(argv[0]);
		return 0;
	}

	for( j = 1; j < argc; j++){
		err = mpc_reader_init_stdio(&reader, argv[j]);
		if(err < 0) return !MPC_STATUS_OK;

		demux = mpc_demux_init(&reader);
		if(!demux) return !MPC_STATUS_OK;
		mpc_demux_get_info(demux,  &si);

		if (j == 1) InitGainAnalysis ( si.sample_freq );

		while(1) {
			mpc_frame_info frame;
			int i;

			frame.buffer = sample_buffer;
			mpc_demux_decode(demux, &frame);
			if(frame.bits == -1) break;

			for( i = 0; i < frame.samples; i++){
				left_samples[i] = sample_buffer[2 * i] * (1 << 15);
				right_samples[i] = sample_buffer[2 * i + 1] * (1 << 15);
			}

			AnalyzeSamples(left_samples, right_samples, frame.samples, si.channels);
		}

		printf("%s : %f\n", argv[j], GetTitleGain());

		mpc_demux_exit(demux);
		mpc_reader_exit_stdio(&reader);
	}

	printf("album : %f\n", GetAlbumGain());

    return 0;
}
