/*
  Copyright (c) 2005, The Musepack Development Team
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:

  * Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.

  * Neither the name of the The Musepack Development Team nor the
  names of its contributors may be used to endorse or promote
  products derived from this software without specific prior
  written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/// \file huffman.c
/// Implementations of sv7/sv8 huffman decoding functions.
#include "huffman.h"


// sv7 huffman tables
static const mpc_huffman mpc_table_HuffHdr [10] = {
{0x8000, 1, 0}, {0x6000, 3, 1}, {0x5e00, 7, -4}, {0x5d80, 9, 3}, {0x5d00, 9, 4}, {0x5c00, 8, -5}, {0x5800, 6, 2}, {0x5000, 5, -3}, {0x4000, 4, -2}, {0x0, 2, -1}
};
mpc_lut_data mpc_HuffHdr = {mpc_table_HuffHdr};

const mpc_huffman mpc_table_HuffSCFI [4] = {
	{0x8000, 1, 1}, {0x6000, 3, 2}, {0x4000, 3, 0}, {0x0, 2, 3}
};

static const mpc_huffman mpc_table_HuffDSCF [16] = {
	{0xf800, 5, 5}, {0xf000, 5, -4}, {0xe000, 4, 3}, {0xd000, 4, -3}, {0xc000, 4, 8}, {0xa000, 3, 1}, {0x9000, 4, 0}, {0x8800, 5, -5}, {0x8400, 6, 7}, {0x8000, 6, -7}, {0x6000, 3, -1}, {0x4000, 3, 2}, {0x3000, 4, 4}, {0x2800, 5, 6}, {0x2000, 5, -6}, {0x0, 3, -2}
};
mpc_lut_data mpc_HuffDSCF = {mpc_table_HuffDSCF};

static const mpc_huffman mpc_table_HuffQ1 [2] [27] = {
	{
		{0xe000, 3, 13}, {0xdc00, 6, 26}, {0xd800, 6, 0}, {0xd400, 6, 20}, {0xd000, 6, 6}, {0xc000, 4, 14}, {0xb000, 4, 12}, {0xa000, 4, 4}, {0x9000, 4, 22}, {0x8c00, 6, 8}, {0x8800, 6, 18}, {0x8400, 6, 24}, {0x8000, 6, 2}, {0x7000, 4, 16}, {0x6000, 4, 10}, {0x5800, 5, 17}, {0x5000, 5, 9}, {0x4800, 5, 1}, {0x4000, 5, 25}, {0x3800, 5, 5}, {0x3000, 5, 21}, {0x2800, 5, 3}, {0x2000, 5, 11}, {0x1800, 5, 15}, {0x1000, 5, 23}, {0x800, 5, 19}, {0x0, 5, 7}
	}, {
		{0x8000, 1, 13}, {0x7e00, 7, 15}, {0x7c00, 7, 1}, {0x7a00, 7, 11}, {0x7800, 7, 7}, {0x7600, 7, 17}, {0x7400, 7, 25}, {0x7200, 7, 19}, {0x7180, 9, 8}, {0x7100, 9, 18}, {0x7080, 9, 2}, {0x7000, 9, 24}, {0x6e00, 7, 3}, {0x6c00, 7, 23}, {0x6a00, 7, 21}, {0x6800, 7, 5}, {0x6700, 8, 0}, {0x6600, 8, 26}, {0x6500, 8, 6}, {0x6400, 8, 20}, {0x6000, 6, 9}, {0x5000, 4, 14}, {0x4000, 4, 12}, {0x3000, 4, 4}, {0x2000, 4, 22}, {0x1000, 4, 16}, {0x0, 4, 10}
	}
};

static const mpc_huffman mpc_table_HuffQ2 [2] [25] = {
	{
		{0xf000, 4, 13}, {0xe000, 4, 17}, {0xd000, 4, 7}, {0xc000, 4, 11}, {0xbc00, 6, 1}, {0xb800, 6, 23}, {0xb600, 7, 4}, {0xb400, 7, 20}, {0xb200, 7, 0}, {0xb000, 7, 24}, {0xa800, 5, 22}, {0xa000, 5, 10}, {0x8000, 3, 12}, {0x7800, 5, 2}, {0x7000, 5, 14}, {0x6000, 4, 6}, {0x5000, 4, 18}, {0x4000, 4, 8}, {0x3000, 4, 16}, {0x2800, 5, 9}, {0x2000, 5, 5}, {0x1800, 5, 15}, {0x1000, 5, 21}, {0x800, 5, 19}, {0x0, 5, 3}
	}, {
		{0xf800, 5, 18}, {0xf000, 5, 6}, {0xe800, 5, 8}, {0xe700, 8, 3}, {0xe6c0, 10, 24}, {0xe680, 10, 4}, {0xe640, 10, 0}, {0xe600, 10, 20}, {0xe400, 7, 23}, {0xe200, 7, 1}, {0xe000, 7, 19}, {0xd800, 5, 16}, {0xd600, 7, 15}, {0xd400, 7, 21}, {0xd200, 7, 9}, {0xd000, 7, 5}, {0xcc00, 6, 2}, {0xc800, 6, 10}, {0xc400, 6, 14}, {0xc000, 6, 22}, {0x8000, 2, 12}, {0x6000, 3, 13}, {0x4000, 3, 17}, {0x2000, 3, 11}, {0x0, 3, 7}
	}
};

static const mpc_huffman mpc_table_HuffQ3 [2] [7] = {
	{
		{0xe000, 3, 1}, {0xd000, 4, 3}, {0xc000, 4, -3}, {0xa000, 3, 2}, {0x8000, 3, -2}, {0x4000, 2, 0}, {0x0, 2, -1}
	}, {
		{0xc000, 2, 0}, {0x8000, 2, -1}, {0x4000, 2, 1}, {0x3000, 4, -2}, {0x2800, 5, 3}, {0x2000, 5, -3}, {0x0, 3, 2}
	}
};

static const mpc_huffman mpc_table_HuffQ4 [2] [9] = {
	{
		{0xe000, 3, 0}, {0xc000, 3, -1}, {0xa000, 3, 1}, {0x8000, 3, -2}, {0x6000, 3, 2}, {0x5000, 4, -4}, {0x4000, 4, 4}, {0x2000, 3, 3}, {0x0, 3, -3}
	}, {
		{0xe000, 3, 1}, {0xd000, 4, 2}, {0xc000, 4, -3}, {0x8000, 2, 0}, {0x6000, 3, -2}, {0x5000, 4, 3}, {0x4800, 5, -4}, {0x4000, 5, 4}, {0x0, 2, -1}
	}
};

static const mpc_huffman mpc_table_HuffQ5 [2] [15] = {
	{
		{0xf000, 4, 2}, {0xe800, 5, 5}, {0xe400, 6, -7}, {0xe000, 6, 7}, {0xd000, 4, -3}, {0xc000, 4, 3}, {0xb800, 5, -6}, {0xb000, 5, 6}, {0xa000, 4, -4}, {0x9000, 4, 4}, {0x8000, 4, -5}, {0x6000, 3, 0}, {0x4000, 3, -1}, {0x2000, 3, 1}, {0x0, 3, -2}
	}, {
		{0xf000, 4, 3}, {0xe800, 5, 4}, {0xe600, 7, 6}, {0xe500, 8, -7}, {0xe400, 8, 7}, {0xe000, 6, -6}, {0xc000, 3, 0}, {0xa000, 3, -1}, {0x8000, 3, 1}, {0x6000, 3, -2}, {0x4000, 3, 2}, {0x3800, 5, -5}, {0x3000, 5, 5}, {0x2000, 4, -4}, {0x0, 3, -3}
	}
};

static const mpc_huffman mpc_table_HuffQ6 [2] [31] = {
	{
		{0xf800, 5, 3}, {0xf000, 5, -4}, {0xec00, 6, -11}, {0xe800, 6, 12}, {0xe000, 5, 4}, {0xd800, 5, 6}, {0xd000, 5, -5}, {0xc800, 5, 5}, {0xc000, 5, 7}, {0xb800, 5, -7}, {0xb400, 6, -12}, {0xb000, 6, -13}, {0xa800, 5, -6}, {0xa000, 5, 8}, {0x9800, 5, -8}, {0x9000, 5, 9}, {0x8800, 5, -9}, {0x8400, 6, 13}, {0x8200, 7, -15}, {0x8000, 7, 15}, {0x7000, 4, 0}, {0x6800, 5, -10}, {0x6000, 5, 10}, {0x5000, 4, -1}, {0x4000, 4, 2}, {0x3000, 4, 1}, {0x2000, 4, -2}, {0x1c00, 6, 14}, {0x1800, 6, -14}, {0x1000, 5, 11}, {0x0, 4, -3}
	}, {
		{0xf800, 5, -6}, {0xf000, 5, 6}, {0xe000, 4, 1}, {0xd000, 4, -1}, {0xce00, 7, 10}, {0xcc00, 7, -10}, {0xcb00, 8, -11}, {0xca80, 9, -12}, {0xca60, 11, 13}, {0xca58, 13, 15}, {0xca50, 13, -14}, {0xca48, 13, 14}, {0xca40, 13, -15}, {0xca00, 10, -13}, {0xc900, 8, 11}, {0xc800, 8, 12}, {0xc400, 6, -9}, {0xc000, 6, 9}, {0xb000, 4, -2}, {0xa000, 4, 2}, {0x9000, 4, 3}, {0x8000, 4, -3}, {0x7800, 5, -7}, {0x7000, 5, 7}, {0x6000, 4, -4}, {0x5000, 4, 4}, {0x4800, 5, -8}, {0x4000, 5, 8}, {0x3000, 4, 5}, {0x2000, 4, -5}, {0x0, 3, 0}
	}
};

static const mpc_huffman mpc_table_HuffQ7 [2] [63] = {
	{
		{0xfc00, 6, 7}, {0xf800, 6, 8}, {0xf400, 6, 9}, {0xf000, 6, -8}, {0xec00, 6, 11}, {0xea00, 7, 21}, {0xe900, 8, -28}, {0xe800, 8, 28}, {0xe400, 6, -9}, {0xe200, 7, -22}, {0xe000, 7, -21}, {0xdc00, 6, -10}, {0xd800, 6, -11}, {0xd400, 6, 10}, {0xd000, 6, 12}, {0xcc00, 6, -13}, {0xca00, 7, 22}, {0xc800, 7, 23}, {0xc400, 6, -12}, {0xc000, 6, 13}, {0xbc00, 6, 14}, {0xb800, 6, -14}, {0xb600, 7, -23}, {0xb500, 8, -29}, {0xb400, 8, 29}, {0xb000, 6, -15}, {0xac00, 6, 15}, {0xa800, 6, 16}, {0xa400, 6, -16}, {0xa200, 7, -24}, {0xa000, 7, 24}, {0x9c00, 6, 17}, {0x9a00, 7, -25}, {0x9900, 8, -30}, {0x9800, 8, 30}, {0x9400, 6, -17}, {0x9000, 6, 18}, {0x8c00, 6, -18}, {0x8a00, 7, 25}, {0x8800, 7, 26}, {0x8400, 6, 19}, {0x8200, 7, -26}, {0x8000, 7, -27}, {0x7800, 5, 2}, {0x7400, 6, -19}, {0x7000, 6, 20}, {0x6800, 5, -1}, {0x6700, 8, -31}, {0x6600, 8, 31}, {0x6400, 7, 27}, {0x6000, 6, -20}, {0x5800, 5, 1}, {0x5000, 5, -5}, {0x4800, 5, -3}, {0x4000, 5, 3}, {0x3800, 5, 0}, {0x3000, 5, -2}, {0x2800, 5, -4}, {0x2000, 5, 4}, {0x1800, 5, 5}, {0x1000, 5, -6}, {0x800, 5, 6}, {0x0, 5, -7}
	}, {
		{0xf800, 5, -1}, {0xf000, 5, 2}, {0xe800, 5, -2}, {0xe000, 5, 3}, {0xdf00, 8, -20}, {0xdec0, 10, 24}, {0xdebc, 14, 28}, {0xdeb8, 14, -28}, {0xdeb4, 14, -30}, {0xdeb0, 14, 30}, {0xdea0, 12, -27}, {0xde9c, 14, 29}, {0xde98, 14, -29}, {0xde94, 14, 31}, {0xde90, 14, -31}, {0xde80, 12, 27}, {0xde00, 9, -22}, {0xdc00, 7, -17}, {0xd800, 6, -11}, {0xd000, 5, -3}, {0xc800, 5, 4}, {0xc000, 5, -4}, {0xbe00, 7, 17}, {0xbd00, 8, 20}, {0xbc80, 9, 22}, {0xbc40, 10, -25}, {0xbc00, 10, -26}, {0xb800, 6, 12}, {0xb000, 5, 5}, {0xa800, 5, -5}, {0xa000, 5, 6}, {0x9800, 5, -6}, {0x9400, 6, -12}, {0x9200, 7, -18}, {0x9000, 7, 18}, {0x8c00, 6, 13}, {0x8800, 6, -13}, {0x8000, 5, -7}, {0x7c00, 6, 14}, {0x7b00, 8, 21}, {0x7a00, 8, -21}, {0x7800, 7, -19}, {0x7000, 5, 7}, {0x6800, 5, 8}, {0x6400, 6, -14}, {0x6000, 6, -15}, {0x5800, 5, -8}, {0x5400, 6, 15}, {0x5200, 7, 19}, {0x51c0, 10, 25}, {0x5180, 10, 26}, {0x5100, 9, -23}, {0x5080, 9, 23}, {0x5000, 9, -24}, {0x4800, 5, -9}, {0x4000, 5, 9}, {0x3c00, 6, 16}, {0x3800, 6, -16}, {0x3000, 5, 10}, {0x2000, 4, 0}, {0x1800, 5, -10}, {0x1000, 5, 11}, {0x0, 4, 1}
	}
};

mpc_lut_data mpc_HuffQ [7] [2] = {
	{{mpc_table_HuffQ1[0]}, {mpc_table_HuffQ1[1]}},
	{{mpc_table_HuffQ2[0]}, {mpc_table_HuffQ2[1]}},
	{{mpc_table_HuffQ3[0]}, {mpc_table_HuffQ3[1]}},
	{{mpc_table_HuffQ4[0]}, {mpc_table_HuffQ4[1]}},
	{{mpc_table_HuffQ5[0]}, {mpc_table_HuffQ5[1]}},
	{{mpc_table_HuffQ6[0]}, {mpc_table_HuffQ6[1]}},
	{{mpc_table_HuffQ7[0]},	{mpc_table_HuffQ7[1]}}
};


// sv8 huffman tables
static const mpc_huffman mpc_table_HuffSCFI_1 [4] = {
	{0x8000, 1, 2}, {0x4000, 2, 3}, {0x2000, 3, 1}, {0x0000, 3, 0}
};
mpc_lut_data mpc_HuffSCFI_1 = {mpc_table_HuffSCFI_1};

static const mpc_huffman mpc_table_HuffSCFI_2 [16] = {
	{0xc000, 2, 15}, {0x8000, 2, 10}, {0x6000, 3, 14}, {0x4000, 3, 11}, {0x3800, 5, 13}, {0x3000, 5, 9}, {0x2800, 5, 7}, {0x2000, 5, 6}, {0x1800, 5, 5}, {0x1400, 6, 12}, {0x1000, 6, 8}, {0x0c00, 6, 3}, {0x0800, 6, 2}, {0x0400, 6, 0}, {0x0200, 7, 4}, {0x0000, 7, 1}
};
mpc_lut_data mpc_HuffSCFI_2 = {mpc_table_HuffSCFI_2};

static const mpc_huffman mpc_table_HuffDSCF_1 [64] = {
	{0xe000, 3, 35}, {0xc000, 3, 34}, {0xa000, 3, 33}, {0x9000, 4, 36}, {0x8000, 4, 32}, {0x7000, 4, 30}, {0x6000, 4, 29}, {0x5000, 4, 27}, {0x4000, 4, 26}, {0x3800, 5, 37}, {0x3000, 5, 28}, {0x2800, 5, 25}, {0x2400, 6, 39}, {0x2000, 6, 38}, {0x1c00, 6, 24}, {0x1800, 6, 23}, {0x1600, 7, 40}, {0x1400, 7, 22}, {0x1200, 7, 21}, {0x1000, 7, 20}, {0x0e00, 7, 19}, {0x0d00, 8, 43}, {0x0c00, 8, 42}, {0x0b00, 8, 41}, {0x0a00, 8, 18}, {0x0900, 8, 17}, {0x0800, 8, 16}, {0x0700, 8, 15}, {0x0680, 9, 46}, {0x0600, 9, 45}, {0x0580, 9, 44}, {0x0500, 9, 14}, {0x0480, 9, 13}, {0x0400, 9, 12}, {0x0380, 9, 11}, {0x0340, 10, 49}, {0x0300, 10, 48}, {0x02c0, 10, 47}, {0x0280, 10, 31}, {0x0240, 10, 10}, {0x0200, 10, 9}, {0x01c0, 10, 8}, {0x0180, 10, 7}, {0x0140, 10, 6}, {0x0120, 11, 52}, {0x0100, 11, 51}, {0x00e0, 11, 50}, {0x00c0, 11, 5}, {0x00a0, 11, 4}, {0x0080, 11, 3}, {0x0070, 12, 54}, {0x0060, 12, 53}, {0x0050, 12, 2}, {0x0040, 12, 1}, {0x0030, 12, 0}, {0x0028, 13, 57}, {0x0020, 13, 56}, {0x0018, 13, 55}, {0x0014, 14, 63}, {0x0010, 14, 62}, {0x000c, 14, 61}, {0x0008, 14, 60}, {0x0004, 14, 59}, {0x0000, 14, 58}
};
mpc_lut_data mpc_HuffDSCF_1 = {mpc_table_HuffDSCF_1};

static const mpc_huffman mpc_table_HuffDSCF_2 [65] = {
	{0xe000, 3, 33}, {0xc000, 3, 32}, {0xa000, 3, 31}, {0x8000, 3, 30}, {0x6000, 3, 29}, {0x5000, 4, 34}, {0x4000, 4, 28}, {0x3000, 4, 27}, {0x2800, 5, 36}, {0x2000, 5, 35}, {0x1800, 5, 26}, {0x1400, 6, 37}, {0x1000, 6, 25}, {0x0e00, 7, 38}, {0x0c00, 7, 24}, {0x0a00, 7, 23}, {0x0900, 8, 40}, {0x0800, 8, 39}, {0x0700, 8, 22}, {0x0600, 8, 21}, {0x0580, 9, 42}, {0x0500, 9, 41}, {0x0480, 9, 20}, {0x0400, 9, 19}, {0x0380, 9, 18}, {0x0340, 10, 45}, {0x0300, 10, 44}, {0x02c0, 10, 43}, {0x0280, 10, 17}, {0x0240, 10, 16}, {0x0200, 10, 15}, {0x01c0, 10, 14}, {0x01a0, 11, 48}, {0x0180, 11, 47}, {0x0160, 11, 46}, {0x0140, 11, 13}, {0x0120, 11, 12}, {0x0100, 11, 11}, {0x00e0, 11, 10}, {0x00d0, 12, 64}, {0x00c0, 12, 52}, {0x00b0, 12, 51}, {0x00a0, 12, 50}, {0x0090, 12, 49}, {0x0080, 12, 9}, {0x0070, 12, 8}, {0x0060, 12, 7}, {0x0050, 12, 6}, {0x0048, 13, 55}, {0x0040, 13, 54}, {0x0038, 13, 53}, {0x0030, 13, 5}, {0x0028, 13, 4}, {0x0020, 13, 3}, {0x001c, 14, 58}, {0x0018, 14, 57}, {0x0014, 14, 56}, {0x0010, 14, 2}, {0x000c, 14, 1}, {0x000a, 15, 63}, {0x0008, 15, 62}, {0x0006, 15, 61}, {0x0004, 15, 60}, {0x0002, 15, 59}, {0x0000, 15, 0}
};
mpc_lut_data mpc_HuffDSCF_2 = {mpc_table_HuffDSCF_2};

const mpc_huffman mpc_table_HuffBands [33] = {
	{0x8000, 1, 0}, {0x4000, 2, 32}, {0x2000, 3, 1}, {0x1800, 5, 31}, {0x1000, 5, 2}, {0x0c00, 6, 30}, {0x0800, 6, 3}, {0x0600, 7, 4}, {0x0500, 8, 29}, {0x0400, 8, 6}, {0x0300, 8, 5}, {0x0280, 9, 28}, {0x0200, 9, 7}, {0x01c0, 10, 27}, {0x0180, 10, 26}, {0x0140, 10, 8}, {0x0120, 11, 25}, {0x0100, 11, 24}, {0x00e0, 11, 23}, {0x00c0, 11, 9}, {0x00b0, 12, 22}, {0x00a0, 12, 21}, {0x0090, 12, 20}, {0x0080, 12, 18}, {0x0070, 12, 17}, {0x0060, 12, 16}, {0x0050, 12, 15}, {0x0040, 12, 14}, {0x0030, 12, 12}, {0x0020, 12, 11}, {0x0010, 12, 10}, {0x0008, 13, 19}, {0x0000, 13, 13}
};

static const mpc_huffman mpc_table_HuffRes [2] [17] = {
	{
		{0x8000, 1, 0}, {0x4000, 2, 1}, {0x2000, 3, 16}, {0x1000, 4, 2}, {0x0800, 5, 3}, {0x0400, 6, 4}, {0x0200, 7, 5}, {0x0100, 8, 15}, {0x0080, 9, 6}, {0x0040, 10, 7}, {0x0020, 11, 8}, {0x0010, 12, 9}, {0x0008, 13, 10}, {0x0004, 14, 11}, {0x0002, 15, 12}, {0x0001, 16, 14}, {0x0000, 16, 13}
	}, {
		{0xc000, 2, 16}, {0x8000, 2, 1}, {0x4000, 2, 0}, {0x2000, 3, 2}, {0x1000, 4, 15}, {0x0800, 5, 3}, {0x0400, 6, 14}, {0x0200, 7, 4}, {0x0100, 8, 5}, {0x0080, 9, 13}, {0x0040, 10, 6}, {0x0020, 11, 12}, {0x0010, 12, 7}, {0x000c, 14, 11}, {0x0008, 14, 10}, {0x0004, 14, 9}, {0x0000, 14, 8}
	}
};
mpc_lut_data mpc_HuffRes[2] = {{mpc_table_HuffRes[0]}, {mpc_table_HuffRes[1]}};

static const mpc_huffman mpc_table_HuffQ1_8 [19] = {
	{0xe000, 3, 7}, {0xc000, 3, 6}, {0xa000, 3, 5}, {0x8000, 3, 4}, {0x6000, 3, 3}, {0x5000, 4, 10}, {0x4000, 4, 9}, {0x3000, 4, 8}, {0x2000, 4, 2}, {0x1000, 4, 1}, {0x0800, 5, 11}, {0x0400, 6, 0}, {0x0200, 7, 12}, {0x0100, 8, 13}, {0x0080, 9, 14}, {0x0040, 10, 15}, {0x0020, 11, 16}, {0x0010, 12, 18}, {0x0000, 12, 17}
};

static const mpc_huffman mpc_table_HuffQ2_8 [2] [5*5*5] = {
	{
		{0xe000, 3, 62}, {0xd000, 4, 87}, {0xc000, 4, 67}, {0xb000, 4, 63}, {0xa000, 4, 61}, {0x9000, 4, 57}, {0x8000, 4, 37}, {0x7c00, 6, 93}, {0x7800, 6, 92}, {0x7400, 6, 88}, {0x7000, 6, 86}, {0x6c00, 6, 83}, {0x6800, 6, 82}, {0x6400, 6, 81}, {0x6000, 6, 68}, {0x5c00, 6, 66}, {0x5800, 6, 58}, {0x5400, 6, 56}, {0x5000, 6, 42}, {0x4c00, 6, 41}, {0x4800, 6, 38}, {0x4400, 6, 36}, {0x4000, 6, 32}, {0x3c00, 6, 31}, {0x3a00, 7, 112}, {0x3800, 7, 91}, {0x3600, 7, 72}, {0x3400, 7, 64}, {0x3200, 7, 60}, {0x3000, 7, 52}, {0x2e00, 7, 43}, {0x2c00, 7, 33}, {0x2a00, 7, 12}, {0x2900, 8, 117}, {0x2800, 8, 113}, {0x2700, 8, 111}, {0x2600, 8, 107}, {0x2500, 8, 97}, {0x2400, 8, 89}, {0x2300, 8, 85}, {0x2200, 8, 77}, {0x2100, 8, 73}, {0x2000, 8, 71}, {0x1f00, 8, 69}, {0x1e00, 8, 65}, {0x1d00, 8, 59}, {0x1c00, 8, 55}, {0x1b00, 8, 53}, {0x1a00, 8, 51}, {0x1900, 8, 47}, {0x1800, 8, 39}, {0x1700, 8, 35}, {0x1600, 8, 27}, {0x1500, 8, 17}, {0x1400, 8, 13}, {0x1300, 8, 11}, {0x1200, 8, 7}, {0x1180, 9, 118}, {0x1100, 9, 116}, {0x1080, 9, 108}, {0x1000, 9, 106}, {0x0f80, 9, 98}, {0x0f00, 9, 96}, {0x0e80, 9, 94}, {0x0e00, 9, 90}, {0x0d80, 9, 84}, {0x0d00, 9, 80}, {0x0c80, 9, 78}, {0x0c00, 9, 76}, {0x0b80, 9, 48}, {0x0b00, 9, 46}, {0x0a80, 9, 44}, {0x0a00, 9, 40}, {0x0980, 9, 34}, {0x0900, 9, 30}, {0x0880, 9, 28}, {0x0800, 9, 26}, {0x0780, 9, 18}, {0x0700, 9, 16}, {0x0680, 9, 8}, {0x0600, 9, 6}, {0x05c0, 10, 122}, {0x0580, 10, 110}, {0x0540, 10, 102}, {0x0500, 10, 74}, {0x04c0, 10, 70}, {0x0480, 10, 54}, {0x0440, 10, 50}, {0x0400, 10, 22}, {0x03c0, 10, 2}, {0x03a0, 11, 123}, {0x0380, 11, 121}, {0x0360, 11, 119}, {0x0340, 11, 115}, {0x0320, 11, 114}, {0x0300, 11, 109}, {0x02e0, 11, 105}, {0x02c0, 11, 103}, {0x02a0, 11, 101}, {0x0280, 11, 99}, {0x0260, 11, 95}, {0x0240, 11, 79}, {0x0220, 11, 75}, {0x0200, 11, 49}, {0x01e0, 11, 45}, {0x01c0, 11, 29}, {0x01a0, 11, 25}, {0x0180, 11, 23}, {0x0160, 11, 21}, {0x0140, 11, 19}, {0x0120, 11, 15}, {0x0100, 11, 14}, {0x00e0, 11, 10}, {0x00c0, 11, 9}, {0x00a0, 11, 5}, {0x0080, 11, 3}, {0x0060, 11, 1}, {0x0050, 12, 124}, {0x0040, 12, 104}, {0x0030, 12, 20}, {0x0020, 12, 0}, {0x0018, 13, 120}, {0x0010, 13, 100}, {0x0008, 13, 24}, {0x0000, 13, 4}
	}, {
		{0xf000, 4, 62}, {0xe800, 5, 92}, {0xe000, 5, 87}, {0xd800, 5, 86}, {0xd000, 5, 82}, {0xc800, 5, 68}, {0xc000, 5, 67}, {0xb800, 5, 66}, {0xb000, 5, 63}, {0xa800, 5, 61}, {0xa000, 5, 58}, {0x9800, 5, 57}, {0x9000, 5, 56}, {0x8800, 5, 42}, {0x8000, 5, 38}, {0x7800, 5, 37}, {0x7000, 5, 32}, {0x6c00, 6, 93}, {0x6800, 6, 91}, {0x6400, 6, 88}, {0x6000, 6, 83}, {0x5c00, 6, 81}, {0x5800, 6, 43}, {0x5400, 6, 41}, {0x5000, 6, 36}, {0x4c00, 6, 33}, {0x4800, 6, 31}, {0x4600, 7, 112}, {0x4400, 7, 72}, {0x4200, 7, 64}, {0x4000, 7, 60}, {0x3e00, 7, 52}, {0x3c00, 7, 12}, {0x3b00, 8, 118}, {0x3a00, 8, 117}, {0x3900, 8, 116}, {0x3800, 8, 113}, {0x3700, 8, 111}, {0x3600, 8, 108}, {0x3500, 8, 107}, {0x3400, 8, 106}, {0x3300, 8, 98}, {0x3200, 8, 97}, {0x3100, 8, 96}, {0x3000, 8, 94}, {0x2f00, 8, 90}, {0x2e00, 8, 89}, {0x2d00, 8, 85}, {0x2c00, 8, 84}, {0x2b00, 8, 80}, {0x2a00, 8, 78}, {0x2900, 8, 77}, {0x2800, 8, 76}, {0x2700, 8, 73}, {0x2600, 8, 71}, {0x2500, 8, 69}, {0x2400, 8, 65}, {0x2300, 8, 59}, {0x2200, 8, 55}, {0x2100, 8, 53}, {0x2000, 8, 51}, {0x1f00, 8, 48}, {0x1e00, 8, 47}, {0x1d00, 8, 46}, {0x1c00, 8, 44}, {0x1b00, 8, 40}, {0x1a00, 8, 39}, {0x1900, 8, 35}, {0x1800, 8, 34}, {0x1700, 8, 30}, {0x1600, 8, 28}, {0x1500, 8, 27}, {0x1400, 8, 26}, {0x1300, 8, 18}, {0x1200, 8, 17}, {0x1100, 8, 16}, {0x1000, 8, 13}, {0x0f00, 8, 11}, {0x0e00, 8, 8}, {0x0d00, 8, 7}, {0x0c00, 8, 6}, {0x0b80, 9, 122}, {0x0b00, 9, 110}, {0x0a80, 9, 74}, {0x0a00, 9, 70}, {0x0980, 9, 54}, {0x0900, 9, 50}, {0x0880, 9, 22}, {0x0800, 9, 14}, {0x0780, 9, 2}, {0x0740, 10, 123}, {0x0700, 10, 121}, {0x06c0, 10, 119}, {0x0680, 10, 115}, {0x0640, 10, 114}, {0x0600, 10, 109}, {0x05c0, 10, 105}, {0x0580, 10, 103}, {0x0540, 10, 102}, {0x0500, 10, 101}, {0x04c0, 10, 99}, {0x0480, 10, 95}, {0x0440, 10, 79}, {0x0400, 10, 75}, {0x03c0, 10, 49}, {0x0380, 10, 45}, {0x0340, 10, 29}, {0x0300, 10, 25}, {0x02c0, 10, 23}, {0x0280, 10, 21}, {0x0240, 10, 19}, {0x0200, 10, 15}, {0x01c0, 10, 10}, {0x0180, 10, 9}, {0x0140, 10, 5}, {0x0100, 10, 3}, {0x00c0, 10, 1}, {0x00a0, 11, 124}, {0x0080, 11, 104}, {0x0060, 11, 20}, {0x0040, 11, 0}, {0x0030, 12, 120}, {0x0020, 12, 100}, {0x0010, 12, 24}, {0x0000, 12, 4}
	}
};

static const mpc_huffman mpc_table_HuffQ3_8 [49] = {
	{0xe000, 3, 0}, {0xd000, 4, 17}, {0xc000, 4, 16}, {0xb000, 4, 1}, {0xa000, 4, 15}, {0x9000, 4, -16}, {0x8000, 4, -1}, {0x7800, 5, 32}, {0x7000, 5, 31}, {0x6800, 5, 2}, {0x6000, 5, 14}, {0x5800, 5, -15}, {0x5000, 5, -32}, {0x4c00, 6, 34}, {0x4800, 6, 33}, {0x4400, 6, 47}, {0x4000, 6, 46}, {0x3c00, 6, 18}, {0x3800, 6, 30}, {0x3400, 6, -14}, {0x3000, 6, -2}, {0x2c00, 6, -31}, {0x2800, 6, -17}, {0x2400, 6, -18}, {0x2200, 7, 49}, {0x2000, 7, 48}, {0x1e00, 7, 63}, {0x1c00, 7, 19}, {0x1a00, 7, 29}, {0x1800, 7, 3}, {0x1600, 7, 13}, {0x1400, 7, -13}, {0x1200, 7, -3}, {0x1000, 7, -30}, {0xe00, 7, -47}, {0xc00, 7, -48}, {0xa00, 7, -33}, {0x900, 8, 50}, {0x800, 8, 62}, {0x700, 8, 35}, {0x600, 8, 45}, {0x500, 8, -29}, {0x400, 8, -19}, {0x300, 8, -46}, {0x200, 8, -34}, {0x180, 9, 51}, {0x100, 9, 61}, {0x80, 9, -45}, {0x0, 9, -35}
};

static const mpc_huffman mpc_table_HuffQ4_8 [91] = {
	{0xf000, 4, 0}, {0xe800, 5, 32}, {0xe000, 5, 17}, {0xd800, 5, 16}, {0xd000, 5, 31}, {0xc800, 5, 2}, {0xc000, 5, 1}, {0xb800, 5, 15}, {0xb000, 5, 14}, {0xa800, 5, -15}, {0xa000, 5, -16}, {0x9800, 5, -1}, {0x9000, 5, -32}, {0x8c00, 6, 49}, {0x8800, 6, 48}, {0x8400, 6, 34}, {0x8000, 6, 33}, {0x7c00, 6, 47}, {0x7800, 6, 46}, {0x7400, 6, 19}, {0x7000, 6, 18}, {0x6c00, 6, 30}, {0x6800, 6, 29}, {0x6400, 6, 3}, {0x6000, 6, 13}, {0x5c00, 6, -13}, {0x5800, 6, -14}, {0x5400, 6, -2}, {0x5000, 6, -3}, {0x4c00, 6, -30}, {0x4800, 6, -31}, {0x4400, 6, -17}, {0x4000, 6, -18}, {0x3c00, 6, -47}, {0x3800, 6, -48}, {0x3400, 6, -33}, {0x3200, 7, 64}, {0x3000, 7, 50}, {0x2e00, 7, 63}, {0x2c00, 7, 62}, {0x2a00, 7, 35}, {0x2800, 7, 45}, {0x2600, 7, 4}, {0x2400, 7, 12}, {0x2200, 7, -29}, {0x2000, 7, -19}, {0x1e00, 7, -46}, {0x1c00, 7, -34}, {0x1a00, 7, -64}, {0x1800, 7, -49}, {0x1700, 8, 66}, {0x1600, 8, 65}, {0x1500, 8, 79}, {0x1400, 8, 78}, {0x1300, 8, 51}, {0x1200, 8, 61}, {0x1100, 8, 36}, {0x1000, 8, 44}, {0xf00, 8, 20}, {0xe00, 8, 28}, {0xd00, 8, -12}, {0xc00, 8, -4}, {0xb00, 8, -28}, {0xa00, 8, -20}, {0x900, 8, -45}, {0x800, 8, -35}, {0x700, 8, -62}, {0x600, 8, -63}, {0x500, 8, -50}, {0x480, 9, 67}, {0x400, 9, 77}, {0x380, 9, 52}, {0x300, 9, 60}, {0x280, 9, -44}, {0x200, 9, -36}, {0x180, 9, -61}, {0x100, 9, -51}, {0xc0, 10, 68}, {0x80, 10, 76}, {0x40, 10, -60}, {0x0, 10, -52}, {0x0, 0, 0}, {0x0, 0, 0}, {0x0, 0, 0}, {0x0, 0, 0}, {0x0, 0, 0}, {0x0, 0, 0}, {0x0, 0, 0}, {0x0, 0, 0}, {0x0, 0, 0}, {0x0, 0, 0}
};

static const mpc_huffman mpc_table_HuffQ5_8 [2] [15] = {
	{
		{0xc000, 2, 0}, {0xa000, 3, 2}, {0x8000, 3, 1}, {0x6000, 3, -1}, {0x4000, 3, -2}, {0x3000, 4, 3}, {0x2000, 4, -3}, {0x1800, 5, 4}, {0x1000, 5, -4}, {0x0c00, 6, 5}, {0x0800, 6, -5}, {0x0600, 7, 7}, {0x0400, 7, 6}, {0x0200, 7, -6}, {0x0000, 7, -7}
	}, {
		{0xe000, 3, 2}, {0xc000, 3, 1}, {0xa000, 3, 0}, {0x8000, 3, -1}, {0x6000, 3, -2}, {0x5000, 4, 4}, {0x4000, 4, 3}, {0x3000, 4, -3}, {0x2000, 4, -4}, {0x1800, 5, 5}, {0x1000, 5, -5}, {0x0c00, 6, 7}, {0x0800, 6, 6}, {0x0400, 6, -6}, {0x0000, 6, -7}
	}
};

static const mpc_huffman mpc_table_HuffQ6_8 [2] [31] = {
	{
		{0xc000, 2, 0}, {0xa000, 3, 1}, {0x8000, 3, -1}, {0x7000, 4, 3}, {0x6000, 4, 2}, {0x5000, 4, -2}, {0x4000, 4, -3}, {0x3800, 5, 4}, {0x3000, 5, -4}, {0x2800, 5, -5}, {0x2400, 6, 8}, {0x2000, 6, 7}, {0x1c00, 6, 6}, {0x1800, 6, 5}, {0x1400, 6, -6}, {0x1000, 6, -7}, {0x0c00, 6, -8}, {0x0a00, 7, 9}, {0x0800, 7, -9}, {0x0700, 8, 11}, {0x0600, 8, 10}, {0x0500, 8, -10}, {0x0400, 8, -11}, {0x0380, 9, 15}, {0x0300, 9, 14}, {0x0280, 9, 13}, {0x0200, 9, 12}, {0x0180, 9, -12}, {0x0100, 9, -13}, {0x0080, 9, -14}, {0x0000, 9, -15}
	}, {
		{0xf000, 4, 5}, {0xe000, 4, 4}, {0xd000, 4, 3}, {0xc000, 4, 2}, {0xb000, 4, 1}, {0xa000, 4, 0}, {0x9000, 4, -1}, {0x8000, 4, -2}, {0x7000, 4, -3}, {0x6000, 4, -4}, {0x5000, 4, -5}, {0x4800, 5, 8}, {0x4000, 5, 7}, {0x3800, 5, 6}, {0x3000, 5, -6}, {0x2800, 5, -7}, {0x2000, 5, -8}, {0x1c00, 6, 10}, {0x1800, 6, 9}, {0x1400, 6, -9}, {0x1000, 6, -10}, {0x0e00, 7, 13}, {0x0c00, 7, 12}, {0x0a00, 7, 11}, {0x0800, 7, -11}, {0x0600, 7, -12}, {0x0400, 7, -13}, {0x0300, 8, 15}, {0x0200, 8, 14}, {0x0100, 8, -14}, {0x0000, 8, -15}
	}
};

static const mpc_huffman mpc_table_HuffQ7_8 [2] [63] = {
	{
		{0xc000, 2, 0}, {0xa000, 3, 1}, {0x8000, 3, -1}, {0x7000, 4, 2}, {0x6000, 4, -2}, {0x5800, 5, 4}, {0x5000, 5, 3}, {0x4800, 5, -3}, {0x4000, 5, -4}, {0x3c00, 6, 7}, {0x3800, 6, 6}, {0x3400, 6, 5}, {0x3000, 6, -5}, {0x2c00, 6, -6}, {0x2800, 6, -7}, {0x2600, 7, 13}, {0x2400, 7, 11}, {0x2200, 7, 10}, {0x2000, 7, 9}, {0x1e00, 7, 8}, {0x1c00, 7, -8}, {0x1a00, 7, -9}, {0x1800, 7, -10}, {0x1600, 7, -11}, {0x1400, 7, -12}, {0x1300, 8, 17}, {0x1200, 8, 16}, {0x1100, 8, 15}, {0x1000, 8, 14}, {0x0f00, 8, 12}, {0x0e00, 8, -13}, {0x0d00, 8, -14}, {0x0c00, 8, -15}, {0x0b00, 8, -16}, {0x0a00, 8, -17}, {0x0980, 9, 28}, {0x0900, 9, 27}, {0x0880, 9, 21}, {0x0800, 9, 20}, {0x0780, 9, 19}, {0x0700, 9, 18}, {0x0680, 9, -18}, {0x0600, 9, -19}, {0x0580, 9, -20}, {0x0500, 9, -21}, {0x0480, 9, -27}, {0x0400, 9, -28}, {0x03c0, 10, 31}, {0x0380, 10, 30}, {0x0340, 10, 29}, {0x0300, 10, 26}, {0x02c0, 10, 25}, {0x0280, 10, 24}, {0x0240, 10, 23}, {0x0200, 10, 22}, {0x01c0, 10, -22}, {0x0180, 10, -23}, {0x0140, 10, -24}, {0x0100, 10, -25}, {0x00c0, 10, -26}, {0x0080, 10, -29}, {0x0040, 10, -30}, {0x0000, 10, -31}
	}, {
		{0xf800, 5, 10}, {0xf000, 5, 9}, {0xe800, 5, 8}, {0xe000, 5, 7}, {0xd800, 5, 6}, {0xd000, 5, 5}, {0xc800, 5, 4}, {0xc000, 5, 3}, {0xb800, 5, 2}, {0xb000, 5, 1}, {0xa800, 5, 0}, {0xa000, 5, -1}, {0x9800, 5, -2}, {0x9000, 5, -3}, {0x8800, 5, -4}, {0x8000, 5, -5}, {0x7800, 5, -6}, {0x7000, 5, -7}, {0x6800, 5, -8}, {0x6000, 5, -9}, {0x5c00, 6, 17}, {0x5800, 6, 16}, {0x5400, 6, 15}, {0x5000, 6, 14}, {0x4c00, 6, 13}, {0x4800, 6, 12}, {0x4400, 6, 11}, {0x4000, 6, -10}, {0x3c00, 6, -11}, {0x3800, 6, -12}, {0x3400, 6, -13}, {0x3000, 6, -14}, {0x2c00, 6, -15}, {0x2800, 6, -16}, {0x2400, 6, -17}, {0x2200, 7, 22}, {0x2000, 7, 21}, {0x1e00, 7, 20}, {0x1c00, 7, 19}, {0x1a00, 7, 18}, {0x1800, 7, -18}, {0x1600, 7, -19}, {0x1400, 7, -20}, {0x1200, 7, -21}, {0x1000, 7, -22}, {0x0f00, 8, 29}, {0x0e00, 8, 28}, {0x0d00, 8, 27}, {0x0c00, 8, 26}, {0x0b00, 8, 25}, {0x0a00, 8, 24}, {0x0900, 8, 23}, {0x0800, 8, -23}, {0x0700, 8, -24}, {0x0600, 8, -25}, {0x0500, 8, -26}, {0x0400, 8, -27}, {0x0300, 8, -28}, {0x0200, 8, -29}, {0x0180, 9, 31}, {0x0100, 9, 30}, {0x0080, 9, -30}, {0x0000, 9, -31}
	}
};

static const mpc_huffman mpc_table_HuffQ8_8 [2] [127] = {
	{
		{0xc000, 2, 0}, {0xa000, 3, 1}, {0x8000, 3, -1}, {0x7000, 4, -2}, {0x6800, 5, 3}, {0x6000, 5, 2}, {0x5800, 5, -3}, {0x5400, 6, 7}, {0x5000, 6, 6}, {0x4c00, 6, 5}, {0x4800, 6, 4}, {0x4400, 6, -4}, {0x4000, 6, -5}, {0x3c00, 6, -6}, {0x3800, 6, -7}, {0x3600, 7, 11}, {0x3400, 7, 10}, {0x3200, 7, 9}, {0x3000, 7, 8}, {0x2e00, 7, -8}, {0x2c00, 7, -9}, {0x2a00, 7, -10}, {0x2800, 7, -11}, {0x2700, 8, 19}, {0x2600, 8, 18}, {0x2500, 8, 17}, {0x2400, 8, 16}, {0x2300, 8, 15}, {0x2200, 8, 14}, {0x2100, 8, 13}, {0x2000, 8, 12}, {0x1f00, 8, -12}, {0x1e00, 8, -13}, {0x1d00, 8, -14}, {0x1c00, 8, -15}, {0x1b00, 8, -16}, {0x1a00, 8, -17}, {0x1900, 8, -19}, {0x1880, 9, 56}, {0x1800, 9, 55}, {0x1780, 9, 31}, {0x1700, 9, 28}, {0x1680, 9, 27}, {0x1600, 9, 26}, {0x1580, 9, 25}, {0x1500, 9, 24}, {0x1480, 9, 23}, {0x1400, 9, 22}, {0x1380, 9, 21}, {0x1300, 9, 20}, {0x1280, 9, -18}, {0x1200, 9, -20}, {0x1180, 9, -21}, {0x1100, 9, -22}, {0x1080, 9, -23}, {0x1000, 9, -24}, {0x0f80, 9, -25}, {0x0f00, 9, -26}, {0x0e80, 9, -27}, {0x0e00, 9, -33}, {0x0d80, 9, -54}, {0x0d00, 9, -56}, {0x0cc0, 10, 63}, {0x0c80, 10, 62}, {0x0c40, 10, 61}, {0x0c00, 10, 60}, {0x0bc0, 10, 59}, {0x0b80, 10, 58}, {0x0b40, 10, 57}, {0x0b00, 10, 54}, {0x0ac0, 10, 53}, {0x0a80, 10, 43}, {0x0a40, 10, 40}, {0x0a00, 10, 39}, {0x09c0, 10, 38}, {0x0980, 10, 37}, {0x0940, 10, 36}, {0x0900, 10, 35}, {0x08c0, 10, 34}, {0x0880, 10, 33}, {0x0840, 10, 32}, {0x0800, 10, 30}, {0x07c0, 10, 29}, {0x0780, 10, -28}, {0x0740, 10, -29}, {0x0700, 10, -30}, {0x06c0, 10, -31}, {0x0680, 10, -32}, {0x0640, 10, -34}, {0x0600, 10, -35}, {0x05c0, 10, -36}, {0x0580, 10, -37}, {0x0540, 10, -38}, {0x0500, 10, -39}, {0x04c0, 10, -40}, {0x0480, 10, -41}, {0x0440, 10, -43}, {0x0400, 10, -53}, {0x03c0, 10, -55}, {0x0380, 10, -57}, {0x0340, 10, -58}, {0x0300, 10, -59}, {0x02c0, 10, -60}, {0x0280, 10, -61}, {0x0260, 11, 49}, {0x0240, 11, 47}, {0x0220, 11, 46}, {0x0200, 11, 45}, {0x01e0, 11, 44}, {0x01c0, 11, 42}, {0x01a0, 11, 41}, {0x0180, 11, -42}, {0x0160, 11, -44}, {0x0140, 11, -45}, {0x0120, 11, -46}, {0x0100, 11, -47}, {0x00e0, 11, -48}, {0x00c0, 11, -49}, {0x00a0, 11, -50}, {0x0080, 11, -62}, {0x0060, 11, -63}, {0x0050, 12, 52}, {0x0040, 12, 51}, {0x0030, 12, 50}, {0x0020, 12, 48}, {0x0010, 12, -51}, {0x0000, 12, -52}
	}, {
		{0xfc00, 6, 13}, {0xf800, 6, 11}, {0xf400, 6, 10}, {0xf000, 6, 9}, {0xec00, 6, 8}, {0xe800, 6, 7}, {0xe400, 6, 6}, {0xe000, 6, 5}, {0xdc00, 6, 4}, {0xd800, 6, 3}, {0xd400, 6, 2}, {0xd000, 6, 1}, {0xcc00, 6, 0}, {0xc800, 6, -1}, {0xc400, 6, -2}, {0xc000, 6, -3}, {0xbc00, 6, -4}, {0xb800, 6, -5}, {0xb400, 6, -6}, {0xb000, 6, -7}, {0xac00, 6, -8}, {0xa800, 6, -9}, {0xa400, 6, -10}, {0xa000, 6, -11}, {0x9c00, 6, -12}, {0x9800, 6, -13}, {0x9600, 7, 39}, {0x9400, 7, 38}, {0x9200, 7, 37}, {0x9000, 7, 36}, {0x8e00, 7, 35}, {0x8c00, 7, 34}, {0x8a00, 7, 33}, {0x8800, 7, 32}, {0x8600, 7, 31}, {0x8400, 7, 30}, {0x8200, 7, 29}, {0x8000, 7, 28}, {0x7e00, 7, 27}, {0x7c00, 7, 26}, {0x7a00, 7, 25}, {0x7800, 7, 24}, {0x7600, 7, 23}, {0x7400, 7, 22}, {0x7200, 7, 21}, {0x7000, 7, 20}, {0x6e00, 7, 19}, {0x6c00, 7, 18}, {0x6a00, 7, 17}, {0x6800, 7, 16}, {0x6600, 7, 15}, {0x6400, 7, 14}, {0x6200, 7, 12}, {0x6000, 7, -14}, {0x5e00, 7, -15}, {0x5c00, 7, -16}, {0x5a00, 7, -17}, {0x5800, 7, -18}, {0x5600, 7, -19}, {0x5400, 7, -20}, {0x5200, 7, -21}, {0x5000, 7, -22}, {0x4e00, 7, -23}, {0x4c00, 7, -24}, {0x4a00, 7, -25}, {0x4800, 7, -26}, {0x4600, 7, -27}, {0x4400, 7, -28}, {0x4200, 7, -29}, {0x4000, 7, -30}, {0x3e00, 7, -31}, {0x3c00, 7, -32}, {0x3a00, 7, -33}, {0x3800, 7, -34}, {0x3600, 7, -35}, {0x3400, 7, -36}, {0x3200, 7, -37}, {0x3000, 7, -38}, {0x2e00, 7, -39}, {0x2c00, 7, -40}, {0x2a00, 7, -41}, {0x2900, 8, 59}, {0x2800, 8, 58}, {0x2700, 8, 57}, {0x2600, 8, 56}, {0x2500, 8, 55}, {0x2400, 8, 54}, {0x2300, 8, 53}, {0x2200, 8, 52}, {0x2100, 8, 51}, {0x2000, 8, 50}, {0x1f00, 8, 49}, {0x1e00, 8, 48}, {0x1d00, 8, 47}, {0x1c00, 8, 46}, {0x1b00, 8, 45}, {0x1a00, 8, 44}, {0x1900, 8, 43}, {0x1800, 8, 42}, {0x1700, 8, 41}, {0x1600, 8, 40}, {0x1500, 8, -42}, {0x1400, 8, -43}, {0x1300, 8, -44}, {0x1200, 8, -45}, {0x1100, 8, -46}, {0x1000, 8, -47}, {0x0f00, 8, -48}, {0x0e00, 8, -49}, {0x0d00, 8, -50}, {0x0c00, 8, -51}, {0x0b00, 8, -52}, {0x0a00, 8, -53}, {0x0900, 8, -54}, {0x0800, 8, -55}, {0x0700, 8, -56}, {0x0600, 8, -57}, {0x0500, 8, -58}, {0x0400, 8, -59}, {0x0380, 9, 63}, {0x0300, 9, 62}, {0x0280, 9, 61}, {0x0200, 9, 60}, {0x0180, 9, -60}, {0x0100, 9, -61}, {0x0080, 9, -62}, {0x0000, 9, -63}
	}
};

static const mpc_huffman mpc_table_HuffQ9up_8 [256] = {
	{0xfc00, 6, -128}, {0xf800, 6, 127}, {0xf600, 7, -108}, {0xf400, 7, -110}, {0xf200, 7, -111}, {0xf000, 7, -112}, {0xee00, 7, -113}, {0xec00, 7, -114}, {0xea00, 7, -115}, {0xe800, 7, -116}, {0xe600, 7, -117}, {0xe400, 7, -118}, {0xe200, 7, -119}, {0xe000, 7, -120}, {0xde00, 7, -121}, {0xdc00, 7, -122}, {0xda00, 7, -123}, {0xd800, 7, -124}, {0xd600, 7, -125}, {0xd400, 7, -126}, {0xd200, 7, -127}, {0xd000, 7, 126}, {0xce00, 7, 125}, {0xcc00, 7, 124}, {0xca00, 7, 123}, {0xc800, 7, 122}, {0xc600, 7, 121}, {0xc400, 7, 120}, {0xc200, 7, 119}, {0xc000, 7, 118}, {0xbe00, 7, 117}, {0xbc00, 7, 116}, {0xba00, 7, 115}, {0xb800, 7, 114}, {0xb600, 7, 113}, {0xb400, 7, 112}, {0xb200, 7, 111}, {0xb000, 7, 110}, {0xae00, 7, 109}, {0xac00, 7, 108}, {0xab00, 8, -44}, {0xaa00, 8, -45}, {0xa900, 8, -46}, {0xa800, 8, -47}, {0xa700, 8, -48}, {0xa600, 8, -49}, {0xa500, 8, -50}, {0xa400, 8, -51}, {0xa300, 8, -52}, {0xa200, 8, -53}, {0xa100, 8, -54}, {0xa000, 8, -55}, {0x9f00, 8, -56}, {0x9e00, 8, -57}, {0x9d00, 8, -58}, {0x9c00, 8, -59}, {0x9b00, 8, -60}, {0x9a00, 8, -61}, {0x9900, 8, -62}, {0x9800, 8, -63}, {0x9700, 8, -64}, {0x9600, 8, -65}, {0x9500, 8, -66}, {0x9400, 8, -67}, {0x9300, 8, -68}, {0x9200, 8, -69}, {0x9100, 8, -70}, {0x9000, 8, -71}, {0x8f00, 8, -72}, {0x8e00, 8, -73}, {0x8d00, 8, -74}, {0x8c00, 8, -75}, {0x8b00, 8, -76}, {0x8a00, 8, -77}, {0x8900, 8, -78}, {0x8800, 8, -79}, {0x8700, 8, -80}, {0x8600, 8, -81}, {0x8500, 8, -82}, {0x8400, 8, -83}, {0x8300, 8, -84}, {0x8200, 8, -85}, {0x8100, 8, -86}, {0x8000, 8, -87}, {0x7f00, 8, -88}, {0x7e00, 8, -89}, {0x7d00, 8, -90}, {0x7c00, 8, -91}, {0x7b00, 8, -92}, {0x7a00, 8, -93}, {0x7900, 8, -94}, {0x7800, 8, -95}, {0x7700, 8, -96}, {0x7600, 8, -97}, {0x7500, 8, -98}, {0x7400, 8, -99}, {0x7300, 8, -100}, {0x7200, 8, -101}, {0x7100, 8, -102}, {0x7000, 8, -103}, {0x6f00, 8, -104}, {0x6e00, 8, -105}, {0x6d00, 8, -106}, {0x6c00, 8, -107}, {0x6b00, 8, -109}, {0x6a00, 8, 107}, {0x6900, 8, 106}, {0x6800, 8, 105}, {0x6700, 8, 104}, {0x6600, 8, 103}, {0x6500, 8, 102}, {0x6400, 8, 101}, {0x6300, 8, 100}, {0x6200, 8, 99}, {0x6100, 8, 98}, {0x6000, 8, 97}, {0x5f00, 8, 96}, {0x5e00, 8, 95}, {0x5d00, 8, 94}, {0x5c00, 8, 93}, {0x5b00, 8, 92}, {0x5a00, 8, 91}, {0x5900, 8, 90}, {0x5800, 8, 89}, {0x5700, 8, 88}, {0x5600, 8, 87}, {0x5500, 8, 86}, {0x5400, 8, 85}, {0x5300, 8, 84}, {0x5200, 8, 83}, {0x5100, 8, 82}, {0x5000, 8, 81}, {0x4f00, 8, 80}, {0x4e00, 8, 79}, {0x4d00, 8, 78}, {0x4c00, 8, 77}, {0x4b00, 8, 76}, {0x4a00, 8, 75}, {0x4900, 8, 74}, {0x4800, 8, 73}, {0x4700, 8, 72}, {0x4600, 8, 71}, {0x4500, 8, 70}, {0x4400, 8, 69}, {0x4300, 8, 68}, {0x4200, 8, 67}, {0x4100, 8, 66}, {0x4000, 8, 65}, {0x3f00, 8, 64}, {0x3e00, 8, 63}, {0x3d00, 8, 62}, {0x3c00, 8, 61}, {0x3b00, 8, 60}, {0x3a00, 8, 59}, {0x3900, 8, 58}, {0x3800, 8, 57}, {0x3700, 8, 56}, {0x3600, 8, 55}, {0x3500, 8, 54}, {0x3400, 8, 53}, {0x3300, 8, 52}, {0x3200, 8, 51}, {0x3100, 8, 50}, {0x3000, 8, 49}, {0x2f00, 8, 48}, {0x2e00, 8, 47}, {0x2d00, 8, 46}, {0x2c00, 8, 45}, {0x2b00, 8, 44}, {0x2a00, 8, 43}, {0x2900, 8, 42}, {0x2800, 8, 40}, {0x2700, 8, 20}, {0x2600, 8, 19}, {0x2580, 9, -7}, {0x2500, 9, -8}, {0x2480, 9, -9}, {0x2400, 9, -10}, {0x2380, 9, -11}, {0x2300, 9, -12}, {0x2280, 9, -13}, {0x2200, 9, -14}, {0x2180, 9, -15}, {0x2100, 9, -16}, {0x2080, 9, -17}, {0x2000, 9, -18}, {0x1f80, 9, -19}, {0x1f00, 9, -20}, {0x1e80, 9, -21}, {0x1e00, 9, -22}, {0x1d80, 9, -23}, {0x1d00, 9, -24}, {0x1c80, 9, -25}, {0x1c00, 9, -26}, {0x1b80, 9, -27}, {0x1b00, 9, -28}, {0x1a80, 9, -29}, {0x1a00, 9, -30}, {0x1980, 9, -31}, {0x1900, 9, -32}, {0x1880, 9, -33}, {0x1800, 9, -34}, {0x1780, 9, -35}, {0x1700, 9, -36}, {0x1680, 9, -37}, {0x1600, 9, -38}, {0x1580, 9, -39}, {0x1500, 9, -40}, {0x1480, 9, -41}, {0x1400, 9, -42}, {0x1380, 9, -43}, {0x1300, 9, 41}, {0x1280, 9, 39}, {0x1200, 9, 38}, {0x1180, 9, 37}, {0x1100, 9, 36}, {0x1080, 9, 35}, {0x1000, 9, 34}, {0xf80, 9, 33}, {0xf00, 9, 32}, {0xe80, 9, 31}, {0xe00, 9, 30}, {0xd80, 9, 29}, {0xd00, 9, 28}, {0xc80, 9, 27}, {0xc00, 9, 26}, {0xb80, 9, 25}, {0xb00, 9, 24}, {0xa80, 9, 23}, {0xa00, 9, 22}, {0x980, 9, 21}, {0x900, 9, 18}, {0x880, 9, 17}, {0x800, 9, 16}, {0x780, 9, 15}, {0x700, 9, 14}, {0x680, 9, 13}, {0x600, 9, 12}, {0x580, 9, 11}, {0x500, 9, 10}, {0x480, 9, 9}, {0x400, 9, 8}, {0x380, 9, 7}, {0x300, 9, 6}, {0x280, 9, 5}, {0x240, 10, -3}, {0x200, 10, -4}, {0x1c0, 10, -5}, {0x180, 10, -6}, {0x140, 10, 4}, {0x100, 10, 3}, {0xc0, 10, 2}, {0x80, 10, 1}, {0x40, 10, 0}, {0x20, 11, -1}, {0x0, 11, -2}
};
mpc_lut_data mpc_HuffQ9up_8 = {mpc_table_HuffQ9up_8};


// FIXME : some memory is vasted here
mpc_lut_data mpc_HuffQ_8 [8] [2] = {
	{{mpc_table_HuffQ1_8},    {mpc_table_HuffQ1_8}},
	{{mpc_table_HuffQ2_8[0]}, {mpc_table_HuffQ2_8[1]}},
	{{mpc_table_HuffQ3_8},    {mpc_table_HuffQ3_8}},
	{{mpc_table_HuffQ4_8},    {mpc_table_HuffQ4_8}},
	{{mpc_table_HuffQ5_8[0]}, {mpc_table_HuffQ5_8[1]}},
	{{mpc_table_HuffQ6_8[0]}, {mpc_table_HuffQ6_8[1]}},
	{{mpc_table_HuffQ7_8[0]}, {mpc_table_HuffQ7_8[1]}},
	{{mpc_table_HuffQ8_8[0]}, {mpc_table_HuffQ8_8[1]}}
};

static void huff_fill_lut(const mpc_huffman * table, mpc_huff_lut * lut, const int bits)
{
	int i, idx = 0;
	const int shift = 16 - bits;
	for (i = (1 << bits) - 1; i >= 0 ; i--) {
		if ((table[idx].Code >> shift) < i) {
			lut[i].Length = table[idx].Length;
			lut[i].Value = table[idx].Value;
		} else {
			if (table[idx].Length <= bits) {
				lut[i].Length = table[idx].Length;
				lut[i].Value = table[idx].Value;
			} else {
				lut[i].Length = 0;
				lut[i].Value = idx;
			}
			if (i != 0)
				do {
					idx++;
				} while ((table[idx].Code >> shift) == i);
		}
	}
}

void huff_init_lut(const int bits)
{
	int i, j;

	huff_fill_lut(mpc_HuffDSCF.table, mpc_HuffDSCF.lut, bits);
	huff_fill_lut(mpc_HuffHdr.table, mpc_HuffHdr.lut, bits);

	huff_fill_lut(mpc_HuffSCFI_1.table, mpc_HuffSCFI_1.lut, bits);
	huff_fill_lut(mpc_HuffSCFI_2.table, mpc_HuffSCFI_2.lut, bits);
	huff_fill_lut(mpc_HuffDSCF_1.table, mpc_HuffDSCF_1.lut, bits);
	huff_fill_lut(mpc_HuffDSCF_2.table, mpc_HuffDSCF_2.lut, bits);
	huff_fill_lut(mpc_HuffRes[0].table, mpc_HuffRes[0].lut, bits);
	huff_fill_lut(mpc_HuffRes[1].table, mpc_HuffRes[1].lut, bits);
	huff_fill_lut(mpc_HuffQ9up_8.table, mpc_HuffQ9up_8.lut, bits);


	for( i = 0; i < 8; i++){
		for( j = 0; j < 2; j++){
			huff_fill_lut(mpc_HuffQ_8[i][j].table, mpc_HuffQ_8[i][j].lut, bits);
			if (i != 7) huff_fill_lut(mpc_HuffQ[i][j].table, mpc_HuffQ[i][j].lut, bits);
		}
	}
}


