
//Pre-scaled downmix coefficients
static float cmixlev_lut[4] = { 0.2928, 0.2468, 0.2071, 0.2468 };
static float smixlev_lut[4] = { 0.2928, 0.2071, 0.0   , 0.2071 };

downmix_3f_2r_to_2ch
{
        left      = samples[0];
        centre    = samples[1];
        right     = samples[2];
        left_sur  = samples[3];
        right_sur = samples[4];

        clev = cmixlev_lut[bsi->cmixlev];
        slev = smixlev_lut[bsi->surmixlev];

        for (j = 0; j < 256; j++) {
                left_tmp = 0.4142f * *left++  + clev * *centre   + slev * *left_sur++;
                right_tmp= 0.4142f * *right++ + clev * *centre++ + slev * *right_sur++;

                s16_samples[j * 2 ]    = (left_tmp );
                s16_samples[j * 2 + 1] = (right_tmp);
        }
}

downmix_2f_2r_to_2ch
{
        left      = samples[0];
        right     = samples[1];
        left_sur  = samples[2];
        right_sur = samples[3];

        slev = smixlev_lut[bsi->surmixlev];

        for (j = 0; j < 256; j++) {
                left_tmp = 0.4142f * *left++  + slev * *left_sur++;
                right_tmp= 0.4142f * *right++ + slev * *right_sur++;

                s16_samples[j * 2 ]    = (left_tmp );
                s16_samples[j * 2 + 1] = (right_tmp);
        }
}

downmix_3f_1r_to_2ch
{
        left      = samples[0];
        centre    = samples[1];
        right     = samples[2];
        //Mono surround
        sur = samples[3];

        clev = cmixlev_lut[bsi->cmixlev];
        slev = smixlev_lut[bsi->surmixlev];

        for (j = 0; j < 256; j++) {
                left_tmp = 0.4142f * *left++  + clev * *centre++ + slev * *sur;
                right_tmp= 0.4142f * *right++ + clev * *centre   + slev * *sur++;

                s16_samples[j * 2 ]    = (left_tmp );
                s16_samples[j * 2 + 1] = (right_tmp);
        }
}


downmix_2f_1r_to_2ch
{
        left      = samples[0];
        right     = samples[1];
        //Mono surround
        sur = samples[2];

        slev = smixlev_lut[bsi->surmixlev];

        for (j = 0; j < 256; j++) {
                left_tmp = 0.4142f * *left++  + slev * *sur;
                right_tmp= 0.4142f * *right++ + slev * *sur++;

                s16_samples[j * 2 ]    = (left_tmp );
                s16_samples[j * 2 + 1] = (right_tmp);
        }
}

downmix_3f_0r_to_2ch
{
        left      = samples[0];
        centre    = samples[1];
        right     = samples[2];

        clev = cmixlev_lut[bsi->cmixlev];

        for (j = 0; j < 256; j++) {
                left_tmp = 0.4142f * *left++  + clev * *centre;
                right_tmp= 0.4142f * *right++ + clev * *centre++;

                s16_samples[j * 2 ]    = (left_tmp );
                s16_samples[j * 2 + 1] = (right_tmp);
        }
}

downmix_2f_0r_to_2ch
{
        left      = samples[0];
        right     = samples[1];

        for (j = 0; j < 256; j++) {
                s16_samples[j * 2 ]    = (*left++ );
                s16_samples[j * 2 + 1] = (*right++);
        }
}

downmix_1f_0r_to_2ch
{
        for (j = 0; j < 256; j++) {
                tmp = 0.7071f * *centre++;

                s16_samples[j * 2 ] = s16_samples[j * 2 + 1] = tmp;
        }
}

//
// Downmix into 2 or 4 channels  (4 ch isn't in quite yet)
//
// The downmix function names have the following format
//
// downmix_Xf_Yr_to_[2|4]ch[_dolby]
//
// where X        = number of front channels
//       Y        = number of rear channels
//       [2|4]    = number of output channels
//       [_dolby] = with or without dolby surround mix
//

downmix
{
        if(bsi->acmod > 7)
                dprintf("(downmix) invalid acmod number\n");

        //
        //There are two main cases, with or without Dolby Surround
        //
        if(ac3_config.flags & AC3_DOLBY_SURR_ENABLE)
        {
                fprintf(stderr,"Dolby Surround Mixes not currently enabled\n");
                exit(1);
        }

        //Non-Dolby surround downmixes
        switch(bsi->acmod)
        {
                // 3/2
                case 7:
                        downmix_3f_2r_to_2ch(bsi,samples,s16_samples);
                break;

                // 2/2
                case 6:
                        downmix_2f_2r_to_2ch(bsi,samples,s16_samples);
                break;

                // 3/1
                case 5:
                        downmix_3f_1r_to_2ch(bsi,samples,s16_samples);
                break;

                // 2/1
                case 4:
                        downmix_2f_1r_to_2ch(bsi,samples,s16_samples);
                break;

                // 3/0
                case 3:
                        downmix_3f_0r_to_2ch(bsi,samples,s16_samples);
                break;

                case 2:
                        downmix_2f_0r_to_2ch(bsi,samples,s16_samples);
                break;

                // 1/0
                case 1:
                        downmix_1f_0r_to_2ch(samples[0],s16_samples);
                break;

                // 1+1
                case 0:
                        downmix_1f_0r_to_2ch(samples[ac3_config.dual_mono_ch_sel],s16_samples);
                break;
        }
}







        //the dolby mixes lay here for the time being
        switch(bsi->acmod)
        {
                // 3/2
                case 7:
                        left      = samples[0];
                        centre    = samples[1];
                        right     = samples[2];
                        left_sur  = samples[3];
                        right_sur = samples[4];

                        for (j = 0; j < 256; j++)
                        {
                                right_tmp = 0.2265f * *left_sur++ + 0.2265f * *right_sur++;
                                left_tmp  = -1 * right_tmp;
                                right_tmp += 0.3204f * *right++ + 0.2265f * *centre;
                                left_tmp  += 0.3204f * *left++  + 0.2265f * *centre++;

                                samples[1][j] = right_tmp;
                                samples[0][j] = left_tmp;
                        }

                break;

                // 2/2
                case 6:
                        left      = samples[0];
                        right     = samples[1];
                        left_sur  = samples[2];
                        right_sur = samples[3];

                        for (j = 0; j < 256; j++)
                        {
                                right_tmp = 0.2265f * *left_sur++ + 0.2265f * *right_sur++;
                                left_tmp  = -1 * right_tmp;
                                right_tmp += 0.3204f * *right++;
                                left_tmp  += 0.3204f * *left++ ;

                                samples[1][j] = right_tmp;
                                samples[0][j] = left_tmp;
                        }
                break;

                // 3/1
                case 5:
                        left      = samples[0];
                        centre    = samples[1];
                        right     = samples[2];
                        //Mono surround
                        right_sur = samples[3];

                        for (j = 0; j < 256; j++)
                        {
                                right_tmp =  0.2265f * *right_sur++;
                                left_tmp  = -1 * right_tmp;
                                right_tmp += 0.3204f * *right++ + 0.2265f * *centre;
                                left_tmp  += 0.3204f * *left++  + 0.2265f * *centre++;

                                samples[1][j] = right_tmp;
                                samples[0][j] = left_tmp;
                        }
                break;

                // 2/1
                case 4:
                        left      = samples[0];
                        right     = samples[1];
                        //Mono surround
                        right_sur = samples[2];

                        for (j = 0; j < 256; j++)
                        {
                                right_tmp =  0.2265f * *right_sur++;
                                left_tmp  = -1 * right_tmp;
                                right_tmp += 0.3204f * *right++;
                                left_tmp  += 0.3204f * *left++;

                                samples[1][j] = right_tmp;
                                samples[0][j] = left_tmp;
                        }
                break;

                // 3/0
                case 3:
                        left      = samples[0];
                        centre    = samples[1];
                        right     = samples[2];

                        for (j = 0; j < 256; j++)
                        {
                                right_tmp = 0.3204f * *right++ + 0.2265f * *centre;
                                left_tmp  = 0.3204f * *left++  + 0.2265f * *centre++;

                                samples[1][j] = right_tmp;
                                samples[0][j] = left_tmp;
                        }
                break;

                // 2/0
                case 2:
                //Do nothing!
                break;

                // 1/0
                case 1:
                        //Mono program!
                        right = samples[0];

                        for (j = 0; j < 256; j++)
                        {
                                right_tmp = 0.7071f * *right++;

                                samples[1][j] = right_tmp;
                                samples[0][j] = right_tmp;
                        }

                break;

                // 1+1
                case 0:
                        //Dual mono, output selected by user
                        right = samples[ac3_config.dual_mono_ch_sel];

                        for (j = 0; j < 256; j++)
                        {
                                right_tmp = 0.7071f * *right++;

                                samples[1][j] = right_tmp;
                                samples[0][j] = right_tmp;
                        }
                break;
