#include <stdio.h>
#include <math.h>

#define QUANT   256

double  A  [18] [QUANT];
long    B  [18] [QUANT];
double  C  [18] [QUANT];
double  AA [18];
long    BB [18];

/*
 1[  0]:     0.841315 (   8)
 1[  5]:     0.603536 (   1)
 1[  6]:     0.697221 (   1)
 1[  8]:     0.777310 (   1)

*/

int
main ( void )
{
    int     i, j;
    char    buff [256];
    int     res, eff, events;
    double  mult;
    double  D;

    while ( gets ( buff ) ) {
        if ( 4 == sscanf ( buff, "%u[%u]: %lf (%u)", &res, &eff, &mult, &events )   &&  mult >= 0.01  &&  mult <= 100. ) {
            A  [res] [eff] += events * mult;
            B  [res] [eff] += events;
            AA [res]       += events * mult;
            BB [res]       += events;
        }
    }

    for ( i = 1; i < 18; i++ )
        for ( j = 0; j < QUANT; j++ )
            if ( B [i] [j] )
                printf ( "%2u[%3u]: %8.6f (%8lu)\n", i, j, A[i][j]/B[i][j], B[i][j] );

    for ( i = 1; i < 18; i++ )
        if ( BB [i] )
            printf ( "%2u: %8.6f (%8lu)\n", i, AA[i]/BB[i], BB[i] );

    for ( i = 0; i < 18; i++ ) {
        D = B[i][24] ? A[i][24]/B[i][24] : 1.;
        for ( j = 24; j < QUANT; j++ ) {
            if ( B [i] [j] ) {
                mult = sqrt( B[i][j]);        // 0 .... thousand
                mult = (mult-1) / ( mult );
                D = D * (1-mult) + A[i][j]/B[i][j] * mult;
            }
            C [i][j] = D;
        }
        D = B[i][24] ? A[i][24]/B[i][24] : 1.;
        for ( j = 24; j >= 0; j-- ) {
            if ( B [i] [j] ) {
                mult = sqrt( B[i][j]);        // 0 .... thousand
                mult = (mult-1) / ( mult );
                D = D * (1-mult) + A[i][j]/B[i][j] * mult;
            }
            C [i][j] = D;
        }
    }

    for ( i = 0; i < 18; i++ ) {
        printf ( "    { ");
        for ( j = 0; j < QUANT; j++ )
            printf ( "%8.6f, ", C[i][j] );
        printf ( "},\n" );
    }

    for ( i = 0; i < 18; i++ )
        printf ( "    %8.6f,\n", BB[i] ? AA[i]/BB[i] : 1. );

    return 0;
}
