#include "mppenc.h"


/* C O N S T A N T S */
/*
for (i=0; i<32; ++i)
{
    for (k=0; k<32; ++k) {
        Mi[i][k] = (float)(cos( (2*i+1)*k*M_PI/64 ));
    }
}
*/
// Mi[32][32] = Mi[i][k] being mapped onto M[1024] = M[i*32+k]
static const float M[1024] = {
    1.0000000000000000f, 0.9987954497337341f, 0.9951847195625305f, 0.9891765099647810f, 0.9807852506637573f, 0.9700312614440918f, 0.9569403529167175f, 0.9415440651830208f, 0.9238795042037964f, 0.9039893150329590f, 0.8819212913513184f, 0.8577286100002721f, 0.8314695954322815f, 0.8032075166702271f, 0.7730104327201843f, 0.7409511253549591f, 0.7071067690849304f, 0.6715589761734009f, 0.6343932747840881f, 0.5956993044924335f, 0.5555702447891235f, 0.5141027569770813f, 0.4713967442512512f, 0.4275550934302822f, 0.3826834261417389f, 0.3368898630142212f, 0.2902846634387970f, 0.2429801799032640f, 0.1950903236865997f, 0.1467304676771164f, 0.0980171412229538f, 0.0490676743274181f,
    1.0000000000000000f, 0.9891765117645264f, 0.9569403529167175f, 0.9039892931234433f, 0.8314695954322815f, 0.7409511208534241f, 0.6343932747840881f, 0.5141027441932217f, 0.3826834261417389f, 0.2429801821708679f, 0.0980171412229538f,-0.0490676743274180f,-0.1950903236865997f,-0.3368898630142212f,-0.4713967442512512f,-0.5956993044924334f,-0.7071067690849304f,-0.8032075166702271f,-0.8819212913513184f,-0.9415440651830207f,-0.9807852506637573f,-0.9987954497337341f,-0.9951847195625305f,-0.9700312531945440f,-0.9238795042037964f,-0.8577286005020142f,-0.7730104327201843f,-0.6715589548470187f,-0.5555702447891235f,-0.4275550842285156f,-0.2902846634387970f,-0.1467304744553623f,
    1.0000000000000000f, 0.9700312614440918f, 0.8819212913513184f, 0.7409511253549591f, 0.5555702447891235f, 0.3368898630142212f, 0.0980171412229538f,-0.1467304744553616f,-0.3826834261417389f,-0.5956993103027344f,-0.7730104327201843f,-0.9039892931234433f,-0.9807852506637573f,-0.9987954497337341f,-0.9569403529167175f,-0.8577286100002721f,-0.7071067690849304f,-0.5141027569770813f,-0.2902846634387970f,-0.0490676743274180f, 0.1950903236865997f, 0.4275550842285156f, 0.6343932747840881f, 0.8032075314806451f, 0.9238795042037964f, 0.9891765117645264f, 0.9951847195625305f, 0.9415440651830209f, 0.8314695954322815f, 0.6715589761734009f, 0.4713967442512512f, 0.2429801799032642f,
    1.0000000000000000f, 0.9415440559387207f, 0.7730104327201843f, 0.5141027441932217f, 0.1950903236865997f,-0.1467304676771164f,-0.4713967442512512f,-0.7409511253549589f,-0.9238795042037964f,-0.9987954497337341f,-0.9569403529167175f,-0.8032075314806449f,-0.5555702447891235f,-0.2429801821708679f, 0.0980171412229538f, 0.4275550934302821f, 0.7071067690849304f, 0.9039893150329590f, 0.9951847195625305f, 0.9700312531945441f, 0.8314695954322815f, 0.5956993103027344f, 0.2902846634387970f,-0.0490676743274175f,-0.3826834261417389f,-0.6715589761734009f,-0.8819212913513184f,-0.9891765099647810f,-0.9807852506637573f,-0.8577286005020142f,-0.6343932747840881f,-0.3368898533922210f,
    1.0000000000000000f, 0.9039893150329590f, 0.6343932747840881f, 0.2429801799032640f,-0.1950903236865997f,-0.5956993103027344f,-0.8819212913513184f,-0.9987954562051724f,-0.9238795042037964f,-0.6715589761734009f,-0.2902846634387970f, 0.1467304744553619f, 0.5555702447891235f, 0.8577286005020142f, 0.9951847195625305f, 0.9415440651830209f, 0.7071067690849304f, 0.3368898630142212f,-0.0980171412229538f,-0.5141027441932214f,-0.8314695954322815f,-0.9891765117645264f,-0.9569403529167175f,-0.7409511253549599f,-0.3826834261417389f, 0.0490676760673523f, 0.4713967442512512f, 0.8032075314806448f, 0.9807852506637573f, 0.9700312614440918f, 0.7730104327201843f, 0.4275550934302828f,
    1.0000000000000000f, 0.8577286005020142f, 0.4713967442512512f,-0.0490676743274180f,-0.5555702447891235f,-0.9039893150329590f,-0.9951847195625305f,-0.8032075314806449f,-0.3826834261417389f, 0.1467304676771164f, 0.6343932747840881f, 0.9415440651830208f, 0.9807852506637573f, 0.7409511208534241f, 0.2902846634387970f,-0.2429801799032628f,-0.7071067690849304f,-0.9700312614440918f,-0.9569403529167175f,-0.6715589548470181f,-0.1950903236865997f, 0.3368898630142212f, 0.7730104327201843f, 0.9891765099647810f, 0.9238795042037964f, 0.5956993103027344f, 0.0980171412229538f,-0.4275550934302818f,-0.8314695954322815f,-0.9987954497337341f,-0.8819212913513184f,-0.5141027441932238f,
    1.0000000000000000f, 0.8032075166702271f, 0.2902846634387970f,-0.3368898533922199f,-0.8314695954322815f,-0.9987954497337341f,-0.7730104327201843f,-0.2429801799032641f, 0.3826834261417389f, 0.8577286005020142f, 0.9951847195625305f, 0.7409511253549592f, 0.1950903236865997f,-0.4275550842285156f,-0.8819212913513184f,-0.9891765099647811f,-0.7071067690849304f,-0.1467304676771164f, 0.4713967442512512f, 0.9039892931234430f, 0.9807852506637573f, 0.6715589761734009f, 0.0980171412229538f,-0.5141027441932212f,-0.9238795042037964f,-0.9700312614440918f,-0.6343932747840881f,-0.0490676743274185f, 0.5555702447891235f, 0.9415440559387207f, 0.9569403529167175f, 0.5956993044924350f,
    1.0000000000000000f, 0.7409511208534241f, 0.0980171412229538f,-0.5956993044924334f,-0.9807852506637573f,-0.8577286005020142f,-0.2902846634387970f, 0.4275550934302821f, 0.9238795042037964f, 0.9415440559387207f, 0.4713967442512512f,-0.2429801799032628f,-0.8314695954322815f,-0.9891765117645264f,-0.6343932747840881f, 0.0490676743274174f, 0.7071067690849304f, 0.9987954497337341f, 0.7730104327201843f, 0.1467304744553618f,-0.5555702447891235f,-0.9700312614440918f,-0.8819212913513184f,-0.3368898533922196f, 0.3826834261417389f, 0.9039893150329590f, 0.9569403529167175f, 0.5141027441932239f,-0.1950903236865997f,-0.8032075166702271f,-0.9951847195625305f,-0.6715589548470199f,
    1.0000000000000000f, 0.6715589761734009f,-0.0980171412229538f,-0.8032075314806448f,-0.9807852506637573f,-0.5141027569770813f, 0.2902846634387970f, 0.9039892931234431f, 0.9238795042037964f, 0.3368898630142212f,-0.4713967442512512f,-0.9700312531945441f,-0.8314695954322815f,-0.1467304676771164f, 0.6343932747840881f, 0.9987954562051724f, 0.7071067690849304f,-0.0490676760673523f,-0.7730104327201843f,-0.9891765099647811f,-0.5555702447891235f, 0.2429801821708679f, 0.8819212913513184f, 0.9415440651830208f, 0.3826834261417389f,-0.4275550842285156f,-0.9569403529167175f,-0.8577286100002726f,-0.1950903236865997f, 0.5956993103027344f, 0.9951847195625305f, 0.7409511253549602f,
    1.0000000000000000f, 0.5956993103027344f,-0.2902846634387970f,-0.9415440651830207f,-0.8314695954322815f,-0.0490676760673523f, 0.7730104327201843f, 0.9700312531945441f, 0.3826834261417389f,-0.5141027569770813f,-0.9951847195625305f,-0.6715589548470181f, 0.1950903236865997f, 0.9039893150329590f, 0.8819212913513184f, 0.1467304744553618f,-0.7071067690849304f,-0.9891765117645264f,-0.4713967442512512f, 0.4275550934302801f, 0.9807852506637573f, 0.7409511208534241f,-0.0980171412229538f,-0.8577286100002717f,-0.9238795042037964f,-0.2429801821708679f, 0.6343932747840881f, 0.9987954562051724f, 0.5555702447891235f,-0.3368898630142212f,-0.9569403529167175f,-0.8032075314806458f,
    1.0000000000000000f, 0.5141027569770813f,-0.4713967442512512f,-0.9987954562051724f,-0.5555702447891235f, 0.4275550842285156f, 0.9951847195625305f, 0.5956993044924333f,-0.3826834261417389f,-0.9891765117645264f,-0.6343932747840881f, 0.3368898533922202f, 0.9807852506637573f, 0.6715589761734009f,-0.2902846634387970f,-0.9700312531945441f,-0.7071067690849304f, 0.2429801821708679f, 0.9569403529167175f, 0.7409511253549601f,-0.1950903236865997f,-0.9415440559387207f,-0.7730104327201843f, 0.1467304744553603f, 0.9238795042037964f, 0.8032075166702271f,-0.0980171412229538f,-0.9039892931234428f,-0.8314695954322815f, 0.0490676760673523f, 0.8819212913513184f, 0.8577286100002728f,
    1.0000000000000000f, 0.4275550842285156f,-0.6343932747840881f,-0.9700312531945440f,-0.1950903236865997f, 0.8032075166702271f, 0.8819212913513184f,-0.0490676743274175f,-0.9238795042037964f,-0.7409511208534241f, 0.2902846634387970f, 0.9891765099647810f, 0.5555702447891235f,-0.5141027569770813f,-0.9951847195625305f,-0.3368898533922196f, 0.7071067690849304f, 0.9415440559387207f, 0.0980171412229538f,-0.8577286100002717f,-0.8314695954322815f, 0.1467304676771164f, 0.9569403529167175f, 0.6715589548470199f,-0.3826834261417389f,-0.9987954497337341f,-0.4713967442512512f, 0.5956993044924335f, 0.9807852506637573f, 0.2429801821708679f,-0.7730104327201843f,-0.9039892931234438f,
    1.0000000000000000f, 0.3368898630142212f,-0.7730104327201843f,-0.8577286100002721f, 0.1950903236865997f, 0.9891765117645264f, 0.4713967442512512f,-0.6715589548470177f,-0.9238795042037964f, 0.0490676760673523f, 0.9569403529167175f, 0.5956993044924335f,-0.5555702447891235f,-0.9700312614440918f,-0.0980171412229538f, 0.9039892931234429f, 0.7071067690849304f,-0.4275550842285156f,-0.9951847195625305f,-0.2429801799032640f, 0.8314695954322815f, 0.8032075166702271f,-0.2902846634387970f,-0.9987954562051723f,-0.3826834261417389f, 0.7409511208534241f, 0.8819212913513184f,-0.1467304744553635f,-0.9807852506637573f,-0.5141027569770813f, 0.6343932747840881f, 0.9415440651830210f,
    1.0000000000000000f, 0.2429801821708679f,-0.8819212913513184f,-0.6715589548470187f, 0.5555702447891235f, 0.9415440559387207f,-0.0980171412229538f,-0.9891765099647810f,-0.3826834261417389f, 0.8032075166702271f, 0.7730104327201843f,-0.4275550934302818f,-0.9807852506637573f,-0.0490676760673523f, 0.9569403529167175f, 0.5141027441932239f,-0.7071067690849304f,-0.8577286005020142f, 0.2902846634387970f, 0.9987954562051724f, 0.1950903236865997f,-0.9039893150329590f,-0.6343932747840881f, 0.5956993044924335f, 0.9238795042037964f,-0.1467304676771164f,-0.9951847195625305f,-0.3368898533922236f, 0.8314695954322815f, 0.7409511208534241f,-0.4713967442512512f,-0.9700312531945442f,
    1.0000000000000000f, 0.1467304676771164f,-0.9569403529167175f,-0.4275550934302825f, 0.8314695954322815f, 0.6715589761734009f,-0.6343932747840881f,-0.8577286100002723f, 0.3826834261417389f, 0.9700312614440918f,-0.0980171412229538f,-0.9987954562051724f,-0.1950903236865997f, 0.9415440559387207f, 0.4713967442512512f,-0.8032075314806446f,-0.7071067690849304f, 0.5956993103027344f, 0.8819212913513184f,-0.3368898533922179f,-0.9807852506637573f, 0.0490676760673523f, 0.9951847195625305f, 0.2429801799032678f,-0.9238795042037964f,-0.5141027569770813f, 0.7730104327201843f, 0.7409511253549606f,-0.5555702447891235f,-0.9039893150329590f, 0.2902846634387970f, 0.9891765099647810f,
    1.0000000000000000f, 0.0490676760673523f,-0.9951847195625305f,-0.1467304744553623f, 0.9807852506637573f, 0.2429801821708679f,-0.9569403529167175f,-0.3368898533922210f, 0.9238795042037964f, 0.4275550842285156f,-0.8819212913513184f,-0.5141027441932238f, 0.8314695954322815f, 0.5956993103027344f,-0.7730104327201843f,-0.6715589548470199f, 0.7071067690849304f, 0.7409511208534241f,-0.6343932747840881f,-0.8032075314806458f, 0.5555702447891235f, 0.8577286005020142f,-0.4713967442512512f,-0.9039892931234438f, 0.3826834261417389f, 0.9415440559387207f,-0.2902846634387970f,-0.9700312531945442f, 0.1950903236865997f, 0.9891765117645264f,-0.0980171412229538f,-0.9987954562051724f,
    1.0000000000000000f,-0.0490676760673523f,-0.9951847195625305f, 0.1467304744553619f, 0.9807852506637573f,-0.2429801821708679f,-0.9569403529167175f, 0.3368898533922202f, 0.9238795042037964f,-0.4275550842285156f,-0.8819212913513184f, 0.5141027441932227f, 0.8314695954322815f,-0.5956993103027344f,-0.7730104327201843f, 0.6715589548470184f, 0.7071067690849304f,-0.7409511208534241f,-0.6343932747840881f, 0.8032075314806444f, 0.5555702447891235f,-0.8577286005020142f,-0.4713967442512512f, 0.9039892931234441f, 0.3826834261417389f,-0.9415440559387207f,-0.2902846634387970f, 0.9700312531945442f, 0.1950903236865997f,-0.9891765117645264f,-0.0980171412229538f, 0.9987954562051724f,
    1.0000000000000000f,-0.1467304676771164f,-0.9569403529167175f, 0.4275550934302821f, 0.8314695954322815f,-0.6715589761734009f,-0.6343932747840881f, 0.8577286100002719f, 0.3826834261417389f,-0.9700312614440918f,-0.0980171412229538f, 0.9987954562051724f,-0.1950903236865997f,-0.9415440559387207f, 0.4713967442512512f, 0.8032075314806457f,-0.7071067690849304f,-0.5956993103027344f, 0.8819212913513184f, 0.3368898533922202f,-0.9807852506637573f,-0.0490676760673523f, 0.9951847195625305f,-0.2429801799032616f,-0.9238795042037964f, 0.5141027569770813f, 0.7730104327201843f,-0.7409511253549560f,-0.5555702447891235f, 0.9039893150329590f, 0.2902846634387970f,-0.9891765099647810f,
    1.0000000000000000f,-0.2429801821708679f,-0.8819212913513184f, 0.6715589548470183f, 0.5555702447891235f,-0.9415440559387207f,-0.0980171412229538f, 0.9891765099647811f,-0.3826834261417389f,-0.8032075166702271f, 0.7730104327201843f, 0.4275550934302814f,-0.9807852506637573f, 0.0490676760673523f, 0.9569403529167175f,-0.5141027441932223f,-0.7071067690849304f, 0.8577286005020142f, 0.2902846634387970f,-0.9987954562051723f, 0.1950903236865997f, 0.9039893150329590f,-0.6343932747840881f,-0.5956993044924329f, 0.9238795042037964f, 0.1467304676771164f,-0.9951847195625305f, 0.3368898533922172f, 0.8314695954322815f,-0.7409511208534241f,-0.4713967442512512f, 0.9700312531945441f,
    1.0000000000000000f,-0.3368898630142212f,-0.7730104327201843f, 0.8577286100002720f, 0.1950903236865997f,-0.9891765117645264f, 0.4713967442512512f, 0.6715589548470182f,-0.9238795042037964f,-0.0490676760673523f, 0.9569403529167175f,-0.5956993044924338f,-0.5555702447891235f, 0.9700312614440918f,-0.0980171412229538f,-0.9039892931234437f, 0.7071067690849304f, 0.4275550842285156f,-0.9951847195625305f, 0.2429801799032652f, 0.8314695954322815f,-0.8032075166702271f,-0.2902846634387970f, 0.9987954562051726f,-0.3826834261417389f,-0.7409511208534241f, 0.8819212913513184f, 0.1467304744553633f,-0.9807852506637573f, 0.5141027569770813f, 0.6343932747840881f,-0.9415440651830210f,
    1.0000000000000000f,-0.4275550842285156f,-0.6343932747840881f, 0.9700312531945440f,-0.1950903236865997f,-0.8032075166702271f, 0.8819212913513184f, 0.0490676743274184f,-0.9238795042037964f, 0.7409511208534241f, 0.2902846634387970f,-0.9891765099647809f, 0.5555702447891235f, 0.5141027569770813f,-0.9951847195625305f, 0.3368898533922178f, 0.7071067690849304f,-0.9415440559387207f, 0.0980171412229538f, 0.8577286100002729f,-0.8314695954322815f,-0.1467304676771164f, 0.9569403529167175f,-0.6715589548470179f,-0.3826834261417389f, 0.9987954497337341f,-0.4713967442512512f,-0.5956993044924334f, 0.9807852506637573f,-0.2429801821708679f,-0.7730104327201843f, 0.9039892931234437f,
    1.0000000000000000f,-0.5141027569770813f,-0.4713967442512512f, 0.9987954562051724f,-0.5555702447891235f,-0.4275550842285156f, 0.9951847195625305f,-0.5956993044924326f,-0.3826834261417389f, 0.9891765117645264f,-0.6343932747840881f,-0.3368898533922198f, 0.9807852506637573f,-0.6715589761734009f,-0.2902846634387970f, 0.9700312531945441f,-0.7071067690849304f,-0.2429801821708679f, 0.9569403529167175f,-0.7409511253549561f,-0.1950903236865997f, 0.9415440559387207f,-0.7730104327201843f,-0.1467304744553666f, 0.9238795042037964f,-0.8032075166702271f,-0.0980171412229538f, 0.9039892931234457f,-0.8314695954322815f,-0.0490676760673523f, 0.8819212913513184f,-0.8577286100002726f,
    1.0000000000000000f,-0.5956993103027344f,-0.2902846634387970f, 0.9415440651830209f,-0.8314695954322815f, 0.0490676760673523f, 0.7730104327201843f,-0.9700312531945441f, 0.3826834261417389f, 0.5141027569770813f,-0.9951847195625305f, 0.6715589548470184f, 0.1950903236865997f,-0.9039893150329590f, 0.8819212913513184f,-0.1467304744553635f,-0.7071067690849304f, 0.9891765117645264f,-0.4713967442512512f,-0.4275550934302822f, 0.9807852506637573f,-0.7409511208534241f,-0.0980171412229538f, 0.8577286100002731f,-0.9238795042037964f, 0.2429801821708679f, 0.6343932747840881f,-0.9987954562051722f, 0.5555702447891235f, 0.3368898630142212f,-0.9569403529167175f, 0.8032075314806414f,
    1.0000000000000000f,-0.6715589761734009f,-0.0980171412229538f, 0.8032075314806453f,-0.9807852506637573f, 0.5141027569770813f, 0.2902846634387970f,-0.9039892931234435f, 0.9238795042037964f,-0.3368898630142212f,-0.4713967442512512f, 0.9700312531945440f,-0.8314695954322815f, 0.1467304676771164f, 0.6343932747840881f,-0.9987954562051724f, 0.7071067690849304f, 0.0490676760673523f,-0.7730104327201843f, 0.9891765099647806f,-0.5555702447891235f,-0.2429801821708679f, 0.8819212913513184f,-0.9415440651830210f, 0.3826834261417389f, 0.4275550842285156f,-0.9569403529167175f, 0.8577286100002709f,-0.1950903236865997f,-0.5956993103027344f, 0.9951847195625305f,-0.7409511253549601f,
    1.0000000000000000f,-0.7409511208534241f, 0.0980171412229538f, 0.5956993044924333f,-0.9807852506637573f, 0.8577286005020142f,-0.2902846634387970f,-0.4275550934302813f, 0.9238795042037964f,-0.9415440559387207f, 0.4713967442512512f, 0.2429801799032641f,-0.8314695954322815f, 0.9891765117645264f,-0.6343932747840881f,-0.0490676743274193f, 0.7071067690849304f,-0.9987954497337341f, 0.7730104327201843f,-0.1467304744553630f,-0.5555702447891235f, 0.9700312614440918f,-0.8819212913513184f, 0.3368898533922169f, 0.3826834261417389f,-0.9039893150329590f, 0.9569403529167175f,-0.5141027441932149f,-0.1950903236865997f, 0.8032075166702271f,-0.9951847195625305f, 0.6715589548470144f,
    1.0000000000000000f,-0.8032075166702271f, 0.2902846634387970f, 0.3368898533922201f,-0.8314695954322815f, 0.9987954497337341f,-0.7730104327201843f, 0.2429801799032624f, 0.3826834261417389f,-0.8577286005020142f, 0.9951847195625305f,-0.7409511253549589f, 0.1950903236865997f, 0.4275550842285156f,-0.8819212913513184f, 0.9891765099647806f,-0.7071067690849304f, 0.1467304676771164f, 0.4713967442512512f,-0.9039892931234440f, 0.9807852506637573f,-0.6715589761734009f, 0.0980171412229538f, 0.5141027441932221f,-0.9238795042037964f, 0.9700312614440918f,-0.6343932747840881f, 0.0490676743274188f, 0.5555702447891235f,-0.9415440559387207f, 0.9569403529167175f,-0.5956993044924349f,
    1.0000000000000000f,-0.8577286005020142f, 0.4713967442512512f, 0.0490676743274182f,-0.5555702447891235f, 0.9039893150329590f,-0.9951847195625305f, 0.8032075314806447f,-0.3826834261417389f,-0.1467304676771164f, 0.6343932747840881f,-0.9415440651830209f, 0.9807852506637573f,-0.7409511208534241f, 0.2902846634387970f, 0.2429801799032680f,-0.7071067690849304f, 0.9700312614440918f,-0.9569403529167175f, 0.6715589548470151f,-0.1950903236865997f,-0.3368898630142212f, 0.7730104327201843f,-0.9891765099647817f, 0.9238795042037964f,-0.5956993103027344f, 0.0980171412229538f, 0.4275550934302864f,-0.8314695954322815f, 0.9987954497337341f,-0.8819212913513184f, 0.5141027441932174f,
    1.0000000000000000f,-0.9039893150329590f, 0.6343932747840881f,-0.2429801799032628f,-0.1950903236865997f, 0.5956993103027344f,-0.8819212913513184f, 0.9987954562051724f,-0.9238795042037964f, 0.6715589761734009f,-0.2902846634387970f,-0.1467304744553624f, 0.5555702447891235f,-0.8577286005020142f, 0.9951847195625305f,-0.9415440651830213f, 0.7071067690849304f,-0.3368898630142212f,-0.0980171412229538f, 0.5141027441932219f,-0.8314695954322815f, 0.9891765117645264f,-0.9569403529167175f, 0.7409511253549580f,-0.3826834261417389f,-0.0490676760673523f, 0.4713967442512512f,-0.8032075314806426f, 0.9807852506637573f,-0.9700312614440918f, 0.7730104327201843f,-0.4275550934302842f,
    1.0000000000000000f,-0.9415440559387207f, 0.7730104327201843f,-0.5141027441932214f, 0.1950903236865997f, 0.1467304676771164f,-0.4713967442512512f, 0.7409511253549601f,-0.9238795042037964f, 0.9987954497337341f,-0.9569403529167175f, 0.8032075314806444f,-0.5555702447891235f, 0.2429801821708679f, 0.0980171412229538f,-0.4275550934302822f, 0.7071067690849304f,-0.9039893150329590f, 0.9951847195625305f,-0.9700312531945433f, 0.8314695954322815f,-0.5956993103027344f, 0.2902846634387970f, 0.0490676743274168f,-0.3826834261417389f, 0.6715589761734009f,-0.8819212913513184f, 0.9891765099647812f,-0.9807852506637573f, 0.8577286005020142f,-0.6343932747840881f, 0.3368898533922158f,
    1.0000000000000000f,-0.9700312614440918f, 0.8819212913513184f,-0.7409511253549593f, 0.5555702447891235f,-0.3368898630142212f, 0.0980171412229538f, 0.1467304744553620f,-0.3826834261417389f, 0.5956993103027344f,-0.7730104327201843f, 0.9039892931234438f,-0.9807852506637573f, 0.9987954497337341f,-0.9569403529167175f, 0.8577286100002712f,-0.7071067690849304f, 0.5141027569770813f,-0.2902846634387970f, 0.0490676743274193f, 0.1950903236865997f,-0.4275550842285156f, 0.6343932747840881f,-0.8032075314806467f, 0.9238795042037964f,-0.9891765117645264f, 0.9951847195625305f,-0.9415440651830184f, 0.8314695954322815f,-0.6715589761734009f, 0.4713967442512512f,-0.2429801799032666f,
    1.0000000000000000f,-0.9891765117645264f, 0.9569403529167175f,-0.9039892931234431f, 0.8314695954322815f,-0.7409511208534241f, 0.6343932747840881f,-0.5141027441932226f, 0.3826834261417389f,-0.2429801821708679f, 0.0980171412229538f, 0.0490676743274227f,-0.1950903236865997f, 0.3368898630142212f,-0.4713967442512512f, 0.5956993044924359f,-0.7071067690849304f, 0.8032075166702271f,-0.8819212913513184f, 0.9415440651830214f,-0.9807852506637573f, 0.9987954497337341f,-0.9951847195625305f, 0.9700312531945422f,-0.9238795042037964f, 0.8577286005020142f,-0.7730104327201843f, 0.6715589548470194f,-0.5555702447891235f, 0.4275550842285156f,-0.2902846634387970f, 0.1467304744553577f,
    1.0000000000000000f,-0.9987954497337341f, 0.9951847195625305f,-0.9891765099647810f, 0.9807852506637573f,-0.9700312614440918f, 0.9569403529167175f,-0.9415440651830203f, 0.9238795042037964f,-0.9039893150329590f, 0.8819212913513184f,-0.8577286100002696f, 0.8314695954322815f,-0.8032075166702271f, 0.7730104327201843f,-0.7409511253549560f, 0.7071067690849304f,-0.6715589761734009f, 0.6343932747840881f,-0.5956993044924298f, 0.5555702447891235f,-0.5141027569770813f, 0.4713967442512512f,-0.4275550934302846f, 0.3826834261417389f,-0.3368898630142212f, 0.2902846634387970f,-0.2429801799032599f, 0.1950903236865997f,-0.1467304676771164f, 0.0980171412229538f,-0.0490676743274212f
};

const float  Ci_opt[512] = {
     0.000000000f, 0.000101566f, 0.000971317f, 0.003134727f, 0.035780907f, 0.003134727f, 0.000971317f, 0.000101566f,
    -0.000000477f, 0.000103951f, 0.000953674f, 0.002841473f, 0.035758972f, 0.003401756f, 0.000983715f, 0.000099182f,
    -0.000000477f, 0.000105858f, 0.000930786f, 0.002521515f, 0.035694122f, 0.003643036f, 0.000991821f, 0.000096321f,
    -0.000000477f, 0.000107288f, 0.000902653f, 0.002174854f, 0.035586357f, 0.003858566f, 0.000995159f, 0.000093460f,
    -0.000000477f, 0.000108242f, 0.000868797f, 0.001800537f, 0.035435200f, 0.004049301f, 0.000994205f, 0.000090599f,
    -0.000000477f, 0.000108719f, 0.000829220f, 0.001399517f, 0.035242081f, 0.004215240f, 0.000989437f, 0.000087261f,
    -0.000000477f, 0.000108719f, 0.000783920f, 0.000971317f, 0.035007000f, 0.004357815f, 0.000980854f, 0.000083923f,
    -0.000000954f, 0.000108242f, 0.000731945f, 0.000515938f, 0.034730434f, 0.004477024f, 0.000968933f, 0.000080585f,
    -0.000000954f, 0.000106812f, 0.000674248f, 0.000033379f, 0.034412861f, 0.004573822f, 0.000954151f, 0.000076771f,
    -0.000000954f, 0.000105381f, 0.000610352f,-0.000475883f, 0.034055710f, 0.004649162f, 0.000935555f, 0.000073433f,
    -0.000000954f, 0.000102520f, 0.000539303f,-0.001011848f, 0.033659935f, 0.004703045f, 0.000915051f, 0.000070095f,
    -0.000001431f, 0.000099182f, 0.000462532f,-0.001573563f, 0.033225536f, 0.004737377f, 0.000891685f, 0.000066280f,
    -0.000001431f, 0.000095367f, 0.000378609f,-0.002161503f, 0.032754898f, 0.004752159f, 0.000866413f, 0.000062943f,
    -0.000001907f, 0.000090122f, 0.000288486f,-0.002774239f, 0.032248020f, 0.004748821f, 0.000838757f, 0.000059605f,
    -0.000001907f, 0.000084400f, 0.000191689f,-0.003411293f, 0.031706810f, 0.004728317f, 0.000809669f, 0.000055790f,
    -0.000002384f, 0.000077724f, 0.000088215f,-0.004072189f, 0.031132698f, 0.004691124f, 0.000779152f, 0.000052929f,
    -0.000002384f, 0.000069618f,-0.000021458f,-0.004756451f, 0.030526638f, 0.004638195f, 0.000747204f, 0.000049591f,
    -0.000002861f, 0.000060558f,-0.000137329f,-0.005462170f, 0.029890060f, 0.004570484f, 0.000714302f, 0.000046253f,
    -0.000003338f, 0.000050545f,-0.000259876f,-0.006189346f, 0.029224873f, 0.004489899f, 0.000680923f, 0.000043392f,
    -0.000003338f, 0.000039577f,-0.000388145f,-0.006937027f, 0.028532982f, 0.004395962f, 0.000646591f, 0.000040531f,
    -0.000003815f, 0.000027180f,-0.000522137f,-0.007703304f, 0.027815342f, 0.004290581f, 0.000611782f, 0.000037670f,
    -0.000004292f, 0.000013828f,-0.000661850f,-0.008487225f, 0.027073860f, 0.004174709f, 0.000576973f, 0.000034809f,
    -0.000004768f,-0.000000954f,-0.000806808f,-0.009287834f, 0.026310921f, 0.004048824f, 0.000542164f, 0.000032425f,
    -0.000005245f,-0.000017166f,-0.000956535f,-0.010103703f, 0.025527000f, 0.003914356f, 0.000507355f, 0.000030041f,
    -0.000006199f,-0.000034332f,-0.001111031f,-0.010933399f, 0.024725437f, 0.003771782f, 0.000472546f, 0.000027657f,
    -0.000006676f,-0.000052929f,-0.001269817f,-0.011775017f, 0.023907185f, 0.003622532f, 0.000438213f, 0.000025272f,
    -0.000007629f,-0.000072956f,-0.001432419f,-0.012627602f, 0.023074150f, 0.003467083f, 0.000404358f, 0.000023365f,
    -0.000008106f,-0.000093937f,-0.001597881f,-0.013489246f, 0.022228718f, 0.003306866f, 0.000371456f, 0.000021458f,
    -0.000009060f,-0.000116348f,-0.001766682f,-0.014358521f, 0.021372318f, 0.003141880f, 0.000339031f, 0.000019550f,
    -0.000010014f,-0.000140190f,-0.001937389f,-0.015233517f, 0.020506859f, 0.002974033f, 0.000307560f, 0.000018120f,
    -0.000011444f,-0.000165462f,-0.002110004f,-0.016112804f, 0.019634247f, 0.002803326f, 0.000277042f, 0.000016689f,
    -0.000012398f,-0.000191212f,-0.002283096f,-0.016994476f, 0.018756866f, 0.002630711f, 0.000247478f, 0.000014782f,
    -0.000013828f,-0.000218868f,-0.002457142f,-0.017876148f, 0.017876148f, 0.002457142f, 0.000218868f, 0.000013828f,
    -0.000014782f,-0.000247478f,-0.002630711f,-0.018756866f, 0.016994476f, 0.002283096f, 0.000191212f, 0.000012398f,
    -0.000016689f,-0.000277042f,-0.002803326f,-0.019634247f, 0.016112804f, 0.002110004f, 0.000165462f, 0.000011444f,
    -0.000018120f,-0.000307560f,-0.002974033f,-0.020506859f, 0.015233517f, 0.001937389f, 0.000140190f, 0.000010014f,
    -0.000019550f,-0.000339031f,-0.003141880f,-0.021372318f, 0.014358521f, 0.001766682f, 0.000116348f, 0.000009060f,
    -0.000021458f,-0.000371456f,-0.003306866f,-0.022228718f, 0.013489246f, 0.001597881f, 0.000093937f, 0.000008106f,
    -0.000023365f,-0.000404358f,-0.003467083f,-0.023074150f, 0.012627602f, 0.001432419f, 0.000072956f, 0.000007629f,
    -0.000025272f,-0.000438213f,-0.003622532f,-0.023907185f, 0.011775017f, 0.001269817f, 0.000052929f, 0.000006676f,
    -0.000027657f,-0.000472546f,-0.003771782f,-0.024725437f, 0.010933399f, 0.001111031f, 0.000034332f, 0.000006199f,
    -0.000030041f,-0.000507355f,-0.003914356f,-0.025527000f, 0.010103703f, 0.000956535f, 0.000017166f, 0.000005245f,
    -0.000032425f,-0.000542164f,-0.004048824f,-0.026310921f, 0.009287834f, 0.000806808f, 0.000000954f, 0.000004768f,
    -0.000034809f,-0.000576973f,-0.004174709f,-0.027073860f, 0.008487225f, 0.000661850f,-0.000013828f, 0.000004292f,
    -0.000037670f,-0.000611782f,-0.004290581f,-0.027815342f, 0.007703304f, 0.000522137f,-0.000027180f, 0.000003815f,
    -0.000040531f,-0.000646591f,-0.004395962f,-0.028532982f, 0.006937027f, 0.000388145f,-0.000039577f, 0.000003338f,
    -0.000043392f,-0.000680923f,-0.004489899f,-0.029224873f, 0.006189346f, 0.000259876f,-0.000050545f, 0.000003338f,
    -0.000046253f,-0.000714302f,-0.004570484f,-0.029890060f, 0.005462170f, 0.000137329f,-0.000060558f, 0.000002861f,
    -0.000049591f,-0.000747204f,-0.004638195f,-0.030526638f, 0.004756451f, 0.000021458f,-0.000069618f, 0.000002384f,
    -0.000052929f,-0.000779152f,-0.004691124f,-0.031132698f, 0.004072189f,-0.000088215f,-0.000077724f, 0.000002384f,
    -0.000055790f,-0.000809669f,-0.004728317f,-0.031706810f, 0.003411293f,-0.000191689f,-0.000084400f, 0.000001907f,
    -0.000059605f,-0.000838757f,-0.004748821f,-0.032248020f, 0.002774239f,-0.000288486f,-0.000090122f, 0.000001907f,
    -0.000062943f,-0.000866413f,-0.004752159f,-0.032754898f, 0.002161503f,-0.000378609f,-0.000095367f, 0.000001431f,
    -0.000066280f,-0.000891685f,-0.004737377f,-0.033225536f, 0.001573563f,-0.000462532f,-0.000099182f, 0.000001431f,
    -0.000070095f,-0.000915051f,-0.004703045f,-0.033659935f, 0.001011848f,-0.000539303f,-0.000102520f, 0.000000954f,
    -0.000073433f,-0.000935555f,-0.004649162f,-0.034055710f, 0.000475883f,-0.000610352f,-0.000105381f, 0.000000954f,
    -0.000076771f,-0.000954151f,-0.004573822f,-0.034412861f,-0.000033379f,-0.000674248f,-0.000106812f, 0.000000954f,
    -0.000080585f,-0.000968933f,-0.004477024f,-0.034730434f,-0.000515938f,-0.000731945f,-0.000108242f, 0.000000954f,
    -0.000083923f,-0.000980854f,-0.004357815f,-0.035007000f,-0.000971317f,-0.000783920f,-0.000108719f, 0.000000477f,
    -0.000087261f,-0.000989437f,-0.004215240f,-0.035242081f,-0.001399517f,-0.000829220f,-0.000108719f, 0.000000477f,
    -0.000090599f,-0.000994205f,-0.004049301f,-0.035435200f,-0.001800537f,-0.000868797f,-0.000108242f, 0.000000477f,
    -0.000093460f,-0.000995159f,-0.003858566f,-0.035586357f,-0.002174854f,-0.000902653f,-0.000107288f, 0.000000477f,
    -0.000096321f,-0.000991821f,-0.003643036f,-0.035694122f,-0.002521515f,-0.000930786f,-0.000105858f, 0.000000477f,
    -0.000099182f,-0.000983715f,-0.003401756f,-0.035758972f,-0.002841473f,-0.000953674f,-0.000103951f, 0.000000477f
};

/* V A R I A B L E S */
float  X_L[X_MEM+480];
float  X_R[X_MEM+480];

/* F U N C T I O N S */
// vectoring & partial calculation
static void
Vectoring ( const float* x, float* y )
{
#ifndef FASTER
    const float*  c = Ci_opt;
    int           i;

    for (i=0; i<16; ++i, c+=32, x+=4) {
        *y++ = c[ 0] * x[  0] + c[ 1] * x[ 64] + c[ 2] * x[128] + c[ 3] * x[192]
             + c[ 4] * x[256] + c[ 5] * x[320] + c[ 6] * x[384] + c[ 7] * x[448];

        *y++ = c[ 8] * x[  1] + c[ 9] * x[ 65] + c[10] * x[129] + c[11] * x[193]
             + c[12] * x[257] + c[13] * x[321] + c[14] * x[385] + c[15] * x[449];

        *y++ = c[16] * x[  2] + c[17] * x[ 66] + c[18] * x[130] + c[19] * x[194]
             + c[20] * x[258] + c[21] * x[322] + c[22] * x[386] + c[23] * x[450];

        *y++ = c[24] * x[  3] + c[25] * x[ 67] + c[26] * x[131] + c[27] * x[195]
             + c[28] * x[259] + c[29] * x[323] + c[30] * x[387] + c[31] * x[451];
    }
#else
    const float*  c1;
    const float*  c2;
    const float*  x1;
    const float*  x2;
    int           i;

    c1 = Ci_opt + 128;
    x1 = x      +  16;
    *y++ = c1[ 0] * x1[  0] + c1[ 1] * x1[ 64] + c1[ 2] * x1[128] + c1[ 3] * x1[192]
         + c1[ 4] * x1[256] + c1[ 5] * x1[320] + c1[ 6] * x1[384] + c1[ 7] * x1[448];

    c1 = Ci_opt + 128 - 8;
    x1 = x      +  16 - 1;
    c2 = Ci_opt + 128 + 8;
    x2 = x      +  16 + 1;
    for (i= 1; i<=16; ++i, c1-=8, x1-=1, c2+=8, x2+=1) {
        *y++ = c1[ 0] * x1[  0] + c1[ 1] * x1[ 64] + c1[ 2] * x1[128] + c1[ 3] * x1[192]
             + c1[ 4] * x1[256] + c1[ 5] * x1[320] + c1[ 6] * x1[384] + c1[ 7] * x1[448]
             + c2[ 0] * x2[  0] + c2[ 1] * x2[ 64] + c2[ 2] * x2[128] + c2[ 3] * x2[192]
             + c2[ 4] * x2[256] + c2[ 5] * x2[320] + c2[ 6] * x2[384] + c2[ 7] * x2[448];
    }

    c1 = Ci_opt + 128 + 136;
    x1 = x      +  16 +  17;
    c2 = Ci_opt + 640 - 136;
    x2 = x      +  80 -  17;
    *y++ = c1[ 0] * x1[  0] + c1[ 1] * x1[ 64] + c1[ 2] * x1[128] + c1[ 3] * x1[192]
         + c1[ 4] * x1[256] + c1[ 5] * x1[320] + c1[ 6] * x1[384] + c1[ 7] * x1[448]
         - c2[ 0] * x2[  0] - c2[ 1] * x2[ 64] - c2[ 2] * x2[128] - c2[ 3] * x2[192]
         - c2[ 4] * x2[256] - c2[ 5] * x2[320] - c2[ 6] * x2[384] - c2[ 7] * x2[448];

    c1 = Ci_opt + 128 + 144;
    x1 = x      +  16 +  18;
    c2 = Ci_opt + 640 - 144;
    x2 = x      +  80 -  18;
    for (i=18; i<=31; ++i, c1+=8, x1+=1, c2-=8, x2-=1) {
        *y++ = c1[ 0] * x1[  0] + c1[ 1] * x1[ 64] + c1[ 2] * x1[128] + c1[ 3] * x1[192]
             + c1[ 4] * x1[256] + c1[ 5] * x1[320] + c1[ 6] * x1[384] + c1[ 7] * x1[448]
             - c2[ 0] * x2[  0] - c2[ 1] * x2[ 64] - c2[ 2] * x2[128] - c2[ 3] * x2[192]
             - c2[ 4] * x2[256] - c2[ 5] * x2[320] - c2[ 6] * x2[384] - c2[ 7] * x2[448];
    }
#endif
}

// matrixing with Mi[32][32] = Mi[1024]
static void
Matrixing ( const int MaxBand, const float* mi, const float* y, float* samples )
{
    int   i;
#ifdef FASTER
    for (i=0; i<=MaxBand; ++i, mi+=32, samples+=72) { // 144 = sizeof(SubbandFloatTyp)/sizeof(float)
        *samples = y[0] + mi[ 1] * y[ 1] + mi[ 2] * y[ 2] + mi[ 3] * y[ 3] + mi[ 4] * y[ 4] +
                          mi[ 5] * y[ 5] + mi[ 6] * y[ 6] + mi[ 7] * y[ 7] + mi[ 8] * y[ 8] +
                          mi[ 9] * y[ 9] + mi[10] * y[10] + mi[11] * y[11] + mi[12] * y[12] +
                          mi[13] * y[13] + mi[14] * y[14] + mi[15] * y[15] + mi[16] * y[16] +
                          mi[17] * y[17] + mi[18] * y[18] + mi[19] * y[19] + mi[20] * y[20] +
                          mi[21] * y[21] + mi[22] * y[22] + mi[23] * y[23] + mi[24] * y[24] +
                          mi[25] * y[25] + mi[26] * y[26] + mi[27] * y[27] + mi[28] * y[28] +
                          mi[29] * y[29] + mi[30] * y[30] + mi[31] * y[31];
    }
#else
    for (i=0; i<=MaxBand; ++i, mi+=32, samples+=72) { // 144 = sizeof(SubbandFloatTyp)/sizeof(float)
        *samples = y[16] + mi[ 1] * (y[15]+y[17]) + mi[ 2] * (y[14]+y[18]) +
                           mi[ 3] * (y[13]+y[19]) + mi[ 4] * (y[12]+y[20]) +
                           mi[ 5] * (y[11]+y[21]) + mi[ 6] * (y[10]+y[22]) +
                           mi[ 7] * (y[ 9]+y[23]) + mi[ 8] * (y[ 8]+y[24]) +
                           mi[ 9] * (y[ 7]+y[25]) + mi[10] * (y[ 6]+y[26]) +
                           mi[11] * (y[ 5]+y[27]) + mi[12] * (y[ 4]+y[28]) +
                           mi[13] * (y[ 3]+y[29]) + mi[14] * (y[ 2]+y[30]) +
                           mi[15] * (y[ 1]+y[31]) + mi[16] * (y[ 0]+y[32]) +
                           mi[31] * (y[47]-y[49]) + mi[30] * (y[46]-y[50]) +
                           mi[29] * (y[45]-y[51]) + mi[28] * (y[44]-y[52]) +
                           mi[27] * (y[43]-y[53]) + mi[26] * (y[42]-y[54]) +
                           mi[25] * (y[41]-y[55]) + mi[24] * (y[40]-y[56]) +
                           mi[23] * (y[39]-y[57]) + mi[22] * (y[38]-y[58]) +
                           mi[21] * (y[37]-y[59]) + mi[20] * (y[36]-y[60]) +
                           mi[19] * (y[35]-y[61]) + mi[18] * (y[34]-y[62]) +
                           mi[17] * (y[33]-y[63]);
    }
#endif
}

// Analysis-Filterbank
void
Analyse_Filter ( const PCMDataTyp* in, SubbandFloatTyp* out, const int MaxBand )
{
#ifndef FASTER
    float Y_L[64],Y_R[64];
#else
    float Y_L[32],Y_R[32];
#endif
    float *x;
    const float *pcm;
    int n,i;

    ENTER(3);
    /************************* calculate L-signal ***************************/
    memmove(X_L + X_MEM, X_L, 480*sizeof(float));
    x     = X_L + X_MEM;
    pcm   = in->L + 479;    // 479 = CENTER + 31
    for (n=0; n<36; ++n, pcm+=64) {
        // updating vector x
        x  -= 32;
        for (i=0; i<32; ++i) *(x+i) = *(pcm--);

        // vectoring & partial calculation
        Vectoring(x, Y_L);

        // matrixing
        Matrixing(MaxBand, M, Y_L, &out[0].L[n]);
    }

    /************************* calculate R-signal ***************************/
    memmove(X_R + X_MEM, X_R, 480*sizeof(float));
    x     = X_R + X_MEM;
    pcm   = in->R + 479;    // 479 = CENTER + 31
    for (n=0; n<36; ++n, pcm+=64) {
        // updating vector x
        x  -= 32;
        for (i=0; i<32; ++i)
            x[i] = *(pcm--);

        // vectoring & partial calculation
        Vectoring(x, Y_R);

        // matrixing
        Matrixing(MaxBand, M, Y_R, &out[0].R[n]);
    }
    LEAVE(3);
}
