#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <direct.h>
#include <errno.h>
#include <tchar.h>
#include <windows.h>

// EnumClipboardFormats

void
CopyToClipboard ( const char* src )
{
    TCHAR*   pClipboardText  = NULL;
    BOOL     boClipboardOpen = FALSE;
    BOOL     boReturnValue   = FALSE;
    HGLOBAL  hGlobal         = NULL;

    // Copy to clipboard
    if ( ( hGlobal = GlobalAlloc ( GMEM_MOVEABLE | GMEM_DDESHARE, (strlen(src) + 1) * sizeof (TCHAR) ) ) == NULL )
        goto Exit;
    if ( ( pClipboardText = (TCHAR*) GlobalLock (hGlobal) ) == NULL )
        goto Exit;
    lstrcpy ( pClipboardText, src );
    GlobalUnlock (hGlobal);

    boClipboardOpen = OpenClipboard ( /*GetSafeHwnd()*/ NULL );
    if ( ! boClipboardOpen )
        goto LowOnMemoryExit;

    EmptyClipboard ();
    if ( SetClipboardData ( sizeof(char) != sizeof(TCHAR)  ?  CF_UNICODETEXT  :  CF_TEXT, hGlobal ) == 0 )
        goto LowOnMemoryExit;

        // Cleanup
    hGlobal       = NULL ;
    boReturnValue = TRUE ;

Exit:
    if ( boClipboardOpen )
        CloseClipboard ();
    if ( hGlobal != NULL )
        GlobalFree (hGlobal);
    return;

LowOnMemoryExit:
    fprintf ( stderr, "Low on memory\n" );
    goto Exit;
}


int
main ( void )
{
    CopyToClipboard ( "Ein Hase und ein Igel\n" );
    return 0;
}
