/*
 * known Bugs:
 *   Doesn't wait for the end of system (gnuplot). Does anyone know why?!
 *   Folder is being created even if no file was written
 *   Special characters in album- and filenames
 *   Scale division on all 4 axes
 *
 * to do:
 *   Write GetAlbumFromFilename()
 *   Write GetTitleFromFilename()
 *
 * Other interesting things
 *   - Uniformity of the LSBs (because of ADC-errors or non-linear coding (-law, DAT, some LSBs=0)
 *   - noise estimation via level and LPAC-Entropy
 */


/* config section */
#define GNUPLOT
#define DIRECTORY  "results"

#include <ctype.h>
#include "mppdec.h"

double
derfc ( double x )
{
    double t, u, y;

    t = 3.97886080735226 / (fabs(x) + 3.97886080735226);
    u = t - 0.5;
    y = ((((((((((0.00127109764952614092) * u + 1.19314022838340944e-4) * u -
                  0.003963850973605135  ) * u - 8.70779635317295828e-4) * u +
                  0.00773672528313526668) * u + 0.00383335126264887303) * u -
                  0.0127223813782122755 ) * u - 0.0133823644533460069 ) * u +
                  0.0161315329733252248 ) * u + 0.0390976845588484035 ) * u +
                  0.00249367200053503304;
    y = ((((((((((((y * u - 0.0838864557023001992) * u -
                            0.119463959964325415 ) * u + 0.0166207924969367356) * u +
                            0.357524274449531043 ) * u + 0.805276408752910567 ) * u +
                            1.18902982909273333  ) * u + 1.37040217682338167  ) * u +
                            1.31314653831023098  ) * u + 1.07925515155856677  ) * u +
                            0.774368199119538609 ) * u + 0.490165080585318424 ) * u +
                            0.275374741597376782 ) * t * exp(-x * x);
    return x < 0  ?  2 - y  :  y;
}


double
derf ( double x )
{
           int     k;
           double  w, t, y;
    static double  a[65] = {
        5.958930743e-11, -1.13739022964e-9, 1.466005199839e-8, -1.635035446196e-7, 1.6461004480962e-6, -1.492559551950604e-5, 1.2055331122299265e-4, -8.548326981129666e-4,  0.00522397762482322257, -0.0268661706450773342,  0.11283791670954881569, -0.37612638903183748117, 1.12837916709551257377,
        2.372510631e-11, -4.5493253732e-10, 5.90362766598e-9,  -6.642090827576e-8, 6.7595634268133e-7, -6.21188515924e-6,     5.10388300970969e-5,   -3.7015410692956173e-4, 0.00233307631218880978, -0.0125498847718219221,  0.05657061146827041994, -0.2137966477645600658,  0.84270079294971486929,
        9.49905026e-12,  -1.8310229805e-10, 2.39463074e-9,     -2.721444369609e-8, 2.8045522331686e-7, -2.61830022482897e-6,  2.195455056768781e-5,  -1.6358986921372656e-4, 0.00107052153564110318, -0.00608284718113590151, 0.02986978465246258244, -0.13055593046562267625, 0.67493323603965504676,
        3.82722073e-12,  -7.421598602e-11,  9.793057408e-10,   -1.126008898854e-8, 1.1775134830784e-7, -1.1199275838265e-6,   9.62023443095201e-6,   -7.404402135070773e-5,  5.0689993654144881e-4,  -0.00307553051439272889, 0.01668977892553165586, -0.08548534594781312114, 0.56909076642393639985,
        1.55296588e-12,  -3.032205868e-11,  4.0424830707e-10,  -4.71135111493e-9,  5.011915876293e-8,  -4.8722516178974e-7,   4.30683284629395e-6,   -3.445026145385764e-5,  2.4879276133931664e-4,  -0.00162940941748079288, 0.00988786373932350462, -0.05962426839442303805, 0.49766113250947636708
    };
    static double  b[65] = {
        -2.9734388465e-10, 2.69776334046e-9, -6.40788827665e-9, -1.6678201321e-8,   -2.1854388148686e-7,  2.66246030457984e-6,        1.612722157047886e-5, -2.5616361025506629e-4,        1.5380842432375365e-4, 0.00815533022524927908,        -0.01402283663896319337, -0.19746892495383021487,        0.71511720328842845913,
        -1.951073787e-11, -3.2302692214e-10,  5.22461866919e-9,  3.42940918551e-9,  -3.5772874310272e-7,  1.9999935792654e-7,        2.687044575042908e-5, -1.1843240273775776e-4,        -8.0991728956032271e-4, 0.00661062970502241174,        0.00909530922354827295, -0.2016007277849101314,        0.51169696718727644908,
         3.147682272e-11, -4.8465972408e-10,  6.3675740242e-10,  3.377623323271e-8, -1.5451139637086e-7, -2.03340624738438e-6,        1.947204525295057e-5, 2.854147231653228e-5,        -0.00101565063152200272, 0.00271187003520095655,        0.02328095035422810727, -0.16725021123116877197,        0.32490054966649436974,
         2.31936337e-11,  -6.303206648e-11,  -2.64888267434e-9,  2.050708040581e-8,  1.1371857327578e-7, -2.11211337219663e-6,        3.68797328322935e-6, 9.823686253424796e-5,        -6.5860243990455368e-4, -7.5285814895230877e-4,        0.02585434424202960464, -0.11637092784486193258,        0.18267336775296612024,
        -3.67789363e-12,   2.0876046746e-10, -1.93319027226e-9, -4.35953392472e-9,   1.8006992266137e-7, -7.8441223763969e-7,        -6.75407647949153e-6, 8.428418334440096e-5,        -1.7604388937031815e-4, -0.0023972961143507161,        0.0206412902387602297, -0.06905562880005864105,        0.09084526782065478489
    };

    w = fabs (x);
    if ( w < 2.2 ) {
        t = w * w;
        k = (int) t;
        t -= k;
        k *= 13;
        y = ((((((((((((a[k] * t + a[k + 1]) * t +
            a[k +  2]) * t + a[k +  3]) * t + a[k +  4]) * t +
            a[k +  5]) * t + a[k +  6]) * t + a[k +  7]) * t +
            a[k +  8]) * t + a[k +  9]) * t + a[k + 10]) * t +
            a[k + 11]) * t + a[k + 12]) * w;
    } else if ( w < 6.9 ) {
        k = (int) w;
        t = w - k;
        k = 13 * (k - 2);
        y = (((((((((((b[k] * t + b[k + 1]) * t +
            b[k +  2]) * t + b[k +  3]) * t + b[k +  4]) * t +
            b[k +  5]) * t + b[k +  6]) * t + b[k +  7]) * t +
            b[k +  8]) * t + b[k +  9]) * t + b[k + 10]) * t +
            b[k + 11]) * t + b[k + 12];
        y *= y;
        y *= y;
        y *= y;
        y = 1 - y * y;
    } else {
        y = 1;
    }
    return x < 0  ?  -y  :  y;
}


double
dierfc ( double y )
{
    double  s, t, u, w, x, z;

    z = y > 1  ?  2. - y  :  y;
    w = 0.916461398268964 - log (z);
    u = sqrt (w);
    s = (log (u) + 0.488826640273108) / w;
    t = 1 / (u + 0.231729200323405);
    x = u * (1 - s * (s * 0.124610454613712 + 0.5)) -
        ((((-0.0728846765585675 * t + 0.269999308670029) * t +
             0.150689047360223) * t + 0.116065025341614) * t +
             0.499999303439796) * t;
    t = 3.97886080735226 / (x + 3.97886080735226);
    u = t - 0.5;
    s = (((((((((0.00112648096188977922  * u +
                 1.05739299623423047e-4) * u - 0.00351287146129100025) * u -
                 7.71708358954120939e-4) * u + 0.00685649426074558612) * u +
                 0.00339721910367775861) * u - 0.011274916933250487  ) * u -
                 0.0118598117047771104 ) * u + 0.0142961988697898018 ) * u +
                 0.0346494207789099922 ) * u + 0.00220995927012179067;
    s = ((((((((((((s * u - 0.0743424357241784861) * u -
        0.105872177941595488) * u + 0.0147297938331485121) * u +
        0.316847638520135944) * u + 0.713657635868730364 ) * u +
        1.05375024970847138 ) * u + 1.21448730779995237  ) * u +
        1.16374581931560831 ) * u + 0.956464974744799006 ) * u +
        0.686265948274097816) * u + 0.434397492331430115 ) * u +
        0.244044510593190935) * t -
        z * exp (x * x - 0.120782237635245222);
    x += s * (x * s + 1);
    return y > 1  ?   -x  :  +x;
}


double
dgamma ( double x )
{
    int     k, n;
    double  w, y;

    n = x < 1.5  ?  -((int) (2.5 - x))  :  (int) (x - 1.5);
    w = x - (n + 2);
    y = ((((((((((((-1.99542863674e-7      * w + 1.337767384067e-6   ) * w -
                     2.591225267689e-6   ) * w - 1.7545539395205e-5  ) * w +
                     1.45596568617526e-4 ) * w - 3.60837876648255e-4 ) * w -
                     8.04329819255744e-4 ) * w + 0.008023273027855346) * w -
                     0.017645244547851414) * w - 0.024552490005641278) * w +
                     0.19109110138763841 ) * w - 0.233093736421782878) * w -
                     0.422784335098466784) * w + 0.99999999999999999;
    if ( n > 0 ) {
        w = x - 1;
        for ( k = 2; k <= n; k++ ) {
            w *= x - k;
        }
    } else {
        w = 1;
        for ( k = 0; k > n; k-- ) {
            y *= x - k;
        }
    }
    return w / y;
}


#ifdef GNUPLOT
const char  __gnuplot [] =
//"set grid\n"
"set tics out\n"
"set key bottom right\n"
//"set nokey\n"
"\n"
"set xtics mirror\n"
"set ytics mirror\n"
"\n"
"set xtics -10, 1, 10\n"
"set ytics (\"32768\" 32768, \"24576\" 24576, \"16384\" 16384, \"8192\" 8192, \"0\" 0, \"-8192\" -8192, \"-16384\" -16384, \"-24576\" -24576, \"-32768\" -32768)"
"\n"
"set xrange[-5.5:5.5]\n"
"set yrange[-32768:32768]\n"
"\n"
"set xlabel \"Sigma\"\n"
"set ylabel \"Sample\"\n"
"\n"
"set data style lines\n"
"\n"
"set size 1024./128./5., 768./120./4.\n"
"set terminal png color\n"
;


// fixme: needs to be written
static const char*
GetAlbumFromFilename ( const char* filename )
{
    static const char*  name = "Album";

    return name;
}


// fixme: needs to be written
static const char*
GetTitleFromFilename ( const char* filename )
{
    static char  dstname [1024];
    int          len = NULL==strrchr (filename, '.')  ?  strlen (filename)  :  strrchr (filename, '.') - filename;

    sprintf ( dstname, "%*.*s", len, len, filename );

    return dstname;
}


static int
gnuplot ( int argc, const char** argv )
{
    int    i;
    char   dstname [1024];
    char   command [1024];
    int    rc;
    FILE*  fp;

    stderr_printf ( "plotting ..." );

    sprintf ( dstname, DIRECTORY"/%s.plot", GetAlbumFromFilename (argv[1]) );
    if ( (fp = fopen ( dstname, "w")) == NULL ) {
        stderr_printf ( "Can't create '%s'\n", dstname );
        return -1;
    }

    fprintf ( fp, "%s\n", __gnuplot );
    fprintf ( fp, "set title \"%s\"\n"     , GetAlbumFromFilename (argv[1]) );
    fprintf ( fp, "set output \"%s.png\"\n", GetAlbumFromFilename (argv[1]) );


    fprintf ( fp, "plot" );
    for ( i = 1; i < argc; i++ ) {
        fprintf ( fp, "%s\"%s\"", 1==i  ?  " "  :  ", ", GetTitleFromFilename (argv[i]) );
    }
    fprintf ( fp, "\n" );
    fclose (fp);

    if ( 0 != chdir (DIRECTORY) ) {
        stderr_printf ( "\nCan't chdir %s\n", DIRECTORY );
        return -1;
    }

    sprintf ( command, "gnuplot %s.plot &> /dev/null", GetAlbumFromFilename (argv[1]) );
    stderr_printf ( "\n" );
    rc = system (command);
    /* system doesn't recognize most errors */
    if ( 127 == rc ) {
        /* fixme: errno should be checked here */
        stderr_printf ( "Can't execute '%s'\n", command );
    }
    else if ( -1 == rc ) {
        stderr_printf ( "Can't plot '%s'\n", GetAlbumFromFilename (argv[1]) );
    }

# if 0
    for ( i = 1; i < argc; i++ ) {
        sprintf ( command, "%s", GetTitleFromFilename (argv[i]) );
        if ( 0 != unlink (command) ) {
            stderr_printf ( "Can't delete '%s'\n", command );
        }
    }
    sprintf ( command, "%s.plot", GetAlbumFromFilename (argv[1]) );
    if ( 0 != unlink (command) ) {
        stderr_printf ( "Can't delete '%s'\n", command );
    }
# endif

    return rc;
}

#endif


const char __1 [] =
"#\n"
"# ACE/gr parameter file\n"
"#\n"
"@version 40102\n"
"@page layout free\n"
"@ps linewidth begin 1\n"
"@ps linewidth increment 2\n"
"@hardcopy device 1\n"
"@page 5\n"
"@page inout 5\n"
"@link page off\n"
"@default linestyle 1\n"
"@default linewidth 1\n"
"@default color 1\n"
"@default char size 1.0\n"
"@default font 4\n"
"@default font source 0\n"
"@default symbol size 1.0\n"
"@timestamp off\n"
"@timestamp 0.03, 0.03\n"
"@timestamp linewidth 1\n"
"@timestamp color 1\n"
"@timestamp rot 0\n"
"@timestamp font 4\n"
"@timestamp char size 1.0\n"
"@timestamp def \"Wed Nov 28 22:36:22 2001\"\n"
"@with g0\n"
"@g0 on\n"
"@g0 label off\n"
"@g0 hidden false\n"
"@g0 type xy\n"
"@g0 autoscale type AUTO\n"
"@g0 fixedpoint off\n"
"@g0 fixedpoint type 0\n"
"@g0 fixedpoint xy 0.0, 0.0\n"
"@g0 fixedpoint format general general\n"
"@g0 fixedpoint prec 6, 6\n"
"@ world xmin -5.5\n"
"@ world xmax 5.5\n"
"@ world ymin -32768\n"
"@ world ymax 32768\n"
"@ stack world 0, 0, 0, 0 tick 0, 0, 0, 0\n"
"@ view xmin 0.09\n"
"@ view xmax 0.98\n"
"@ view ymin 0.08\n"
"@ view ymax 0.90\n"
"@ title \"%*.*s\"\n"
"@ title font 4\n"
"@ title size 1.0\n"
"@ title color 1\n"
"@ title linewidth 1\n"
"@ subtitle \"(amplitude statistics)\"\n"
"@ subtitle font 4\n"
"@ subtitle size 0.64\n"
"@ subtitle color 1\n"
"@ subtitle linewidth 1\n"
"@ s0 symbol 0\n"
"@ s0 symbol size 1.0\n"
"@ s0 symbol fill 0\n"
"@ s0 symbol color -1\n"
"@ s0 symbol linewidth 1\n"
"@ s0 symbol linestyle 1\n"
"@ s0 symbol center false\n"
"@ s0 symbol char 0\n"
"@ s0 skip 0\n"
"@ s0 linestyle 1\n"
"@ s0 linewidth 1\n"
"@ s0 color 1\n"
"@ s0 fill 0\n"
"@ s0 fill with color\n"
"@ s0 fill color 1\n"
"@ s0 fill pattern 0\n"
"@ s0 errorbar type BOTH\n"
"@ s0 errorbar length 1.0\n"
"@ s0 errorbar linewidth 1\n"
"@ s0 errorbar linestyle 1\n"
"@ s0 errorbar riser on\n"
"@ s0 errorbar riser linewidth 1\n"
"@ s0 errorbar riser linestyle 1\n"
"@ s0 xyz 0.0, 0.0\n"
"@ s0 comment \"%*.*s\"\n"
"@ xaxis  tick on\n"
"@ xaxis  tick major 1\n"
"@ xaxis  tick minor 0.2\n"
"@ xaxis  tick offsetx 0.0\n"
"@ xaxis  tick offsety 0.0\n"
"@ xaxis  label \"deviation\"\n"
"@ xaxis  label layout para\n"
"@ xaxis  label place spec\n"
"@ xaxis  label place 0.0, 0.06\n"
"@ xaxis  label char size 0.80\n"
"@ xaxis  label font 4\n"
"@ xaxis  label color 1\n"
"@ xaxis  label linewidth 1\n"
"@ xaxis  ticklabel on\n"
"@ xaxis  ticklabel type auto\n"
"@ xaxis  ticklabel prec 5\n"
"@ xaxis  ticklabel format general\n"
"@ xaxis  ticklabel append \"s\"\n"
"@ xaxis  ticklabel prepend \"\"\n"
"@ xaxis  ticklabel layout horizontal\n"
"@ xaxis  ticklabel place on ticks\n"
"@ xaxis  ticklabel skip 0\n"
"@ xaxis  ticklabel stagger 0\n"
"@ xaxis  ticklabel op bottom\n"
"@ xaxis  ticklabel sign normal\n"
"@ xaxis  ticklabel start type spec\n"
"@ xaxis  ticklabel start -5.0\n"
"@ xaxis  ticklabel stop type spec\n"
"@ xaxis  ticklabel stop 5.0\n"
"@ xaxis  ticklabel char size 0.78\n"
"@ xaxis  ticklabel font 8\n"
"@ xaxis  ticklabel color 1\n"
"@ xaxis  ticklabel linewidth 1\n"
"@ xaxis  tick major on\n"
"@ xaxis  tick minor on\n"
"@ xaxis  tick default 6\n"
"@ xaxis  tick in\n"
"@ xaxis  tick major color 1\n"
"@ xaxis  tick major linewidth 1\n"
"@ xaxis  tick major linestyle 1\n"
"@ xaxis  tick minor color 7\n"
"@ xaxis  tick minor linewidth 1\n"
"@ xaxis  tick minor linestyle 1\n"
"@ xaxis  tick log off\n"
"@ xaxis  tick size 0.72\n"
"@ xaxis  tick minor size 0.48\n"
"@ xaxis  bar off\n"
"@ xaxis  bar color 1\n"
"@ xaxis  bar linestyle 1\n"
"@ xaxis  bar linewidth 1\n"
"@ xaxis  tick major grid off\n"
"@ xaxis  tick minor grid off\n"
"@ xaxis  tick op both\n"
"@ xaxis  tick type auto\n"
"@ xaxis  tick spec 0\n"
"@ yaxis  tick on\n"
"@ yaxis  tick major 8192\n"
"@ yaxis  tick minor 2048\n"
"@ yaxis  tick offsetx 0.0\n"
"@ yaxis  tick offsety 0.0\n"
"@ yaxis  label \"Level\"\n"
"@ yaxis  label layout para\n"
"@ yaxis  label place spec\n"
"@ yaxis  label place 0.065000, 0.0\n"
"@ yaxis  label char size 1.0\n"
"@ yaxis  label font 4\n"
"@ yaxis  label color 1\n"
"@ yaxis  label linewidth 1\n"
"@ yaxis  ticklabel on\n"
"@ yaxis  ticklabel type auto\n"
"@ yaxis  ticklabel prec 5\n"
"@ yaxis  ticklabel format general\n"
"@ yaxis  ticklabel append \"\"\n"
"@ yaxis  ticklabel prepend \"\"\n"
"@ yaxis  ticklabel layout horizontal\n"
"@ yaxis  ticklabel place on ticks\n"
"@ yaxis  ticklabel skip 0\n"
"@ yaxis  ticklabel stagger 0\n"
"@ yaxis  ticklabel op left\n"
"@ yaxis  ticklabel sign normal\n"
"@ yaxis  ticklabel start type auto\n"
"@ yaxis  ticklabel start 0.0\n"
"@ yaxis  ticklabel stop type auto\n"
"@ yaxis  ticklabel stop 0.0\n"
"@ yaxis  ticklabel char size 0.72\n"
"@ yaxis  ticklabel font 4\n"
"@ yaxis  ticklabel color 1\n"
"@ yaxis  ticklabel linewidth 1\n"
"@ yaxis  tick major on\n"
"@ yaxis  tick minor on\n"
"@ yaxis  tick default 6\n"
"@ yaxis  tick in\n"
"@ yaxis  tick major color 1\n"
"@ yaxis  tick major linewidth 1\n"
"@ yaxis  tick major linestyle 1\n"
"@ yaxis  tick minor color 7\n"
"@ yaxis  tick minor linewidth 1\n"
"@ yaxis  tick minor linestyle 1\n"
"@ yaxis  tick log off\n"
"@ yaxis  tick size 0.72\n"
"@ yaxis  tick minor size 0.48\n"
"@ yaxis  bar off\n"
"@ yaxis  bar color 1\n"
"@ yaxis  bar linestyle 1\n"
"@ yaxis  bar linewidth 1\n"
"@ yaxis  tick major grid off\n"
"@ yaxis  tick minor grid off\n"
"@ yaxis  tick op both\n"
"@ yaxis  tick type auto\n"
"@ yaxis  tick spec 0\n"
"@ zeroxaxis  tick on\n"
"@ zeroxaxis  tick major 5\n"
"@ zeroxaxis  tick minor 2.5\n"
"@ zeroxaxis  tick offsetx 0.0\n"
"@ zeroxaxis  tick offsety 0.0\n"
"@ zeroxaxis  label \"\"\n"
"@ zeroxaxis  label layout para\n"
"@ zeroxaxis  label place auto\n"
"@ zeroxaxis  label char size 1.0\n"
"@ zeroxaxis  label font 4\n"
"@ zeroxaxis  label color 1\n"
"@ zeroxaxis  label linewidth 1\n"
"@ zeroxaxis  ticklabel off\n"
"@ zeroxaxis  ticklabel type auto\n"
"@ zeroxaxis  ticklabel prec 5\n"
"@ zeroxaxis  ticklabel format general\n"
"@ zeroxaxis  ticklabel append \"\"\n"
"@ zeroxaxis  ticklabel prepend \"\"\n"
"@ zeroxaxis  ticklabel layout horizontal\n"
"@ zeroxaxis  ticklabel place on ticks\n"
"@ zeroxaxis  ticklabel skip 0\n"
"@ zeroxaxis  ticklabel stagger 0\n"
"@ zeroxaxis  ticklabel op bottom\n"
"@ zeroxaxis  ticklabel sign normal\n"
"@ zeroxaxis  ticklabel start type auto\n"
"@ zeroxaxis  ticklabel start 0.0\n"
"@ zeroxaxis  ticklabel stop type auto\n"
"@ zeroxaxis  ticklabel stop 0.0\n"
"@ zeroxaxis  ticklabel char size 1.0\n"
"@ zeroxaxis  ticklabel font 4\n"
"@ zeroxaxis  ticklabel color 1\n"
"@ zeroxaxis  ticklabel linewidth 1\n"
"@ zeroxaxis  tick major off\n"
"@ zeroxaxis  tick minor on\n"
"@ zeroxaxis  tick default 6\n"
"@ zeroxaxis  tick in\n"
"@ zeroxaxis  tick major color 1\n"
"@ zeroxaxis  tick major linewidth 1\n"
"@ zeroxaxis  tick major linestyle 1\n"
"@ zeroxaxis  tick minor color 7\n"
"@ zeroxaxis  tick minor linewidth 1\n"
"@ zeroxaxis  tick minor linestyle 1\n"
"@ zeroxaxis  tick log off\n"
"@ zeroxaxis  tick size 0.72\n"
"@ zeroxaxis  tick minor size 0.48\n"
"@ zeroxaxis  bar off\n"
"@ zeroxaxis  bar color 1\n"
"@ zeroxaxis  bar linestyle 1\n"
"@ zeroxaxis  bar linewidth 1\n"
"@ zeroxaxis  tick major grid off\n"
"@ zeroxaxis  tick minor grid off\n"
"@ zeroxaxis  tick op both\n"
"@ zeroxaxis  tick type auto\n"
"@ zeroxaxis  tick spec 0\n"
"@ zeroyaxis  tick on\n"
"@ zeroyaxis  tick major 20000\n"
"@ zeroyaxis  tick minor 10000\n"
"@ zeroyaxis  tick offsetx 0.0\n"
"@ zeroyaxis  tick offsety 0.0\n"
"@ zeroyaxis  label \"\"\n"
"@ zeroyaxis  label layout para\n"
"@ zeroyaxis  label place auto\n"
"@ zeroyaxis  label char size 1.0\n"
"@ zeroyaxis  label font 4\n"
"@ zeroyaxis  label color 1\n"
"@ zeroyaxis  label linewidth 1\n"
"@ zeroyaxis  ticklabel off\n"
"@ zeroyaxis  ticklabel type auto\n"
"@ zeroyaxis  ticklabel prec 5\n"
"@ zeroyaxis  ticklabel format general\n"
"@ zeroyaxis  ticklabel append \"\"\n"
"@ zeroyaxis  ticklabel prepend \"\"\n"
"@ zeroyaxis  ticklabel layout horizontal\n"
"@ zeroyaxis  ticklabel place on ticks\n"
"@ zeroyaxis  ticklabel skip 0\n"
"@ zeroyaxis  ticklabel stagger 0\n"
"@ zeroyaxis  ticklabel op left\n"
"@ zeroyaxis  ticklabel sign normal\n"
"@ zeroyaxis  ticklabel start type auto\n"
"@ zeroyaxis  ticklabel start 0.0\n"
"@ zeroyaxis  ticklabel stop type auto\n"
"@ zeroyaxis  ticklabel stop 0.0\n"
"@ zeroyaxis  ticklabel char size 1.0\n"
"@ zeroyaxis  ticklabel font 4\n"
"@ zeroyaxis  ticklabel color 1\n"
"@ zeroyaxis  ticklabel linewidth 1\n"
"@ zeroyaxis  tick major off\n"
"@ zeroyaxis  tick minor on\n"
"@ zeroyaxis  tick default 6\n"
"@ zeroyaxis  tick in\n"
"@ zeroyaxis  tick major color 1\n"
"@ zeroyaxis  tick major linewidth 1\n"
"@ zeroyaxis  tick major linestyle 1\n"
"@ zeroyaxis  tick minor color 7\n"
"@ zeroyaxis  tick minor linewidth 1\n"
"@ zeroyaxis  tick minor linestyle 1\n"
"@ zeroyaxis  tick log off\n"
"@ zeroyaxis  tick size 0.72\n"
"@ zeroyaxis  tick minor size 0.48\n"
"@ zeroyaxis  bar off\n"
"@ zeroyaxis  bar color 1\n"
"@ zeroyaxis  bar linestyle 1\n"
"@ zeroyaxis  bar linewidth 1\n"
"@ zeroyaxis  tick major grid off\n"
"@ zeroyaxis  tick minor grid off\n"
"@ zeroyaxis  tick op both\n"
"@ zeroyaxis  tick type auto\n"
"@ zeroyaxis  tick spec 0\n"
"@ legend on\n"
"@ legend loctype view\n"
"@ legend layout 0\n"
"@ legend vgap 2\n"
"@ legend hgap 1\n"
"@ legend length 4\n"
"@ legend box on\n"
"@ legend box fill on\n"
"@ legend box fill with color\n"
"@ legend box fill color 0\n"
"@ legend box fill pattern 1\n"
"@ legend box color 1\n"
"@ legend box linewidth 1\n"
"@ legend box linestyle 1\n"
"@ legend x1 0.2\n"
"@ legend y1 0.8\n"
"@ legend font 4\n"
"@ legend char size 0.5\n"
"@ legend linestyle 1\n"
"@ legend linewidth 1\n"
"@ legend color 1\n"
"@ frame on\n"
"@ frame type 0\n"
"@ frame linestyle 1\n"
"@ frame linewidth 1\n"
"@ frame color 1\n"
"@ frame fill off\n"
"@ frame background color 0\n"
"@WITH G0\n"
"@G0 ON\n"
"@TARGET S0\n"
"@TYPE xy\n"
;

const char __2 [] =
"#\n"
"# ACE/gr parameter file\n"
"#\n"
"@version 40102\n"
"@page layout free\n"
"@ps linewidth begin 1\n"
"@ps linewidth increment 2\n"
"@hardcopy device 1\n"
"@page 5\n"
"@page inout 5\n"
"@link page off\n"
"@default linestyle 1\n"
"@default linewidth 1\n"
"@default color 1\n"
"@default char size 1.0\n"
"@default font 4\n"
"@default font source 0\n"
"@default symbol size 1.0\n"
"@timestamp off\n"
"@timestamp 0.03, 0.03\n"
"@timestamp linewidth 1\n"
"@timestamp color 1\n"
"@timestamp rot 0\n"
"@timestamp font 4\n"
"@timestamp char size 1.0\n"
"@timestamp def \"Wed Nov 28 22:36:22 2001\"\n"
"@with g0\n"
"@g0 on\n"
"@g0 label off\n"
"@g0 hidden false\n"
"@g0 type xy\n"
"@g0 autoscale type AUTO\n"
"@g0 fixedpoint off\n"
"@g0 fixedpoint type 0\n"
"@g0 fixedpoint xy 0.0, 0.0\n"
"@g0 fixedpoint format general general\n"
"@g0 fixedpoint prec 6, 6\n"
"@ world xmin -33500\n"
"@ world xmax 33500\n"
"@ world ymin 0\n"
"@ world ymax %f\n"
"@ stack world 0, 0, 0, 0 tick 0, 0, 0, 0\n"
"@ view xmin 0.09\n"
"@ view xmax 0.98\n"
"@ view ymin 0.08\n"
"@ view ymax 0.90\n"
"@ title \"%*.*s\"\n"
"@ title font 4\n"
"@ title size 1.0\n"
"@ title color 1\n"
"@ title linewidth 1\n"
"@ subtitle \"(amplitude statistics)\"\n"
"@ subtitle font 4\n"
"@ subtitle size 0.64\n"
"@ subtitle color 1\n"
"@ subtitle linewidth 1\n"
"@ s0 symbol 0\n"
"@ s0 symbol size 1.0\n"
"@ s0 symbol fill 0\n"
"@ s0 symbol color -1\n"
"@ s0 symbol linewidth 1\n"
"@ s0 symbol linestyle 1\n"
"@ s0 symbol center false\n"
"@ s0 symbol char 0\n"
"@ s0 skip 0\n"
"@ s0 linestyle 1\n"
"@ s0 linewidth 1\n"
"@ s0 color 1\n"
"@ s0 fill 0\n"
"@ s0 fill with color\n"
"@ s0 fill color 1\n"
"@ s0 fill pattern 0\n"
"@ s0 errorbar type BOTH\n"
"@ s0 errorbar length 1.0\n"
"@ s0 errorbar linewidth 1\n"
"@ s0 errorbar linestyle 1\n"
"@ s0 errorbar riser on\n"
"@ s0 errorbar riser linewidth 1\n"
"@ s0 errorbar riser linestyle 1\n"
"@ s0 xyz 0.0, 0.0\n"
"@ s0 comment \"%*.*s\"\n"
"@ xaxis  tick on\n"
"@ xaxis  tick major 8192\n"
"@ xaxis  tick minor 2048\n"
"@ xaxis  tick offsetx 0.0\n"
"@ xaxis  tick offsety 0.0\n"
"@ xaxis  label \"Level\"\n"
"@ xaxis  label layout para\n"
"@ xaxis  label place spec\n"
"@ xaxis  label place 0.0, 0.06\n"
"@ xaxis  label char size 0.80\n"
"@ xaxis  label font 4\n"
"@ xaxis  label color 1\n"
"@ xaxis  label linewidth 1\n"
"@ xaxis  ticklabel on\n"
"@ xaxis  ticklabel type auto\n"
"@ xaxis  ticklabel prec 5\n"
"@ xaxis  ticklabel format general\n"
"@ xaxis  ticklabel append \"\"\n"
"@ xaxis  ticklabel prepend \"\"\n"
"@ xaxis  ticklabel layout horizontal\n"
"@ xaxis  ticklabel place on ticks\n"
"@ xaxis  ticklabel skip 0\n"
"@ xaxis  ticklabel stagger 0\n"
"@ xaxis  ticklabel op bottom\n"
"@ xaxis  ticklabel sign normal\n"
"@ xaxis  ticklabel start type spec\n"
"@ xaxis  ticklabel start -32768\n"
"@ xaxis  ticklabel stop type spec\n"
"@ xaxis  ticklabel stop 32768\n"
"@ xaxis  ticklabel char size 0.78\n"
"@ xaxis  ticklabel font 8\n"
"@ xaxis  ticklabel color 1\n"
"@ xaxis  ticklabel linewidth 1\n"
"@ xaxis  tick major on\n"
"@ xaxis  tick minor on\n"
"@ xaxis  tick default 6\n"
"@ xaxis  tick out\n"
"@ xaxis  tick major color 1\n"
"@ xaxis  tick major linewidth 1\n"
"@ xaxis  tick major linestyle 1\n"
"@ xaxis  tick minor color 7\n"
"@ xaxis  tick minor linewidth 1\n"
"@ xaxis  tick minor linestyle 1\n"
"@ xaxis  tick log off\n"
"@ xaxis  tick size 0.72\n"
"@ xaxis  tick minor size 0.48\n"
"@ xaxis  bar off\n"
"@ xaxis  bar color 1\n"
"@ xaxis  bar linestyle 1\n"
"@ xaxis  bar linewidth 1\n"
"@ xaxis  tick major grid off\n"
"@ xaxis  tick minor grid off\n"
"@ xaxis  tick op both\n"
"@ xaxis  tick type auto\n"
"@ xaxis  tick spec 0\n"
"@ yaxis  tick on\n"
"@ yaxis  tick major 1\n"
"@ yaxis  tick minor 0.2\n"
"@ yaxis  tick offsetx 0.0\n"
"@ yaxis  tick offsety 0.0\n"
"@ yaxis  label \"rel. Abundance\"\n"
"@ yaxis  label layout para\n"
"@ yaxis  label place spec\n"
"@ yaxis  label place 0.065000, 0.0\n"
"@ yaxis  label char size 1.0\n"
"@ yaxis  label font 4\n"
"@ yaxis  label color 1\n"
"@ yaxis  label linewidth 1\n"
"@ yaxis  ticklabel on\n"
"@ yaxis  ticklabel type auto\n"
"@ yaxis  ticklabel prec 5\n"
"@ yaxis  ticklabel format general\n"
"@ yaxis  ticklabel append \"**2\"\n"
"@ yaxis  ticklabel prepend \"\"\n"
"@ yaxis  ticklabel layout horizontal\n"
"@ yaxis  ticklabel place on ticks\n"
"@ yaxis  ticklabel skip 0\n"
"@ yaxis  ticklabel stagger 0\n"
"@ yaxis  ticklabel op left\n"
"@ yaxis  ticklabel sign normal\n"
"@ yaxis  ticklabel start type auto\n"
"@ yaxis  ticklabel start 0.0\n"
"@ yaxis  ticklabel stop type auto\n"
"@ yaxis  ticklabel stop 0.0\n"
"@ yaxis  ticklabel char size 0.72\n"
"@ yaxis  ticklabel font 4\n"
"@ yaxis  ticklabel color 1\n"
"@ yaxis  ticklabel linewidth 1\n"
"@ yaxis  tick major on\n"
"@ yaxis  tick minor on\n"
"@ yaxis  tick default 6\n"
"@ yaxis  tick in\n"
"@ yaxis  tick major color 1\n"
"@ yaxis  tick major linewidth 1\n"
"@ yaxis  tick major linestyle 1\n"
"@ yaxis  tick minor color 7\n"
"@ yaxis  tick minor linewidth 1\n"
"@ yaxis  tick minor linestyle 1\n"
"@ yaxis  tick log off\n"
"@ yaxis  tick size 0.72\n"
"@ yaxis  tick minor size 0.48\n"
"@ yaxis  bar off\n"
"@ yaxis  bar color 1\n"
"@ yaxis  bar linestyle 1\n"
"@ yaxis  bar linewidth 1\n"
"@ yaxis  tick major grid off\n"
"@ yaxis  tick minor grid off\n"
"@ yaxis  tick op both\n"
"@ yaxis  tick type auto\n"
"@ yaxis  tick spec 0\n"
"@ zeroxaxis  tick on\n"
"@ zeroxaxis  tick major 5\n"
"@ zeroxaxis  tick minor 2.5\n"
"@ zeroxaxis  tick offsetx 0.0\n"
"@ zeroxaxis  tick offsety 0.0\n"
"@ zeroxaxis  label \"\"\n"
"@ zeroxaxis  label layout para\n"
"@ zeroxaxis  label place auto\n"
"@ zeroxaxis  label char size 1.0\n"
"@ zeroxaxis  label font 4\n"
"@ zeroxaxis  label color 1\n"
"@ zeroxaxis  label linewidth 1\n"
"@ zeroxaxis  ticklabel off\n"
"@ zeroxaxis  ticklabel type auto\n"
"@ zeroxaxis  ticklabel prec 5\n"
"@ zeroxaxis  ticklabel format general\n"
"@ zeroxaxis  ticklabel append \"\"\n"
"@ zeroxaxis  ticklabel prepend \"\"\n"
"@ zeroxaxis  ticklabel layout horizontal\n"
"@ zeroxaxis  ticklabel place on ticks\n"
"@ zeroxaxis  ticklabel skip 0\n"
"@ zeroxaxis  ticklabel stagger 0\n"
"@ zeroxaxis  ticklabel op bottom\n"
"@ zeroxaxis  ticklabel sign normal\n"
"@ zeroxaxis  ticklabel start type auto\n"
"@ zeroxaxis  ticklabel start 0.0\n"
"@ zeroxaxis  ticklabel stop type auto\n"
"@ zeroxaxis  ticklabel stop 0.0\n"
"@ zeroxaxis  ticklabel char size 1.0\n"
"@ zeroxaxis  ticklabel font 4\n"
"@ zeroxaxis  ticklabel color 1\n"
"@ zeroxaxis  ticklabel linewidth 1\n"
"@ zeroxaxis  tick major off\n"
"@ zeroxaxis  tick minor on\n"
"@ zeroxaxis  tick default 6\n"
"@ zeroxaxis  tick out\n"
"@ zeroxaxis  tick major color 1\n"
"@ zeroxaxis  tick major linewidth 1\n"
"@ zeroxaxis  tick major linestyle 1\n"
"@ zeroxaxis  tick minor color 7\n"
"@ zeroxaxis  tick minor linewidth 1\n"
"@ zeroxaxis  tick minor linestyle 1\n"
"@ zeroxaxis  tick log off\n"
"@ zeroxaxis  tick size 0.72\n"
"@ zeroxaxis  tick minor size 0.48\n"
"@ zeroxaxis  bar off\n"
"@ zeroxaxis  bar color 1\n"
"@ zeroxaxis  bar linestyle 1\n"
"@ zeroxaxis  bar linewidth 1\n"
"@ zeroxaxis  tick major grid off\n"
"@ zeroxaxis  tick minor grid off\n"
"@ zeroxaxis  tick op both\n"
"@ zeroxaxis  tick type auto\n"
"@ zeroxaxis  tick spec 0\n"
"@ zeroyaxis  tick on\n"
"@ zeroyaxis  tick major 5\n"
"@ zeroyaxis  tick minor 2.5\n"
"@ zeroyaxis  tick offsetx 0.0\n"
"@ zeroyaxis  tick offsety 0.0\n"
"@ zeroyaxis  label \"\"\n"
"@ zeroyaxis  label layout para\n"
"@ zeroyaxis  label place auto\n"
"@ zeroyaxis  label char size 1.0\n"
"@ zeroyaxis  label font 4\n"
"@ zeroyaxis  label color 1\n"
"@ zeroyaxis  label linewidth 1\n"
"@ zeroyaxis  ticklabel off\n"
"@ zeroyaxis  ticklabel type auto\n"
"@ zeroyaxis  ticklabel prec 5\n"
"@ zeroyaxis  ticklabel format general\n"
"@ zeroyaxis  ticklabel append \"\"\n"
"@ zeroyaxis  ticklabel prepend \"\"\n"
"@ zeroyaxis  ticklabel layout horizontal\n"
"@ zeroyaxis  ticklabel place on ticks\n"
"@ zeroyaxis  ticklabel skip 0\n"
"@ zeroyaxis  ticklabel stagger 0\n"
"@ zeroyaxis  ticklabel op left\n"
"@ zeroyaxis  ticklabel sign normal\n"
"@ zeroyaxis  ticklabel start type auto\n"
"@ zeroyaxis  ticklabel start 0.0\n"
"@ zeroyaxis  ticklabel stop type auto\n"
"@ zeroyaxis  ticklabel stop 0.0\n"
"@ zeroyaxis  ticklabel char size 1.0\n"
"@ zeroyaxis  ticklabel font 4\n"
"@ zeroyaxis  ticklabel color 1\n"
"@ zeroyaxis  ticklabel linewidth 1\n"
"@ zeroyaxis  tick major off\n"
"@ zeroyaxis  tick minor on\n"
"@ zeroyaxis  tick default 6\n"
"@ zeroyaxis  tick in\n"
"@ zeroyaxis  tick major color 1\n"
"@ zeroyaxis  tick major linewidth 1\n"
"@ zeroyaxis  tick major linestyle 1\n"
"@ zeroyaxis  tick minor color 7\n"
"@ zeroyaxis  tick minor linewidth 1\n"
"@ zeroyaxis  tick minor linestyle 1\n"
"@ zeroyaxis  tick log off\n"
"@ zeroyaxis  tick size 0.72\n"
"@ zeroyaxis  tick minor size 0.48\n"
"@ zeroyaxis  bar off\n"
"@ zeroyaxis  bar color 1\n"
"@ zeroyaxis  bar linestyle 1\n"
"@ zeroyaxis  bar linewidth 1\n"
"@ zeroyaxis  tick major grid off\n"
"@ zeroyaxis  tick minor grid off\n"
"@ zeroyaxis  tick op both\n"
"@ zeroyaxis  tick type auto\n"
"@ zeroyaxis  tick spec 0\n"
"@ legend on\n"
"@ legend loctype view\n"
"@ legend layout 0\n"
"@ legend vgap 2\n"
"@ legend hgap 1\n"
"@ legend length 4\n"
"@ legend box on\n"
"@ legend box fill on\n"
"@ legend box fill with color\n"
"@ legend box fill color 0\n"
"@ legend box fill pattern 1\n"
"@ legend box color 1\n"
"@ legend box linewidth 1\n"
"@ legend box linestyle 1\n"
"@ legend x1 0.2\n"
"@ legend y1 0.8\n"
"@ legend font 4\n"
"@ legend char size 0.5\n"
"@ legend linestyle 1\n"
"@ legend linewidth 1\n"
"@ legend color 1\n"
"@ frame on\n"
"@ frame type 0\n"
"@ frame linestyle 1\n"
"@ frame linewidth 1\n"
"@ frame color 1\n"
"@ frame fill off\n"
"@ frame background color 0\n"
"@WITH G0\n"
"@G0 ON\n"
"@TARGET S0\n"
"@TYPE xy\n"
;


const char __9 [] =
"&\n";


#if defined HAVE_INCOMPLETE_READ  &&  FILEIO != 1

size_t
complete_read ( int fd, void* dest, size_t bytes )
{
    size_t  bytesread = 0;
    size_t  ret;

    while ( bytes > 0 ) {
        ret = read ( fd, dest, bytes );
        if ( ret == 0  ||  ret == (size_t)-1 )
            break;
        dest       = (void*)(((char*)dest) + ret);
        bytes     -= ret;
        bytesread += ret;
    }
    return bytesread;
}

#endif


static int
Stat ( const char* filename, Uint8_t p[4][65536] )
{
    FILE*          fp;
    Int16_t        buff [2048];
    Uint32_t       header [11];
    size_t         len;
    size_t         i;
    Uint16_t       val;
    unsigned long  samples = -1;
    unsigned long  sread   =  0;
    char*          ext = NULL==strrchr (filename, '.')  ?  ""  :  strrchr (filename, '.') + 1;

    if ( 0 == strcasecmp (ext, "pac") ) {
        if ((fp = pipeopen ( "lpac -x -o #", filename)) == NULL) {
            stderr_printf ( "Can't decode '%s'\n", filename );
            exit (9);
        } else {
            stderr_printf ( "PAC-File: %s", filename );
            if (fread ( header, 4, 11, fp ) != 11 )
                return -1;
            samples = header[10] / 2;
        }
    }
    else if ( 0 == strcasecmp (ext, "mpc")  ||  0 == strcasecmp (ext, "mp+")  ||  0 == strcasecmp (ext, "mpp") ) {
        if ((fp = pipeopen ( "mppdec --silent - - < #", filename)) == NULL) {
            stderr_printf ( "Can't decode '%s'\n", filename );
            exit (9);
        } else {
            stderr_printf ( "MPEGplus-File: %s", filename );
            if (fread ( header, 4, 11, fp ) != 11 )
                return -1;
        }
    }
    else if ( 0 == strcmp (ext, "mp3") ) {
        if ((fp = pipeopen ( "mpg123 --quiet --stereo --wav - # 2> /dev/null", filename)) == NULL) {
            stderr_printf ( "Can't decode '%s'\n", filename );
            exit (9);
        } else {
            stderr_printf ( "MP3-File: %s", filename );
            if (fread ( header, 4, 11, fp ) != 11 )
                return -1;
        }
    }
    else if ( 0 == strcmp (ext, "wav") ) {
        if ((fp = fopen ( filename, "rb" )) == NULL) {
            stderr_printf ( "Can't open '%s'\n", filename );
            exit (9);
        } else {
            stderr_printf ( "Wav-File: %s", filename );
            if (fread ( header, 4, 11, fp ) != 11 )
                return -1;
            samples = header[10] / 2;
        }
    }
    else if ( 0 == strcmp (filename, "-") ) {
        fp = stdin;
        stderr_printf ( "Unknown Format: stdin" );
    }
    else {
        if ((fp = fopen ( filename, "rb" )) == NULL) {
            stderr_printf ( "Can't open '%s'\n", filename );
            exit (9);
        } else {
            stderr_printf ( "Unknown Format: %s", filename );
        }
    }

    if ( (Uint32_t)-1 != samples )
        stderr_printf ( " (%lu.%03lu.%03lu samples) ", samples/1000000/2, samples/1000/2 % 1000, samples/2 % 1000 );
    else
        stderr_printf ( " (unknown number of samples) ");

    memset ( p, 0, 4 * 65536 );

    while (( len = fread (buff, 2, samples < sizeof(buff)/sizeof(*buff) ? samples : sizeof(buff)/sizeof(*buff), fp) ) > 0 ) {
        samples -= len;
        sread   += len;
        for ( i = 0; i < len; i++ ) {
            val = (Uint16_t) buff[i];
            if (++p[0][val] == 0)
                if (++p[1][val] == 0)
                    if (++p[2][val] == 0)
                        ++p[3][val];
        }
        if ( sread % 5242880 == 0 )
            stderr_printf ( "*");
    }

    stderr_printf ( "\n");
    PCLOSE (fp);
    return 0;
}


static double
inverfc (double x )
{
#ifdef _WIN32
    return dierfc (x) * sqrt (2.);
#else
    double  ret = 0;
    int     i;

    if ( x > 1 )
        return -inverfc (2.-x);

    for ( i = 0; i < 32; i++ ) {
        if ( erfc (ret + 4./(1LU<<i)) >= x )
            ret += 4. / (1LU << i);
    }

    return ret * sqrt(2.);
#endif
}

static void
analyseFile ( const char* name )
{
    Uint8_t  p [4] [65536];
    long     __q   [65536];
    long*    q = __q + 32768;
    long     qmax;
    double   __s   [65536];
    double*  s = __s + 32768;
    long     i;
    double   tot;
    double   sum;
    char     dstname [1024];
    int      len = NULL==strrchr (name, '.')  ?  strlen (name)  :  strrchr (name, '.') - name;

    if ( Stat (name, p) < 0 )
        return;

    for ( i = 0; i < 65536; i++ )
        __q [(Uint16_t)(i+0x8000)] = p[0][i] + 256*p[1][i] + 65536*p[2][i] + 16777216*p[3][i];

    sum = 0.;
    for ( i = -32768; i < 32768; i++ ) {
        s[i] = 2. * sum + q[i];
        sum += q[i];
    }
    tot = sum;
    for ( i = 32767; i >= 0; i-- ) {
        s[i] = 2. * sum - q[i];
        sum -= q[i];
    }

    sprintf (dstname, DIRECTORY"/%*.*s.xmgr-1", len, len, name );
    if ( NULL == freopen (dstname, "w", stdout) ) {
        stderr_printf ("Can't create '%s'\n", dstname);
        return;
    }

    printf ( __1, len, len, name, len, len, name );
    for ( i = -32768; i < 32768; i++ ) {
        if ( s[i-1] != s[i]  ||  s[i] != s[i+1] )
            printf ( "%7.4f\t%6ld\n", inverfc (s[i] / tot), -i );
    }
    puts (__9);

#ifdef GNUPLOT
    sprintf ( dstname, DIRECTORY"/%s", GetTitleFromFilename (name) );
    if ( NULL == freopen (dstname, "w", stdout) ) {
        stderr_printf ( "Can't create '%s'\n", dstname );
        return;
    }
    for ( i = -32768; i < 32768; i++ ) {
        if ( s[i-1] != s[i]  ||  s[i] != s[i+1] )
            printf ( "%7.4f\t%6ld\n", inverfc (s[i] / tot), -i );
    }
#endif

    sprintf ( dstname, DIRECTORY"/%s.xmgr-2", GetTitleFromFilename (name) );
    if ( NULL == freopen (dstname, "w", stdout) ) {
        stderr_printf ( "Can't create '%s'\n", dstname );
        return;
    }
    qmax = 0;
    for ( i = -32768; i < 32768; i += i != -64 ? 1 : 128 ) {
        if ( q[i] > qmax )
            qmax = q[i];
    }
    printf ( __2, 256.*1.01/sqrt(sum) * (sqrt ( (qmax+1)) - 1 ), len, len, name, len, len, name );
    for ( i = -32768; i < 32768;  i++ ) {
        double tmp = abs(i) < 32 ? (q[32]*(i+32) + q[-32]*(32-i))/64. : q[i];
        printf ( "%6ld\t%8.6f\n", i, 256. / sqrt(sum) * ( sqrt(tmp+1) - 1 ) );
    }
    puts (__9);

    fflush (stdout);
    return;
}


int Cdecl
main ( int argc, char** argv )
{
    int  i;

    MKDIR (DIRECTORY, 0777);

    for ( i = 1; i < argc; i++ )
        analyseFile ( argv [i] );

#ifdef GNUPLOT
    return gnuplot ( argc, argv );
#endif

    return 0;
}

/* end of stat.c */
