#include <stdio.h>
#include <windows.h>

/*
int
MultiByteToWideChar ( UINT      CodePage,           // code page
                      DWORD     dwFlags,            // character-type options
                      LPCSTR    lpMultiByteStr,     // address of string to map
                      int       cchMultiByte,       // number of bytes in string
                      LPWSTR    lpWideCharStr,      // address of wide-character buffer
                      int       cchWideChar         // size of buffer
);
*/

void
test ( int CP )
{
    int      i;
    int      j;
    char     b [16];
    wchar_t  a [ 8];
    int      count = 0;

    fprintf (stderr, "Codepage %u\n", CP );

    for ( i = 1; i < 256; i++ ) {
        b [0] = i;
        if ( i == 2  &&  count == 0 )
            return;
        if ( 1 == MultiByteToWideChar ( CP, 0, b, 1, a, 8 )  &&  a[0] != 0 ) {
            if ( count == 0 )
                printf ("\n\n\n****** CP-%u ******\n\n", CP );
            printf ("CP-%-4u    %02X  u%04X\n", CP, i, a[0] );
            count++;
        } else {
            for ( j = 1; j < 256; j++ ) {
                b [0] = i;
                b [1] = j;
                // printf ("\r%02u %02u", i, j );
                if ( 1 == MultiByteToWideChar ( CP, 0, b, 2, a, 8 )  &&  a[0] != 0x30FB ) {
                    if ( count == 0 )
                        printf ("\n\n\n****** CP-%u ******\n\n", CP );
                    printf ("CP-%-4u  %02X%02X  u%04X\n", CP, i, j, a[0] ),
                    count++;
                }
            }
        }
    }

    fflush ( stdout);
}

int
main ( int argc, char** argv )
{
    int  i;

    freopen ( "codepage.txt", "w", stdout );

    for ( i = 0; i <= 11000; i++ )
        test ( i );

   return 0;
}
