
#if  DUMPSELECT > 0

static Int
digits ( Int no )
{
    if (no >= 0) {
        if ( no <=     9 ) return 1;
        if ( no <=    99 ) return 2;
        if ( no <=   999 ) return 3;
        if ( no <=  9999 ) return 4;
        return 5;
    } else {
        if ( no >=    -9 ) return 2;
        if ( no >=   -99 ) return 3;
        if ( no >=  -999 ) return 4;
        if ( no >= -9999 ) return 5;
        return 6;
    }
}


static void
Dump ( Int                Max_Used_Band,
       const Bool_t*      MS_Band,
       const CPair_t*     Res,
       const CPairArray*  SCF_Index,
       const Quant_t*     Q,
       Int                SV,
       const Ulong*       bitpostab )
{
    static Ulong     Frame= 0;
    static FILE*     fp0  = NULL;
    static FILE*     fp1  = NULL;
    static FILE*     fp2  = NULL;
    static FILE*     fp3  = NULL;
    static FILE*     fp4  = NULL;
    static FILE*     fp5  = NULL;
    static FILE*     fp6  = NULL;
    static FILE*     fp7  = NULL;
    static Int       Init = 0;
    static Uint32_t  Bits = (Uint32_t)-1;
    Int              Band;
    Int              i;
    Int              k;
    Int              d;

    if ( Init == 0 ) {
        fp0  = fopen ( LOGPATH "report-maxband.txt", "a" );
        fp1  = fopen ( LOGPATH "report-msbits.txt" , "a" );
        fp2  = fopen ( LOGPATH "report-resol.txt"  , "a" );
        fp3  = fopen ( LOGPATH "report-scf.txt"    , "a" );
        fp4  = fopen ( LOGPATH "report-quant.txt"  , "a" );
        fp5  = fopen ( LOGPATH "report-rate.txt"   , "a" );
        fp6  = fopen ( LOGPATH "report-usage.txt"  , "a" );
        fp7  = fopen ( LOGPATH "report-requant.txt", "a" );
        Init = 1;
    }

    // Stop if 400 MByte has been dumped for each log file
    if ( fp0 != NULL  &&  ftell (fp0) > 409600000 ) fp0 = NULL;
    if ( fp1 != NULL  &&  ftell (fp1) > 409600000 ) fp1 = NULL;
    if ( fp2 != NULL  &&  ftell (fp2) > 409600000 ) fp2 = NULL;
    if ( fp3 != NULL  &&  ftell (fp3) > 409600000 ) fp3 = NULL;
    if ( fp4 != NULL  &&  ftell (fp4) > 409600000 ) fp4 = NULL;
    if ( fp5 != NULL  &&  ftell (fp5) > 409600000 ) fp5 = NULL;
    if ( fp6 != NULL  &&  ftell (fp6) > 409600000 ) fp6 = NULL;

    // last used band
    if ((DUMPSELECT & 1)  &&  fp0 != NULL) {
        fprintf ( fp0, "%4lu\t%2d\n", Frame, Max_Used_Band );
    }

    // last used band + MS bits for every band
    if ((DUMPSELECT & 2)  &&  fp1 != NULL) {
        fprintf ( fp1, "%4lu\t%2d\t", Frame, Max_Used_Band );
        for ( Band = 0; Band <= Max_Used_Band; Band++ )
            if ( Res[Band].L  ||  Res[Band].R )
                fprintf ( fp1, MS_Band[Band] ? "#" : "." );
            else
                fprintf ( fp1, " " );
        fprintf ( fp1, "\n" );
    }

    // Resolution for every band and channel AND also MS bits
    if ((DUMPSELECT & 4)  &&  fp2 != NULL) {
        fprintf ( fp2, "--- %4lu ---\n", Frame );
        for ( Band = 0; Band <= Max_Used_Band; Band++ )
            if ( Res[Band].L )
                fprintf ( fp2, " %2d", Res[Band].L );
            else
                fprintf ( fp2, "   " );
        fprintf ( fp2, "\n" );
        for ( Band = 0; Band <= Max_Used_Band; Band++ )
            if ( Res[Band].R )
                fprintf ( fp2, " %2d", Res[Band].R );
            else
                fprintf ( fp2, "   " );
        fprintf ( fp2, "\n" );
        for ( Band = 0; Band <= Max_Used_Band; Band++ )
            if ( Res[Band].L  ||  Res[Band].R )
                fprintf ( fp2, "  %c", MS_Band[Band] ? '#' : '.' );
            else
                fprintf ( fp2, "   " );
        fprintf ( fp2, "\n\n" );
    }

    // SCF for every channel, subframe and subband
    if ((DUMPSELECT & 8)  &&  fp3 != NULL) {
        fprintf ( fp3, "--- %4lu ---\n", Frame );
        for ( i = 0; i < 3; i++ ) {
            for ( Band = 0; Band <= Max_Used_Band; Band++ )
                if ( Res[Band].L )
                    fprintf ( fp3, " %2d", SV > 7  ?  SCF_Index[i][Band].L  :  63 - SCF_Index[i][Band].L );
                else
                    fprintf ( fp3, "   " );
            fprintf ( fp3, "\n" );
        }
        for ( i = 0; i < 3; i++ ) {
            for ( Band = 0; Band <= Max_Used_Band; Band++ )
                if ( Res[Band].R )
                    fprintf ( fp3, " %2d", SV > 7  ?  SCF_Index[i][Band].R  :  63 - SCF_Index[i][Band].R );
                else
                    fprintf ( fp3, "   " );
            fprintf ( fp3, "\n" );
        }
        fprintf ( fp3, "\n" );
    }

    // quantized subband samples
    if ((DUMPSELECT & 16)  &&  fp4 != NULL) {
        int  max = 0;

        fprintf ( fp4, "--- %4lu ---\n", Frame );
        for (k=0; k<36; k++) {
            d = digits (Q[0].L[k]); if ( d > max ) max = d;
            d = digits (Q[0].R[k]); if ( d > max ) max = d;
            for ( Band = 1; Band <= Max_Used_Band; Band++ ) {
                d = 1+digits (Q[Band].L[k]); if ( d > max ) max = d;
                d = 1+digits (Q[Band].R[k]); if ( d > max ) max = d;
            }
        }
        for (k=0; k<36; k++) {
            for ( Band = 0; Band <= Max_Used_Band; Band++ )
                if ( Res[Band].L )
                    fprintf ( fp4, "%*d", max, Q[Band].L[k] );
                else
                    fprintf ( fp4, "%*s", max, "" );
            fprintf ( fp4, "\n");
        }
        fprintf ( fp4, "\n");
        for ( k=0; k<36; k++) {
            for ( Band = 0; Band <= Max_Used_Band; Band++ )
                if ( Res[Band].R )
                    fprintf ( fp4, "%*d", max, Q[Band].R[k] );
                else
                    fprintf ( fp4, "%*s", max, "" );
            fprintf ( fp4, "\n");
        }
        fprintf ( fp4, "\n\n");
    }

    // block size and bitrate
    if ((DUMPSELECT & 32)  &&  fp5 != NULL) {
        if ( Bits > BitsRead () ) Bits = 200;
        k    = BitsRead () - Bits;
        Bits = BitsRead ();
        fprintf ( fp5, "%4lu\t%5u bit\t%5.1f kbps\n", Frame, k, k * (44.1/1152) );
    }

    // used bits of the individual sections
    if ((DUMPSELECT & 64)  &&  fp6 != NULL) {
        fprintf ( fp6, "%4lu %4lu%5lu%5lu%6lu\n", Frame,
                  bitpostab[1] - bitpostab[0], bitpostab[2] - bitpostab[1],
                  bitpostab[3] - bitpostab[2], bitpostab[4] - bitpostab[3] );
    }

    // requantized subband samples
    if ((DUMPSELECT & 128)  &&  fp7 != NULL) {
        int  max = 0;

        fprintf ( fp7, "--- %4lu ---\n", Frame );
        for (k=0; k<36; k++) {
            for ( Band = 0; Band <= Max_Used_Band; Band++ )
                fprintf ( fp7, "%9.1f", Q[Band].L[k] * SCF[SCF_Index[k/12][Band].L] * Cc[Res[Band].L] );
            fprintf ( fp7, "\n");
        }
        fprintf ( fp7, "\n");
        for ( k=0; k<36; k++) {
            for ( Band = 0; Band <= Max_Used_Band; Band++ )
                fprintf ( fp7, "%9.1f", Q[Band].R[k] * SCF[SCF_Index[k/12][Band].R] * Cc[Res[Band].R] );
            fprintf ( fp7, "\n");
        }
        fprintf ( fp7, "\n\n");
    }

    Frame++;
    return;
}

#endif

/* end of dump.c */
