/*
 * Musepack audio compression
 * Copyright (C) 1999-2004 Buschmann/Klemm/Piecha/Wolf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mppdec.h"

static Huffman_t   Entropie_1    [ 3];
static Huffman_t   Entropie_2    [ 5];
static Huffman_t   Entropie_3    [ 7];
static Huffman_t   Entropie_4    [ 9];
static Huffman_t   Entropie_5    [15];
static Huffman_t   Entropie_6    [31];
static Huffman_t   Entropie_7    [63];
Huffman_t          SCFI_Bundle   [ 8];
Huffman_t          DSCF_Entropie [13];
static Huffman_t   Region_A      [16];
static Huffman_t   Region_B      [ 8];
static Huffman_t   Region_C      [ 4];

const Huffman_t*  Entropie      [18] = {
    NULL      , Entropie_1, Entropie_2, Entropie_3, Entropie_4, Entropie_5,
    Entropie_6, Entropie_7, NULL      , NULL      , NULL      , NULL      ,
    NULL      , NULL      , NULL      , NULL      , NULL      , NULL      ,
};

const Huffman_t*  Region        [32] = {
    Region_A, Region_A, Region_A, Region_A, Region_A, Region_A, Region_A, Region_A,
    Region_A, Region_A, Region_A, Region_B, Region_B, Region_B, Region_B, Region_B,
    Region_B, Region_B, Region_B, Region_B, Region_B, Region_B, Region_B, Region_C,
    Region_C, Region_C, Region_C, Region_C, Region_C, Region_C, Region_C, Region_C
};

static const HuffSrc_t   SCFI_Bundle_src [8] = {
    { 11, 6 }, { 7, 5 }, { 6, 5 }, { 1, 2 }, { 4, 5 }, { 0, 3 }, { 10, 6 }, { 1, 1 },
};

static const HuffSrc_t   Region_A_src [16] = {
    {   2, 3 }, {   1, 1 }, {   0,  2 }, {  15,  5 }, {   29,  6 }, {   13,  5 }, {   12,  5 }, {   57,  7 },
    { 113, 8 }, { 225, 9 }, { 449, 10 }, { 897, 11 }, { 1793, 12 }, { 3585, 13 }, { 7169, 14 }, { 7168, 14 },
};

static const HuffSrc_t   Region_B_src [ 8] = {
    { 1, 2 }, { 1, 1 }, { 1, 3 }, { 1, 4 }, { 1, 5 }, { 1, 6 }, { 1, 7 }, { 0, 7 },
};

static const HuffSrc_t   Region_C_src [ 4] = {
    { 1, 1 }, { 1, 2 }, { 1, 3 }, { 0, 3 },
};

static const HuffSrc_t   DSCF_Entropie_src [13] = {
    { 20, 6 }, { 11, 5 }, {  4, 4 }, { 24, 5 }, { 11, 4 }, {  4, 3 }, { 0, 2 },
    {  7, 3 }, {  3, 3 }, { 13, 4 }, { 10, 4 }, { 25, 5 }, { 21, 6 },
};

static const HuffSrc_t   Entropie_1_src [3] = {
    { 1, 2 }, { 1, 1 }, { 0, 2 },
};

static const HuffSrc_t   Entropie_2_src [5] = {
    { 4, 3 }, { 0, 2 }, { 3, 2 }, { 1, 2 }, { 5, 3 },
};

static const HuffSrc_t   Entropie_3_src [7] = {
    { 17, 5 }, { 5, 3 }, { 1, 2 }, { 3, 2 }, { 0, 2 }, { 9, 4 }, { 16, 5 },
};

static const HuffSrc_t   Entropie_4_src [9] = {
    { 5, 4 }, { 14, 4 }, { 3, 3 }, { 5, 3 }, { 0, 2 }, { 6, 3 }, { 4, 3 }, { 15, 4 }, { 4, 4 },
};

static const HuffSrc_t   Entropie_5_src [15] = {
    { 57, 6 }, { 23, 5 }, { 29, 5 }, {  3, 4 }, { 13, 4 }, { 15, 4 }, {  2, 3 }, { 4, 3 },
    {  3, 3 }, {  0, 3 }, { 12, 4 }, { 10, 4 }, {  2, 4 }, { 22, 5 }, { 56, 6 },
};

static const HuffSrc_t   Entropie_6_src [31] = {
    {  8, 7 }, { 88, 7 }, { 40, 6 }, {  5, 6 }, { 45, 6 }, { 56, 6 }, {  9, 5 }, { 23, 5 },
    { 24, 5 }, { 27, 5 }, { 29, 5 }, { 31, 5 }, {  3, 4 }, {  2, 4 }, {  7, 4 }, {  9, 4 },
    {  8, 4 }, {  5, 4 }, {  6, 4 }, {  0, 4 }, { 30, 5 }, { 26, 5 }, { 25, 5 }, { 21, 5 },
    {  3, 5 }, { 57, 6 }, { 41, 6 }, { 17, 6 }, { 16, 6 }, { 89, 7 }, {  9, 7 },
};

static const HuffSrc_t   Entropie_7_src [63] = {
    {  17, 8 }, { 151, 8 }, { 212, 8 }, {   9, 7 }, {  80, 7 }, {  10, 7 }, { 11, 7 }, { 63, 7 },
    {  89, 7 }, {  97, 7 }, { 107, 7 }, { 126, 7 }, {  18, 6 }, {  36, 6 }, { 38, 6 }, { 42, 6 },
    {  43, 6 }, {  45, 6 }, {  51, 6 }, {  50, 6 }, {  56, 6 }, {  57, 6 }, { 60, 6 }, { 61, 6 },
    {   6, 5 }, {   0, 5 }, {   8, 5 }, {   7, 5 }, {  14, 5 }, {  10, 5 }, { 17, 5 }, { 11, 5 },
    {  16, 5 }, {   5, 5 }, {  13, 5 }, {   4, 5 }, {  12, 5 }, {   1, 5 }, {  3, 5 }, { 62, 6 },
    {  59, 6 }, {  55, 6 }, {  54, 6 }, {  49, 6 }, {  52, 6 }, {  47, 6 }, { 46, 6 }, { 41, 6 },
    {  39, 6 }, {  30, 6 }, {  19, 6 }, { 117, 7 }, { 116, 7 }, {  96, 7 }, { 88, 7 }, { 74, 7 },
    {  62, 7 }, { 254, 8 }, {  81, 7 }, { 255, 8 }, { 213, 8 }, { 150, 8 }, { 16, 8 },
};


#define MAKE(d,s)    Make_HuffTable   ( (d), (s), sizeof(s)/sizeof(*(s)) )
#define SORT(x,o)    Resort_HuffTable ( (x), sizeof(x)/sizeof(*(x)), -(Int)(o) )
#define LOOKUP(x,q)  Make_LookupTable ( (q), sizeof(q), (x), sizeof(x)/sizeof(*(x)) )


static void
Init_Huffman_Encoder_SV4_6 ( void )
{
    MAKE ( SCFI_Bundle  , SCFI_Bundle_src   );  // SCFI-Bundle
    MAKE ( Region_A     , Region_A_src      );  // Region A (Subbands  0...10)
    MAKE ( Region_B     , Region_B_src      );  // Region B (Subbands 11...22)
    MAKE ( Region_C     , Region_C_src      );  // Region C (Subbands 23...31)
    MAKE ( DSCF_Entropie, DSCF_Entropie_src );  // DSCF
    MAKE ( Entropie_1   , Entropie_1_src    );  // first Quantizer
    MAKE ( Entropie_2   , Entropie_2_src    );  // second Quantizer
    MAKE ( Entropie_3   , Entropie_3_src    );  // third Quantizer
    MAKE ( Entropie_4   , Entropie_4_src    );  // fourth Quantizer
    MAKE ( Entropie_5   , Entropie_5_src    );  // fifth Quantizer
    MAKE ( Entropie_6   , Entropie_6_src    );  // sixth Quantizer
    MAKE ( Entropie_7   , Entropie_7_src    );  // seventh Quantizer
}


void
Init_Huffman_Decoder_SV4_6 ( void )
{
    Init_Huffman_Encoder_SV4_6 ();

    SORT ( Entropie_1   , Dc[1] );
    SORT ( Entropie_2   , Dc[2] );
    SORT ( Entropie_3   , Dc[3] );
    SORT ( Entropie_4   , Dc[4] );
    SORT ( Entropie_5   , Dc[5] );
    SORT ( Entropie_6   , Dc[6] );
    SORT ( Entropie_7   , Dc[7] );
    SORT ( SCFI_Bundle  ,    0  );
    SORT ( DSCF_Entropie,    6  );
    SORT ( Region_A     ,    0  );
    SORT ( Region_B     ,    0  );
    SORT ( Region_C     ,    0  );
}

/* end of huffsv46.c */
