        BITS 32

        SECTION .text
;
; void __analyze_stereo ( const stereo* p, size_t len, korr_t* result );
;
; esp+12        result
; esp+ 8        len
; esp+ 4        p
; esp+ 0        return address
;
        GLOBAL  __analyze_stereo:function
__analyze_stereo
        mov     eax,  [esp+12]
        mov     ecx,  [esp+ 8]
        mov     edx,  [esp+ 4]
        add     dword [eax+0],ecx
        adc     dword [eax+4],byte 0
        fldz
        fldz
        fldz
        fldz
        fldz                            ; Sxy Sy Sy  Sx Sx
lbl:
        fild    word [edx+0]            ; x   Sxy Sy Sy  Sx Sx
        fld     st0                     ; x   x   Sxy Sy Sy  Sx Sx
        fmul    st0,st0                 ; x  x   Sxy Sy Sy  Sx Sx
        faddp   st5,st0                 ; x   Sxy Sy Sy  Sx Sx
        fadd    st5,st0
        fild    word [edx+2]            ; y   x   Sxy Sy Sy  Sx Sx
        fadd    st4,st0
        add     edx,byte 4
        fmul    st1,st0                 ; y   xy  Sxy Sy Sy  Sx Sx
        fmul    st0,st0                 ; y  xy  Sxy Sy Sy  Sx Sx
        faddp   st3,st0                 ; xy  Sxy Sy Sy  Sx Sx
        faddp   st1,st0                 ; Sxy Sy Sy  Sx Sx
        dec     ecx
        jnz     lbl

        fld     tword [eax+56]
        faddp   st1,st0
        fstp    tword [eax+56]          ; xy
        fld     tword [eax+44]
        faddp   st1,st0
        fstp    tword [eax+44]          ; y
        fld     tword [eax+32]
        faddp   st1,st0
        fstp    tword [eax+32]          ; y
        fld     tword [eax+20]
        faddp   st1,st0
        fstp    tword [eax+20]          ; x
        fld     tword [eax+ 8]
        faddp   st1,st0
        fstp    tword [eax+ 8]          ; x
        ret
;

;
; void __analyze_mono ( const mono* p, size_t len, korr_t* result );
;
; esp+12        result
; esp+ 8        len
; esp+ 4        p
; esp+ 0        return address
;
        GLOBAL  __analyze_mono:function
__analyze_mono
        mov     eax,  [esp+12]
        mov     ecx,  [esp+ 8]
        mov     edx,  [esp+ 4]
        add     dword [eax+0],ecx
        adc     dword [eax+4],byte 0
        fldz
        fldz                            ; Sx Sx
lbl2:
        fild    word [edx+0]            ; x   Sx Sx
        add     edx,byte 2
        fadd    st2,st0                 ; x   Sx Sx
        fmul    st0,st0                 ; x  Sx Sx
        faddp   st1,st0                 ; Sx Sx
        dec     ecx
        jnz     lbl2

        fld     tword [eax+56]
        fadd    st0,st1
        fstp    tword [eax+56]          ; xy
        fld     tword [eax+44]
        fadd    st0,st1
        fstp    tword [eax+44]          ; y
        fld     tword [eax+32]
        fadd    st0,st2
        fstp    tword [eax+32]          ; y
        fld     tword [eax+20]
        faddp   st1,st0
        fstp    tword [eax+20]          ; x
        fld     tword [eax+ 8]
        faddp   st1,st0
        fstp    tword [eax+ 8]          ; x
        ret
;
