#define FILE_IO 0
#include "mppdec.h"

Bool_t            output_endianess   = LITTLE;

#define SAMP    44100
#define DUR     4

/********************************************************************/

typedef void (*fn_t) ( float* );

static void
sin1 ( float* A )
{
    int  i;

    for ( i = 0; i < SAMP*DUR; i++ ) {
        *A++ = sin (i * (2 * M_PI * 1000 / SAMP) );
    }
}

static void
sin5 ( float* A )
{
    int  i;

    for ( i = 0; i < SAMP*DUR; i++ )
        *A++ = sin (i * (2 * M_PI * 5000 / SAMP) );
}

static void
sinfou ( float* A )
{
    int  i;

    for ( i = 0; i < SAMP*DUR; i++ )
        *A++ = sin (i * (2 * M_PI * 1000 / SAMP) ) / 1
             + sin (i * (2 * M_PI * 3000 / SAMP) ) / 3
             + sin (i * (2 * M_PI * 5000 / SAMP) ) / 5
             + sin (i * (2 * M_PI * 7000 / SAMP) ) / 7
             + sin (i * (2 * M_PI * 9000 / SAMP) ) / 9
             + sin (i * (2 * M_PI *11000 / SAMP) ) /11
             + sin (i * (2 * M_PI *13000 / SAMP) ) /13
             + sin (i * (2 * M_PI *15000 / SAMP) ) /15;
}

static void
noise1 ( float* A )
{
    int  i;

    for ( i = 0; i < SAMP*DUR; i++ )
        *A++ = rand() * (2./RAND_MAX) - 1.;
}

static void
noise2 ( float* A )
{
    long  last;
    long  curr = RAND_MAX / 2;
    int   i;

    for ( i = 0; i < SAMP*DUR; i++ ) {
        last = curr;
        curr = rand ();
        *A++ = (last - curr) * (1./RAND_MAX);
    }
}

static void
noise3 ( float* A )
{
    double  last = 0.;
    double  curr;
    int     i;

    for ( i = 0; i < SAMP*DUR; i++ ) {
        curr = rand() * (2./RAND_MAX) - 1.;
        *A++ = last = 0.9 * last + 0.1 * curr;
    }
}

/********************************************************************/

static void
writeFile ( const char* cmd, const float* A, const float* B )
{
    static short   Data [SAMP*DUR] [2];
    int            i;
    double         max = 0.;
    FILE_T         fp;

    for ( i = 0; i < SAMP*DUR; i++ )
        if ( fabs ( A[i] * B[i] ) > max )
             max = fabs ( A[i] * B[i] );

    for ( i = 0; i < SAMP*DUR; i++ )
        Data [i][0] = Data [i][1] = (short) floor ( A[i] * B[i] / max * 24576 + 0.5 );

    stderr_printf ( "%s\n", cmd );
    fp = POPEN_WRITE_BINARY_OPEN ( cmd );
    Write_WAVE_Header ( fp, 44100., 16, 2, 10*44100 );
    WRITE ( fp, Data, sizeof(Data) );
    PCLOSE ( fp );
}

/*********************************************************************/

static void
env ( float* A, double expo, double mult, int ie )
{
    static double  x [SAMP*DUR];
    int            i;
    int            j;
    int            k;
    double         tmp;
    double         max = 0.;

    for ( i = 0; i < SAMP*DUR; i++ )
        x [i] = pow (i+0.5, expo) * pow ( mult, i );

    for ( i = 0; i < SAMP*DUR; i++ )
        if ( x[i] > max )
             max = x[i];

    for ( i = 0; i < SAMP*DUR; i++ )
        x [i] /= max;

    for ( j = 0; j < ie; j++ ) {
        tmp = x[j];
        for ( k = 1; j+k*ie < SAMP*DUR  &&  x[j+k*ie] > 1.e-20; k++ )
            tmp += x[j + k*ie];
        A[j] = tmp;
    }

    for ( j = ie; j < SAMP*DUR; j++ ) {
        A[j] = A[j-ie];
    }
}

static float   A [6] [SAMP*DUR];


void
Writefiles ( const float* B, const char* base )
{
    char  cmd [128];
    int   j;

    for ( j = 0; j < 6; j++ ) {
        sprintf ( cmd, "mppenc - %s_%c.mpc -xtreme", base, 'a'+j );
        writeFile ( cmd, A[j], B );
    }
}


/*********************************************************************/
int
main ( void )
{
    static fn_t    F [6] = { sin1, sin5, sinfou, noise1, noise2, noise3 };
    static float   B [SAMP*DUR];
    int            i;
    int            p;
    int            s;
    int            d;
    char           name [32];

    stderr_printf ("Calculating noises...\n");
    for ( i = 0; i < sizeof(F)/sizeof(*F); i++ ) {
        stderr_printf ("[%u] ", i);
        F [i] (&(A[i][0]));
    }

    stderr_printf ("\nCalculating envelopes...\n");
    for ( i = 0; i < SAMP*DUR; i++ ) {
         B[i] = 1.;
    }
    Writefiles ( B, "const" );

    for ( p = 2; p >= 0; p-- )                  // rise
        for ( s = 3; s < 14; s++ )              // duration
            for ( d = 25; d <= 400; d *= 2 ) {  // Pulse sequence
                env ( B, p, 1. - pow (0.5,s), d*SAMP/1000 );
                sprintf ( name, "%04u_%03u_%1u", 1<<s, d, p );
                stderr_printf ("\n\n*** %s ***\n", name );
                Writefiles ( B, name );
            }

    return 0;
}
