#include "mppenc.h"

#define QUANT   256

/* V A R I A B L E S */
float  __SCF    [128 + 6];   // tabulated scalefactors
float  __invSCF [128 + 6];   // inverted scalefactors


// Quantization-coefficients: step/65536 bzw. (2*D[Res]+1)/65536
static const float  __A [1 + 18] = {
    0.0000762939453125f,
    0.0000000000000000f, 0.0000457763671875f, 0.0000762939453125f, 0.0001068115234375f,
    0.0001373291015625f, 0.0002288818359375f, 0.0004730224609375f, 0.0009613037109375f,
    0.0019378662109375f, 0.0038909912109375f, 0.0077972412109375f, 0.0156097412109375f,
    0.0312347412109375f, 0.0624847412109375f, 0.1249847412109375f, 0.2499847412109375f,
    0.4999847412109375f
};


// Requantization-coefficients: 65536/step bzw. 1/A[Res]
static const float  __C [1 + 18] = {
    13107.200000000001f,
    65535.000000000000f, 21845.333333333332f, 13107.200000000001f, 9362.285714285713f,
     7281.777777777777f,  4369.066666666666f,  2114.064516129032f, 1040.253968253968f,
      516.031496062992f,   257.003921568627f,   128.250489236790f,   64.062561094819f,
       32.015632633121f,    16.003907203907f,     8.000976681723f,    4.000244155527f,
        2.000061037018f,     1.000015259022f
};


// Requantization-Offset: 2*D+1 = steps of quantizer
static const int  __D [1 + 18] = {
    2,
    0,     1,     2,     3,     4,     7,    15,    31,    63,
  127,   255,   511,  1023,  2047,  4095,  8191, 16383, 32767
};

#define A   (__A + 1)
#define C   (__C + 1)
#define D   (__D + 1)

// generation of scalefactors and their inverses
void
Init_Skalenfaktoren ( void )
{
    int  n;

    for ( n = -6; n < 128; n++ ) {
        SCF[n]    = (float) ( pow(10.,-0.1*(n-1)/1.26) );
        invSCF[n] = (float) ( pow(10., 0.1*(n-1)/1.26) );
    }
}


static float  NoiseInjectionCompensation1D [18] = {
    1.f,
    0.884621,
    0.935711,
    0.970829,
    0.987941,
    0.994315,
    0.997826,
    0.999744,
    1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f
} ;

static float  NoiseInjectionCompensation2D [18] [QUANT] = {
#if 0
    { 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000,  },
    { 1.000000, 0.759249, 0.811836, 0.887331, 0.928149, 0.979971, 1.007421, 0.991449, 0.973947, 0.947925, 0.936421, 0.916337, 0.906686, 0.897296, 0.884270, 0.875419, 0.876278, 0.868250, 0.865214, 0.861756, 0.857050, 0.854532, 0.853627, 0.851695, 0.852243, 0.849346, 0.851076, 0.850652, 0.853719, 0.853392, 0.855967, 0.855529, 0.866884, 0.868897, 0.872451, 0.874693, 0.876086, 0.878925, 0.881002, 0.883748, 0.896915, 0.902294, 0.904282, 0.908025, 0.909089, 0.911731, 0.914048, 0.916787, 0.931141, 0.933261, 0.936990, 0.938510, 0.941108, 0.944846, 0.945569, 0.945446, 0.960741, 0.961310, 0.961236, 0.963485, 0.965850, 0.968487, 0.967972, 0.970880, 0.982873, 0.984252, 0.986016, 0.987185, 0.990836, 0.990069, 0.991684, 0.995063, 1.005844, 1.007861, 1.008456, 1.009472, 1.007765, 1.015780, 1.013161, 1.014316, 1.025401, 1.030166, 1.026138, 1.035660, 1.038433, 1.036167, 1.044260, 1.039487, 1.053740, 1.056427, 1.059859, 1.058788, 1.057076, 1.064166, 1.068220, 1.074360, 1.073819, 1.070236, 1.052957, 1.073170, 1.078512, 1.088742, 1.087788, 1.083055, 1.089437, 1.080983, 1.078256, 1.080718, 1.075766, 1.080217, 1.074016, 1.068206, 1.070925, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545, 1.074545,  },
    { 0.734415, 0.857080, 0.896985, 0.910291, 0.919858, 0.932150, 0.900508, 0.884923, 0.888104, 0.897810, 0.904629, 0.932746, 0.941313, 0.950723, 0.939135, 0.940385, 0.932144, 0.929118, 0.929208, 0.923236, 0.920199, 0.919320, 0.918495, 0.915762, 0.919277, 0.918830, 0.919762, 0.920036, 0.921206, 0.923291, 0.926169, 0.927089, 0.935140, 0.937440, 0.939327, 0.940953, 0.943766, 0.945858, 0.948038, 0.950245, 0.956156, 0.958724, 0.960530, 0.962402, 0.963945, 0.966367, 0.967490, 0.968064, 0.973955, 0.975495, 0.976424, 0.977624, 0.978177, 0.979428, 0.980549, 0.981283, 0.984267, 0.985143, 0.984633, 0.985154, 0.985831, 0.986632, 0.987966, 0.987271, 0.989323, 0.990228, 0.989934, 0.990184, 0.992097, 0.991417, 0.992013, 0.990068, 0.993321, 0.991961, 0.991686, 0.995233, 0.993092, 0.993147, 0.992993, 0.994349, 0.991502, 0.994954, 0.992521, 0.993046, 0.992133, 0.991579, 0.991394, 0.995659, 0.992520, 0.991381, 0.993217, 0.994709, 0.998368, 0.995523, 1.003331, 0.998391, 1.002294, 1.003448, 1.006459, 1.003872, 1.003000, 1.005899, 1.008900, 1.014621, 1.012585, 1.008313, 1.012377, 1.017555, 1.014297, 1.018404, 1.018644, 1.009129, 1.023010, 1.018520, 1.015460, 1.031318, 1.039789, 1.024658, 1.014159, 1.017848, 1.028665, 1.024441, 1.019322, 1.007162, 1.007162, 1.021388, 1.020239, 1.021447, 1.007240, 1.011620, 1.021348, 1.021348, 1.021348, 1.021348, 1.021348, 1.021348, 1.021494, 1.021494, 1.015500, 1.001597, 0.993681, 0.993681, 0.993008, 0.993008, 0.993008, 0.993008, 0.993008, 0.993008, 0.993008, 0.993008, 0.993008, 0.993008, 0.993008, 0.993008, 0.993008, 0.993008, 0.993008, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075, 0.986075,  },
    { 0.777484, 0.849836, 0.881361, 0.906465, 0.865617, 0.848642, 0.858126, 0.889807, 0.906461, 0.928171, 0.938043, 0.949200, 0.962016, 0.969692, 0.961996, 0.966335, 0.963620, 0.961296, 0.958598, 0.962175, 0.962153, 0.961676, 0.958766, 0.960732, 0.959639, 0.961035, 0.960171, 0.960211, 0.960824, 0.961096, 0.961811, 0.962648, 0.963659, 0.964758, 0.965506, 0.966180, 0.967860, 0.969656, 0.970947, 0.971804, 0.975079, 0.976889, 0.978841, 0.979762, 0.981165, 0.981223, 0.982393, 0.983519, 0.985742, 0.986475, 0.986982, 0.987372, 0.988212, 0.989504, 0.989625, 0.989468, 0.991613, 0.993127, 0.991807, 0.993039, 0.992993, 0.993200, 0.994565, 0.994514, 0.994432, 0.996018, 0.995668, 0.996518, 0.996332, 0.996290, 0.996889, 0.995703, 0.996524, 0.995743, 0.999119, 0.998416, 0.999294, 0.998272, 0.999494, 1.000412, 0.998035, 0.996419, 0.998664, 0.998506, 0.997501, 1.001344, 0.999698, 0.994570, 0.995807, 0.993660, 0.998871, 0.996257, 0.997309, 0.995666, 0.990570, 0.995626, 0.999845, 0.998833, 0.997052, 0.996709, 0.999286, 1.002197, 1.002416, 1.000137, 1.003978, 1.004382, 1.009287, 1.008551, 1.013763, 1.008605, 1.004756, 1.012969, 1.010815, 1.010876, 1.015383, 1.017933, 1.019132, 1.021530, 1.013514, 1.024877, 1.015756, 1.013125, 1.015566, 1.021405, 1.013578, 1.014014, 1.018532, 1.018532, 1.020123, 1.027448, 1.027448, 1.027448, 1.027448, 1.027448, 1.027448, 1.019614, 1.019614, 1.019614, 1.019614, 1.019614, 1.019614, 1.021124, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.023807, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142, 1.017142,  },
    { 0.768899, 0.859566, 0.868660, 0.852532, 0.872490, 0.892725, 0.881562, 0.866837, 0.925723, 0.945194, 0.959959, 0.971813, 0.968389, 0.967759, 0.981668, 0.978640, 0.982425, 0.982213, 0.976421, 0.977012, 0.982413, 0.977864, 0.976401, 0.976838, 0.977443, 0.976589, 0.977748, 0.976002, 0.976800, 0.975999, 0.977034, 0.975927, 0.977154, 0.977273, 0.978960, 0.980006, 0.979935, 0.979307, 0.980530, 0.982598, 0.983128, 0.984904, 0.985876, 0.987222, 0.987732, 0.988199, 0.989208, 0.989228, 0.991007, 0.991598, 0.992215, 0.993467, 0.993710, 0.994069, 0.993981, 0.994361, 0.995747, 0.996312, 0.995699, 0.995950, 0.996376, 0.996878, 0.997838, 0.996955, 0.998374, 0.998594, 0.999679, 0.998351, 0.999414, 0.999537, 0.998618, 0.999754, 1.000731, 0.998966, 1.002234, 1.001931, 0.999167, 1.001205, 1.002779, 1.002699, 1.000894, 1.000027, 1.001136, 0.998800, 0.999445, 1.003775, 1.001074, 1.002857, 1.002555, 0.998466, 0.999644, 0.997879, 1.002654, 1.003206, 0.998430, 1.000023, 1.001060, 1.001502, 0.996861, 1.000298, 1.001281, 0.997420, 1.001959, 0.999228, 1.000719, 1.001420, 0.997701, 0.998687, 1.002896, 1.002422, 1.001887, 1.011236, 1.012831, 1.006676, 1.009851, 1.010054, 1.010092, 1.011967, 1.007694, 1.011416, 1.015280, 1.019717, 1.021681, 1.024486, 1.022072, 1.013151, 1.013151, 1.013151, 1.013151, 1.013151, 1.015019, 1.015019, 1.015019, 1.015019, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.015317, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125, 1.017125,  },
    { 0.839956, 0.865961, 0.912298, 0.937921, 0.968516, 0.968353, 0.962645, 0.963233, 0.979847, 0.984981, 0.988644, 0.990501, 0.987910, 0.989468, 0.988971, 0.988646, 0.988633, 0.987577, 0.988624, 0.988283, 0.988830, 0.989202, 0.990099, 0.989453, 0.990223, 0.990880, 0.991825, 0.992900, 0.992541, 0.993117, 0.993645, 0.993637, 0.994247, 0.994249, 0.995051, 0.994991, 0.995080, 0.995882, 0.995747, 0.996192, 0.996023, 0.996544, 0.996112, 0.997431, 0.996826, 0.996992, 0.998046, 0.997116, 0.997843, 0.997358, 0.997824, 0.998115, 0.998831, 0.998957, 0.997734, 0.998225, 0.998536, 0.998704, 0.998530, 0.999574, 0.998465, 0.998008, 0.999279, 0.999366, 0.999454, 0.999361, 0.999275, 0.998270, 0.998416, 0.999956, 1.000144, 1.002339, 1.002544, 1.000509, 1.001264, 1.000063, 0.999302, 0.996942, 1.000912, 1.000050, 1.000915, 0.999449, 0.997133, 1.000205, 1.000240, 0.999976, 1.000236, 1.003088, 1.000793, 1.001628, 1.003462, 1.001988, 1.000440, 0.998254, 1.003483, 1.001957, 0.997312, 0.998684, 0.999162, 1.002331, 1.004931, 0.996815, 0.997753, 0.997029, 0.997681, 0.995262, 0.995683, 0.995347, 0.995537, 0.995855, 0.992675, 0.992999, 0.999251, 0.994313, 0.997785, 1.000656, 1.003728, 1.004030, 1.005151, 1.006796, 1.008584, 1.008584, 1.008584, 1.008584, 1.008584, 1.005319, 1.005319, 1.005319, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048, 1.004048,  },
    { 0.861658, 0.925399, 0.971516, 0.982990, 0.992434, 0.991670, 0.999973, 1.000043, 0.993083, 0.995639, 0.995057, 0.994765, 0.995116, 0.995923, 0.996336, 0.996430, 0.995870, 0.996637, 0.996606, 0.997476, 0.997240, 0.998162, 0.998235, 0.998083, 0.997596, 0.998039, 0.998771, 0.998811, 0.998454, 0.998627, 0.998150, 0.998736, 0.998806, 0.998505, 0.998143, 0.998593, 0.998706, 0.998098, 0.998872, 0.998888, 0.998844, 0.998687, 0.999085, 0.998703, 0.999004, 0.999388, 0.999620, 0.999266, 0.998804, 0.998950, 0.999404, 0.999814, 0.999143, 1.000488, 0.998742, 0.999974, 1.000739, 0.999638, 0.999379, 0.998059, 0.998744, 0.998998, 0.999441, 1.000469, 1.000281, 0.999614, 0.998420, 0.999277, 0.998442, 1.000233, 0.999099, 0.999995, 1.000365, 1.000578, 1.000795, 0.997980, 0.999078, 0.998692, 1.000042, 1.001127, 0.999597, 1.000944, 0.998729, 1.000249, 1.002022, 1.001158, 1.001404, 0.999505, 0.999044, 1.000293, 1.001153, 0.998334, 1.001352, 1.003395, 1.001892, 1.001279, 0.999643, 0.999199, 0.999447, 0.997067, 0.997998, 1.000928, 1.000157, 1.000559, 1.000173, 0.999746, 0.999867, 1.000447, 1.001589, 1.001497, 1.002821, 1.001103, 1.001643, 1.000214, 1.000987, 1.000282, 1.002714, 1.003704, 1.003704, 1.004103, 1.004103, 1.004103, 1.003721, 1.001320, 1.001320, 1.000950, 1.000627, 0.999960, 0.997901, 0.997901, 0.997901, 0.997901, 0.997901, 0.997901, 0.997901, 0.997901, 0.997901, 0.997901, 0.997901, 0.997901, 0.997901, 0.997901, 0.997901, 0.997901, 0.997901, 0.999925, 0.999925, 0.999925, 1.000831, 1.000831, 1.000831, 1.000831, 1.000831, 1.000831, 1.000831, 1.000831, 1.000831, 1.000831, 1.000831, 1.000831, 1.000831, 1.000831, 1.000831, 1.000831, 1.000831, 1.000831, 1.002081, 1.002081, 1.002081, 1.002081, 1.002081, 1.002081, 1.002081, 1.002081, 1.002081, 1.002081, 1.002081, 1.002081, 1.002081, 1.002081, 1.002081, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370, 1.001370,  },
    { 0.888012, 0.888012, 0.976153, 0.992298, 0.998194, 1.000647, 0.999943, 1.001850, 1.000058, 1.001049, 1.000415, 1.000445, 0.999754, 0.999602, 0.999038, 0.999360, 0.999352, 0.999436, 0.999568, 0.999189, 0.999526, 0.999854, 0.999661, 0.999592, 0.999705, 0.999757, 0.999562, 0.999328, 0.999065, 0.999693, 0.999667, 0.999524, 0.999433, 0.999448, 0.999285, 0.999274, 0.999776, 0.999271, 1.000119, 0.999198, 0.999772, 1.000295, 0.999845, 0.999724, 0.999606, 0.999950, 0.999794, 0.999597, 0.999305, 0.999749, 0.999644, 0.999705, 0.999882, 0.999665, 0.999794, 1.000224, 0.999795, 0.999888, 0.999818, 0.999782, 1.000380, 0.999894, 1.000021, 1.000553, 1.000501, 1.000478, 0.999858, 1.000275, 1.000135, 1.000516, 1.000148, 0.999943, 1.000052, 0.999137, 1.000090, 1.000529, 0.999132, 0.998689, 1.000216, 1.000217, 1.000034, 1.000121, 1.000197, 0.998887, 1.000615, 0.999998, 0.999232, 0.998459, 1.000808, 0.999540, 0.999216, 0.998480, 0.999391, 1.001703, 0.999803, 0.999429, 1.001745, 0.999870, 1.000718, 1.000747, 0.996927, 1.000126, 0.999562, 0.997671, 0.997870, 1.001165, 1.001102, 1.000046, 1.000708, 1.001004, 1.000856, 1.000705, 1.000177, 1.001061, 0.999174, 0.999368, 0.999040, 0.999040, 1.000290, 0.999860, 0.998796, 0.998993, 0.998926, 0.997532, 0.997532, 0.997532, 0.997532, 0.997532, 0.997532, 0.997083, 0.997083, 0.997083, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414, 0.997414,  },
    { 0.958439, 0.980896, 0.986292, 0.995460, 0.998478, 0.998143, 0.998741, 1.000420, 1.000390, 1.000282, 1.000941, 0.999899, 0.999658, 0.999880, 1.001323, 1.000942, 1.000966, 1.000292, 0.999813, 1.000177, 0.999448, 1.000041, 1.000118, 0.999570, 1.000439, 0.999770, 0.999341, 0.999963, 0.999964, 0.999458, 1.000023, 1.000060, 1.000155, 0.999964, 1.000191, 0.999619, 1.000167, 1.000044, 0.999825, 0.999902, 0.999925, 1.000143, 1.000025, 0.999873, 0.999936, 1.000027, 0.999925, 1.000038, 0.999952, 0.999899, 0.999997, 0.999940, 0.999993, 1.000095, 0.999888, 1.000105, 0.999878, 0.999830, 0.999957, 1.000073, 1.000024, 1.000097, 0.999882, 1.000041, 1.000012, 0.999845, 1.000008, 0.999899, 1.000071, 0.999875, 0.999937, 0.999826, 1.000039, 0.999879, 0.999985, 1.000118, 0.999893, 0.999673, 1.000376, 1.000346, 1.000074, 1.000109, 1.000228, 0.999908, 0.999992, 1.000085, 1.000146, 0.999856, 0.999994, 1.000121, 0.999061, 1.000332, 1.000196, 0.999850, 0.999403, 0.999475, 0.998438, 0.999499, 0.999726, 0.999579, 0.999913, 0.999626, 0.999549, 0.999581, 1.000025, 1.000519, 1.000716, 0.999857, 1.000405, 1.000931, 1.000229, 0.999823, 0.999984, 1.000652, 1.000086, 0.999971, 0.999104, 0.999585, 1.000595, 0.999333, 0.999842, 0.999031, 0.999704, 0.999704, 0.999301, 0.999830, 0.999695, 0.999542, 1.000159, 1.000417, 1.000110, 1.000110, 1.000017, 1.000017, 1.000017, 1.000637, 1.000637, 1.000153, 1.000153, 1.000153, 1.000153, 1.000404, 1.000404, 1.000404, 1.000404, 1.000404, 1.000404, 1.000404, 1.000780, 1.000780, 1.000780, 1.000780, 1.000780, 1.000780, 1.000780, 1.000780, 1.000780, 1.000780, 1.000780, 1.000780, 1.000780, 1.000780, 1.000780, 1.000780, 1.000780, 1.000220, 1.000220, 1.000220, 1.000220, 1.000326, 1.000326, 1.000326, 1.000326, 1.000066, 1.000066, 1.000078, 1.000091, 1.000091, 1.000091, 1.000091, 0.999682, 0.999682, 0.999682, 0.999682, 1.000359, 1.000576, 1.000576, 1.000576, 1.000576, 1.000576, 1.000576, 1.000576, 1.000576, 1.000576, 1.001357, 1.001357, 1.001357, 1.001357, 1.001357, 1.001357, 1.001357, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000684, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394, 1.000394,  },
    { 0.944965, 0.944965, 0.944965, 0.944965, 0.944965, 0.944965, 0.966881, 0.986033, 0.991892, 0.996405, 0.998322, 1.000154, 0.999697, 1.000262, 1.000323, 0.999933, 0.999551, 0.999867, 0.999910, 1.000066, 1.000620, 1.000105, 1.000308, 0.999734, 1.000108, 0.999844, 0.999806, 0.999652, 0.999982, 0.999906, 1.000015, 0.999880, 0.999729, 0.999963, 0.999786, 0.999917, 0.999756, 1.000028, 0.999854, 1.000070, 0.999969, 1.000092, 0.999666, 0.999958, 1.000054, 0.999872, 0.999901, 1.000070, 0.999904, 0.999958, 0.999941, 1.000017, 0.999970, 0.999901, 1.000156, 0.999956, 0.999996, 0.999868, 0.999849, 1.000034, 0.999826, 0.999900, 1.000018, 1.000045, 0.999931, 1.000022, 1.000078, 1.000018, 1.000118, 1.000235, 0.999987, 0.999758, 0.999765, 1.000121, 0.999940, 0.999707, 0.999862, 0.999903, 1.000216, 1.000211, 1.000152, 1.000181, 0.999979, 0.999721, 0.999863, 0.999737, 1.000034, 0.999674, 1.000281, 1.000399, 1.000296, 1.000299, 1.000124, 1.000082, 1.000306, 1.000057, 0.999740, 0.999842, 0.999829, 0.999918, 1.000016, 0.999204, 0.999476, 0.999756, 1.000143, 1.000383, 0.999942, 1.000134, 1.000132, 1.000204, 0.999867, 1.000072, 1.000066, 1.000167, 0.999971, 0.999706, 0.999531, 0.999722, 1.000031, 1.000123, 1.000701, 1.000530, 1.000339, 1.000240, 0.999823, 1.000075, 1.000122, 1.000202, 1.000020, 0.999771, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 0.999538, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048,  },
    { 0.959841, 0.959841, 0.959841, 0.959841, 0.959841, 0.971405, 0.991069, 0.996331, 0.997500, 0.999523, 0.999033, 1.000030, 0.999960, 0.999803, 0.999719, 0.999968, 1.000139, 1.000104, 1.000096, 1.000045, 1.000033, 1.000075, 0.999997, 0.999958, 0.999890, 1.000051, 1.000052, 0.999951, 1.000100, 1.000154, 0.999983, 1.000075, 1.000198, 1.000173, 0.999903, 0.999898, 0.999951, 0.999970, 1.000196, 1.000154, 0.999989, 0.999829, 1.000132, 1.000080, 1.000026, 0.999949, 0.999788, 1.000058, 1.000135, 1.000127, 0.999912, 0.999970, 1.000062, 1.000131, 0.999988, 0.999950, 1.000113, 1.000016, 1.000027, 1.000001, 1.000113, 0.999860, 1.000142, 1.000008, 0.999977, 1.000269, 1.000245, 0.999972, 1.000018, 0.999952, 0.999987, 0.999940, 1.000007, 1.000001, 1.000090, 1.000006, 1.000017, 0.999902, 1.000133, 1.000035, 0.999949, 0.999737, 0.999803, 0.999850, 1.000085, 1.000198, 1.000111, 1.000228, 0.999878, 0.999962, 0.999991, 1.000120, 0.999840, 1.000209, 1.000227, 0.999937, 0.999899, 0.999865, 1.000047, 1.000078, 0.999774, 1.000111, 0.999939, 0.999761, 0.999814, 1.000362, 1.000362, 1.000206, 1.000215, 1.000465, 1.000288, 1.000104, 1.000206, 1.000154, 1.000154, 1.000154, 1.000154, 1.000058, 1.000058, 0.999760, 0.999638, 0.999638, 0.999638, 0.999638, 0.999498, 0.999498, 0.999828, 1.000688, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768, 0.999768,  },
    { 0.977692, 0.977692, 0.977692, 0.977692, 0.977692, 0.977692, 0.992476, 0.996357, 0.998241, 0.999482, 0.999859, 1.000138, 1.000226, 1.000218, 1.000160, 1.000172, 1.000060, 0.999980, 0.999946, 0.999932, 0.999926, 0.999999, 1.000090, 1.000081, 1.000105, 1.000194, 1.000172, 1.000139, 1.000181, 1.000103, 1.000137, 1.000114, 0.999955, 0.999993, 0.999908, 0.999965, 1.000107, 1.000065, 0.999976, 1.000006, 0.999907, 1.000030, 0.999984, 1.000043, 1.000072, 1.000039, 0.999933, 1.000049, 1.000029, 1.000097, 1.000074, 1.000127, 1.000054, 0.999979, 0.999896, 0.999792, 0.999908, 0.999799, 0.999940, 0.999930, 0.999971, 1.000126, 0.999884, 0.999817, 0.999802, 1.000000, 0.999999, 0.999916, 0.999937, 0.999856, 0.999865, 0.999974, 0.999856, 0.999901, 0.999796, 0.999769, 0.999882, 0.999759, 0.999964, 0.999877, 0.999942, 0.999844, 0.999942, 0.999757, 0.999862, 0.999852, 0.999795, 1.000173, 0.999926, 0.999926, 0.999895, 0.999852, 0.999933, 0.999928, 0.999783, 0.999745, 0.999664, 0.999785, 0.999941, 0.999882, 1.000006, 0.999662, 0.999713, 0.999866, 0.999961, 0.999754, 0.999928, 0.999938, 1.000214, 0.999984, 1.000157, 1.000079, 1.000119, 1.000119, 0.999842, 1.000085, 0.999930, 1.000032, 0.999928, 0.999928, 0.999928, 1.000185, 1.000185, 0.999894, 0.999918, 0.999918, 0.999918, 0.999918, 1.000264, 1.000264, 1.000264, 1.000264, 1.000264, 1.000264, 1.000264, 1.000264, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375, 1.000375,  },
    { 0.995891, 0.995891, 0.995891, 0.995891, 0.995891, 0.997098, 0.998660, 0.999597, 0.999820, 0.999820, 0.999904, 0.999960, 1.000008, 1.000012, 1.000043, 1.000136, 1.000030, 0.999990, 0.999912, 0.999912, 1.000009, 1.000000, 1.000030, 1.000069, 1.000035, 1.000062, 1.000029, 0.999970, 0.999942, 0.999957, 0.999964, 1.000010, 0.999967, 1.000050, 1.000013, 0.999899, 0.999934, 0.999995, 0.999999, 1.000017, 1.000008, 0.999999, 1.000051, 1.000036, 1.000045, 1.000012, 1.000023, 1.000006, 1.000031, 0.999981, 0.999915, 0.999953, 1.000002, 1.000029, 1.000043, 1.000002, 1.000001, 1.000009, 1.000025, 1.000025, 1.000025, 1.000021, 1.000003, 1.000003, 1.000018, 1.000018, 0.999998, 0.999998, 0.999998, 0.999998, 0.999994, 0.999994, 1.000055, 1.000055, 1.000055, 1.000055, 1.000036, 1.000036, 1.000036, 1.000036, 1.000036, 1.000036, 1.000036, 1.000036, 1.000036, 1.000036, 1.000036, 1.000036, 1.000036, 1.000061, 0.999877, 0.999984, 0.999808, 0.999715, 0.999831, 0.999831, 0.999930, 0.999893, 0.999904, 0.999891, 0.999933, 0.999963, 1.000090, 1.000060, 0.999985, 1.000026, 1.000038, 1.000038, 1.000027, 1.000027, 1.000148, 1.000320, 1.000320, 1.000165, 1.000165, 1.000268, 1.000206, 1.000116, 1.000116, 1.000116, 1.000116, 1.000116, 1.000046, 1.000061, 1.000061, 1.000201, 1.000201, 1.000201, 1.000201, 0.999988, 0.999988, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052, 1.000052,  },
    { 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 0.999989, 1.000000, 0.999982, 0.999982, 1.000037, 1.000009, 1.000009, 0.999996, 1.000007, 1.000016, 1.000016, 1.000003, 1.000003, 1.000003, 0.999991, 0.999977, 1.000018, 1.000003, 0.999986, 0.999986, 1.000000, 1.000015, 1.000013, 1.000013, 0.999972, 0.999957, 0.999974, 1.000016, 0.999993, 1.000004, 0.999991, 1.000008, 1.000019, 0.999983, 0.999992, 1.000007, 0.999979, 0.999997, 1.000014, 1.000003, 1.000003, 0.999989, 1.000003, 1.000013, 1.000015, 1.000006, 0.999993, 1.000026, 0.999998, 0.999990, 0.999991, 0.999991, 0.999982, 1.000006, 1.000006, 1.000013, 1.000013, 1.000013, 1.000013, 1.000013, 1.000007, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 0.999955, 0.999892, 1.000013, 1.000013, 0.999958, 0.999970, 1.000042, 1.000095, 1.000189, 1.000057, 1.000033, 1.000033, 1.000060, 1.000058, 1.000055, 0.999980, 0.999949, 0.999949, 0.999949, 0.999845, 0.999845, 0.999919, 0.999919, 0.999919, 0.999919, 0.999919, 0.999987, 0.999895, 0.999895, 0.999953, 0.999953, 0.999953, 0.999891, 0.999891, 0.999936, 1.000008, 1.000039, 1.000039, 1.000065, 0.999986, 0.999986, 0.999977, 0.999977, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950, 0.999950,  },
    { 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 0.999992, 0.999992, 1.000010, 1.000010, 1.000021, 1.000023, 1.000005, 0.999999, 1.000015, 1.000022, 1.000022, 1.000022, 1.000022, 1.000004, 0.999980, 0.999978, 0.999969, 0.999988, 0.999981, 0.999995, 1.000013, 1.000008, 1.000008, 1.000014, 1.000015, 1.000012, 1.000000, 0.999999, 1.000003, 1.000006, 1.000000, 1.000000, 0.999991, 1.000004, 1.000003, 0.999998, 0.999998, 1.000003, 1.000000, 0.999997, 0.999982, 1.000000, 0.999988, 0.999988, 0.999995, 1.000000, 0.999999, 1.000002, 1.000002, 1.000005, 1.000003, 1.000003, 1.000003, 1.000000, 1.000002, 0.999996, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 0.999997, 1.000040, 1.000004, 1.000004, 1.000006, 0.999967, 0.999967, 0.999967, 0.999995, 0.999995, 0.999995, 1.000045, 1.000045, 1.000045, 1.000045, 1.000045, 1.000045, 1.000050, 1.000050, 1.000050, 1.000027, 0.999987, 0.999998, 1.000003, 0.999999, 0.999985, 1.000003, 0.999962, 0.999979, 0.999966, 0.999996, 1.000018, 1.000018, 1.000018, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048, 1.000048,  },
    { 0.999921, 0.999995, 0.999984, 1.000001, 0.999993, 1.000002, 1.000005, 1.000001, 1.000003, 1.000004, 0.999999, 0.999999, 0.999996, 0.999999, 1.000003, 0.999999, 0.999998, 0.999997, 1.000000, 1.000001, 0.999998, 0.999997, 0.999998, 1.000002, 1.000001, 1.000001, 0.999990, 0.999994, 1.000001, 1.000001, 0.999995, 0.999996, 0.999998, 0.999998, 1.000008, 0.999999, 0.999996, 0.999997, 0.999994, 0.999999, 0.999995, 0.999994, 0.999996, 0.999995, 1.000002, 0.999995, 1.000002, 0.999997, 0.999995, 1.000001, 1.000004, 1.000002, 0.999991, 0.999999, 1.000003, 1.000004, 0.999997, 0.999999, 0.999999, 0.999995, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 1.000000, 0.999993, 0.999993, 0.999990, 0.999990, 0.999990, 0.999990, 0.999990, 0.999990, 0.999990, 0.999992, 0.999992, 0.999992, 0.999992, 0.999992, 0.999992, 0.999992, 0.999996, 0.999996, 0.999996, 0.999996, 1.000000, 1.000000, 1.000000, 0.999998, 0.999998, 0.999998, 0.999988, 0.999988, 0.999988, 0.999988, 0.999988, 0.999988, 0.999988, 0.999988, 0.999988, 0.999988, 0.999988, 0.999988, 0.999988, 0.999988, 0.999988, 0.999988, 0.999985, 0.999985, 0.999985, 0.999985, 0.999985, 0.999985, 0.999985, 0.999985, 0.999985, 0.999993, 0.999993, 0.999993, 0.999993, 0.999993, 0.999993, 0.999993, 0.999993, 0.999993, 0.999993, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999998, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 0.999999,  },
    { 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000,  },
    { 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000,  },
#else
    { 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, },
    { 0.616131, 0.616131, 0.734747, 0.886817, 0.980358, 0.954706, 0.950045, 0.960931, 0.959150, 0.943952, 0.930077, 0.918955, 0.908105, 0.900059, 0.890206, 0.882758, 0.876392, 0.871656, 0.867785, 0.864705, 0.862837, 0.860063, 0.858112, 0.855724, 0.854318, 0.853730, 0.854255, 0.854730, 0.856689, 0.858025, 0.859946, 0.861590, 0.865622, 0.868217, 0.870760, 0.873500, 0.876042, 0.878973, 0.882292, 0.885696, 0.892888, 0.897370, 0.900918, 0.905012, 0.907881, 0.911784, 0.914552, 0.918197, 0.927057, 0.930175, 0.934090, 0.936766, 0.940359, 0.944065, 0.946316, 0.947698, 0.958108, 0.960000, 0.961662, 0.964533, 0.967846, 0.971715, 0.972701, 0.976633, 0.986332, 0.988553, 0.991205, 0.994059, 0.998284, 0.999573, 1.001752, 1.006336, 1.016049, 1.018810, 1.020155, 1.022868, 1.023305, 1.030555, 1.030578, 1.032943, 1.043712, 1.047066, 1.047879, 1.054832, 1.057873, 1.060241, 1.068205, 1.063556, 1.076127, 1.080065, 1.084100, 1.082207, 1.083114, 1.087343, 1.093541, 1.093648, 1.091946, 1.094561, 1.080420, 1.098269, 1.110210, 1.127212, 1.112505, 1.115807, 1.128031, 1.110317, 1.106405, 1.115765, 1.108560, 1.100118, 1.096582, 1.097625, 1.094705, 1.112193, 1.098206, 1.111359, 1.102994, 1.102994, 1.113800, 1.109949, 1.109949, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, 1.112013, },
    { 0.682484, 0.880496, 0.933150, 0.958092, 0.920851, 0.914449, 0.893873, 0.876759, 0.876373, 0.899515, 0.913776, 0.922544, 0.923000, 0.920533, 0.926424, 0.922544, 0.922558, 0.922367, 0.921105, 0.922131, 0.922986, 0.922701, 0.921832, 0.918927, 0.917866, 0.916825, 0.916769, 0.916389, 0.917947, 0.919901, 0.922736, 0.925191, 0.929896, 0.933066, 0.935910, 0.938847, 0.941973, 0.945050, 0.947802, 0.950800, 0.954503, 0.957288, 0.959916, 0.962157, 0.964407, 0.966783, 0.968470, 0.970027, 0.973132, 0.974853, 0.976195, 0.977813, 0.978842, 0.980216, 0.981274, 0.982492, 0.984145, 0.985066, 0.985370, 0.986200, 0.986943, 0.987840, 0.988997, 0.989405, 0.990457, 0.991030, 0.991626, 0.992166, 0.993854, 0.993865, 0.994239, 0.993748, 0.995467, 0.995010, 0.995235, 0.997263, 0.996522, 0.996437, 0.998079, 0.997185, 0.995883, 0.997825, 0.995797, 0.996259, 0.995685, 0.994869, 0.993122, 0.994995, 0.995255, 0.992955, 0.993960, 0.995288, 0.998428, 0.997589, 1.000767, 0.998583, 1.000946, 1.001708, 1.005122, 1.004659, 1.004930, 1.007516, 1.010077, 1.015583, 1.011771, 1.013571, 1.016376, 1.022755, 1.020342, 1.020257, 1.019837, 1.022947, 1.028265, 1.012395, 1.011431, 1.024815, 1.032472, 1.025095, 1.025829, 1.025144, 1.031136, 1.032366, 1.014361, 1.015134, 1.021166, 1.006008, 1.014564, 1.008802, 0.986902, 1.013066, 1.015823, 1.003702, 1.008200, 1.000433, 1.008661, 0.993279, 1.025083, 1.008555, 1.016568, 0.989536, 0.975502, 0.993166, 0.992309, 0.979477, 0.963696, 0.966868, 0.976616, 0.969930, 0.983457, 0.983457, 1.000261, 0.996421, 0.992135, 0.982932, 0.979702, 0.980815, 0.991218, 0.992173, 1.006269, 0.993281, 0.991224, 0.992747, 0.989325, 0.987845, 0.987845, 0.989084, 0.997563, 0.997563, 1.003053, 1.002884, 1.003967, 1.007797, 1.009997, 1.016264, 1.020943, 1.020943, 1.025365, 1.025365, 1.025365, 1.027905, 1.027905, 1.027905, 1.027905, 1.034669, 1.041676, 1.041676, 1.041676, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, 1.045761, },
    { 0.789151, 0.895977, 0.899902, 0.888249, 0.863900, 0.849525, 0.855401, 0.884939, 0.891570, 0.910757, 0.920988, 0.913430, 0.944910, 0.947936, 0.948704, 0.950504, 0.953459, 0.956819, 0.956571, 0.954463, 0.954719, 0.955415, 0.955631, 0.955920, 0.956659, 0.957066, 0.957613, 0.957999, 0.958500, 0.959206, 0.960202, 0.961279, 0.962476, 0.963613, 0.964988, 0.966308, 0.967875, 0.969465, 0.971099, 0.972745, 0.974691, 0.976501, 0.978060, 0.979447, 0.980996, 0.981924, 0.983243, 0.984302, 0.985790, 0.986402, 0.987427, 0.988074, 0.988790, 0.989732, 0.990233, 0.990590, 0.991629, 0.992656, 0.992510, 0.992951, 0.993348, 0.993670, 0.994681, 0.994879, 0.995219, 0.996306, 0.996527, 0.996819, 0.997100, 0.996882, 0.998285, 0.997338, 0.997747, 0.997374, 0.999004, 0.999430, 0.999085, 0.998994, 1.000086, 1.000515, 0.999084, 0.999072, 0.997866, 0.997644, 0.997072, 0.999242, 0.998522, 0.997645, 0.996785, 0.995702, 0.998996, 0.996993, 0.996306, 0.997134, 0.994041, 0.996872, 0.995996, 0.997920, 0.997196, 0.997764, 0.999380, 1.000592, 1.001749, 1.001423, 1.004040, 1.003727, 1.007266, 1.008974, 1.011074, 1.011305, 1.008859, 1.014175, 1.011539, 1.018990, 1.016312, 1.018360, 1.016701, 1.024859, 1.019605, 1.021984, 1.017429, 1.013235, 1.010488, 1.016077, 1.015345, 1.013296, 1.011784, 1.006059, 1.029704, 1.019436, 1.029598, 1.013764, 1.020913, 1.021190, 1.014372, 1.011797, 1.012959, 1.020472, 1.016675, 1.015356, 1.010937, 1.015670, 1.019325, 1.017865, 1.025488, 1.025650, 1.025650, 1.025650, 1.020218, 1.029207, 1.030376, 1.024211, 1.023268, 1.023268, 1.023268, 1.023268, 1.028098, 1.027407, 1.032736, 1.032736, 1.030909, 1.030909, 1.030909, 1.030909, 1.025261, 1.013170, 1.013170, 1.014094, 1.014094, 1.014094, 1.015222, 1.015222, 1.015222, 1.015222, 1.022498, 1.022498, 1.022498, 1.022498, 1.022498, 1.007050, 1.007050, 1.004453, 1.004453, 1.004453, 1.004453, 1.004453, 1.006778, 1.010545, 1.010545, 1.010545, 1.010545, 1.010545, 1.010545, 1.010545, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, 1.018806, },
    { 0.814332, 0.896248, 0.876293, 0.844228, 0.834564, 0.870821, 0.895009, 0.927252, 0.945764, 0.945946, 0.961786, 0.968900, 0.970908, 0.979862, 0.980358, 0.979291, 0.978855, 0.976864, 0.977286, 0.976420, 0.977588, 0.976528, 0.976966, 0.976470, 0.976110, 0.975982, 0.976006, 0.975435, 0.975317, 0.975288, 0.975882, 0.976030, 0.976923, 0.977154, 0.978024, 0.978862, 0.979845, 0.979924, 0.981186, 0.982767, 0.983479, 0.984747, 0.985991, 0.987061, 0.987816, 0.988622, 0.989690, 0.990369, 0.991295, 0.991780, 0.992481, 0.993135, 0.993882, 0.994527, 0.994501, 0.995248, 0.995907, 0.996427, 0.996390, 0.996621, 0.997259, 0.997409, 0.998096, 0.997957, 0.998541, 0.998584, 0.999439, 0.998592, 0.999987, 0.999972, 0.999644, 1.000285, 1.000988, 1.000139, 1.001206, 1.001282, 1.000188, 1.001359, 1.001694, 1.001627, 1.000789, 1.000912, 1.001981, 1.000228, 1.000351, 1.002311, 1.002417, 1.002421, 1.002071, 1.000903, 1.000191, 1.001110, 1.000952, 0.999693, 1.001240, 1.000438, 1.000509, 1.001116, 0.999694, 0.999756, 1.001231, 1.000523, 1.001255, 1.000204, 1.001585, 1.003166, 1.000129, 1.000272, 1.005635, 1.003530, 1.001516, 1.008032, 1.012237, 1.006608, 1.009053, 1.011160, 1.013107, 1.012571, 1.008652, 1.013285, 1.013899, 1.009900, 1.022898, 1.020338, 1.022302, 1.013907, 1.011245, 1.015492, 1.012694, 1.007702, 1.018534, 1.008326, 1.017731, 1.014660, 1.019608, 1.005804, 1.010028, 1.013225, 1.007712, 1.009375, 1.011659, 1.011659, 1.005437, 1.008122, 1.008122, 1.006613, 1.003185, 1.007230, 1.005147, 1.005147, 1.007733, 1.004279, 1.004279, 1.004279, 1.008603, 1.008603, 1.008603, 1.002206, 1.012225, 1.011828, 1.011174, 1.011174, 1.011174, 1.020357, 1.020357, 1.020357, 1.020357, 1.020357, 1.020357, 1.021572, 1.021572, 1.021572, 1.021572, 1.021572, 1.021572, 1.019650, 1.019650, 1.019650, 1.019650, 1.019650, 1.019650, 1.019650, 1.019650, 1.019650, 1.019650, 1.019650, 1.010059, 1.010059, 1.010059, 1.010059, 1.010059, 1.005427, 1.005427, 1.005427, 1.013256, 1.013256, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, 1.009970, },
    { 0.858227, 0.835587, 0.909241, 0.955173, 0.961592, 0.973367, 0.978602, 0.983938, 0.984539, 0.987252, 0.985549, 0.986137, 0.987582, 0.987367, 0.987766, 0.987784, 0.987745, 0.988689, 0.988358, 0.988600, 0.988875, 0.989293, 0.989705, 0.990029, 0.990470, 0.991156, 0.991551, 0.992208, 0.992572, 0.993020, 0.993576, 0.993856, 0.994439, 0.994666, 0.994902, 0.995232, 0.995428, 0.995635, 0.995890, 0.996078, 0.996244, 0.996496, 0.996496, 0.996914, 0.997054, 0.997226, 0.997453, 0.997607, 0.997668, 0.997852, 0.997987, 0.997985, 0.998166, 0.998320, 0.998163, 0.998626, 0.998849, 0.999001, 0.998870, 0.999212, 0.998890, 0.999065, 0.999312, 0.999570, 0.999283, 0.999392, 0.999472, 0.999559, 1.000136, 0.999971, 1.000137, 1.000171, 1.000619, 0.999684, 1.000420, 1.000286, 0.999898, 0.999951, 1.000012, 0.999540, 1.000046, 1.000230, 1.000375, 1.000555, 1.000350, 0.999877, 1.000192, 1.001255, 1.000443, 1.000823, 1.000760, 1.000983, 1.000327, 0.999792, 1.000579, 0.999569, 1.000239, 0.999329, 0.998884, 1.000581, 1.000055, 0.999467, 1.000162, 0.998296, 0.997568, 0.997628, 0.998421, 0.998911, 0.997357, 0.998709, 0.997042, 0.996396, 0.999556, 1.000073, 0.999243, 1.000316, 1.000907, 0.999008, 1.004315, 1.002645, 1.004206, 1.007813, 1.008300, 1.004697, 1.005047, 1.004431, 0.998737, 1.001784, 1.000455, 1.001740, 1.001106, 1.002817, 1.003844, 1.003530, 1.000599, 0.994017, 1.001614, 1.000397, 0.996718, 0.997037, 0.998441, 1.000001, 0.993741, 1.000908, 1.000908, 1.001036, 1.001036, 1.003975, 1.003975, 1.008938, 1.008785, 1.005417, 1.004545, 0.998832, 0.999253, 1.000662, 0.996537, 0.995415, 0.997241, 0.990184, 0.992132, 0.992132, 1.000281, 1.000281, 1.000447, 0.999427, 0.999427, 0.999427, 1.000596, 1.000596, 1.000596, 1.000596, 1.000596, 1.000596, 1.003926, 1.003926, 1.003926, 1.003926, 1.003926, 1.002241, 1.002241, 1.002241, 1.002241, 1.002241, 0.999984, 0.999984, 0.999984, 0.999984, 0.999984, 0.999984, 0.999984, 0.999984, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, 1.004992, },
    { 0.849514, 0.967738, 0.982055, 0.985196, 0.988990, 0.992610, 0.989578, 0.990533, 0.994646, 0.994194, 0.994784, 0.995109, 0.995116, 0.995406, 0.995684, 0.996098, 0.996242, 0.996673, 0.996910, 0.997312, 0.997416, 0.997589, 0.997800, 0.998024, 0.998077, 0.998168, 0.998279, 0.998397, 0.998475, 0.998393, 0.998379, 0.998509, 0.998463, 0.998637, 0.998609, 0.998689, 0.998628, 0.998793, 0.998716, 0.998763, 0.998837, 0.999005, 0.999017, 0.999103, 0.999218, 0.999230, 0.999159, 0.999138, 0.999170, 0.999117, 0.999173, 0.999350, 0.999440, 0.999405, 0.999402, 0.999642, 0.999779, 0.999514, 0.999587, 0.999662, 0.999539, 0.999542, 0.999493, 0.999791, 0.999788, 0.999623, 0.999436, 0.999813, 0.999996, 0.999789, 0.999788, 0.999908, 0.999775, 0.999595, 0.999552, 0.999594, 0.999823, 0.999817, 0.999720, 0.999997, 1.000167, 1.000052, 1.000043, 0.999362, 0.999311, 0.999809, 0.999453, 0.999422, 0.999543, 1.000417, 0.999728, 0.999776, 1.000459, 1.000544, 0.999527, 0.999973, 0.999542, 0.999629, 0.999543, 0.999983, 0.999980, 0.999725, 0.999206, 0.998993, 0.999610, 0.999988, 0.999857, 1.000845, 1.000643, 0.999988, 0.999580, 0.998932, 0.999068, 1.000619, 0.999884, 0.999302, 0.999250, 1.002150, 0.999881, 0.999011, 0.998997, 1.000695, 1.000825, 1.000397, 1.002974, 0.998637, 0.997673, 0.997554, 0.998931, 1.001232, 1.000958, 1.001564, 0.999779, 1.000649, 0.999308, 1.000964, 1.001280, 1.002232, 1.000503, 0.998577, 0.998245, 1.001079, 1.001291, 0.999071, 0.999071, 1.000005, 1.001124, 1.001384, 1.001663, 1.003587, 1.003587, 1.003079, 1.002593, 1.001578, 1.000020, 1.001489, 1.001913, 1.000311, 1.001327, 1.002771, 1.002771, 1.002579, 0.998380, 0.998380, 0.998947, 0.998947, 1.003311, 1.002575, 1.002575, 1.001160, 1.001160, 1.001160, 1.001160, 1.001160, 1.001160, 1.001160, 1.001160, 1.001160, 1.001160, 1.001160, 1.001026, 1.001031, 1.001031, 1.001329, 1.001329, 1.001329, 1.000726, 1.000726, 1.000726, 1.000726, 1.002521, 1.001268, 1.001268, 1.001268, 1.001268, 0.999547, 0.999547, 0.999547, 1.000632, 1.000632, 1.000632, 1.000632, 1.000082, 1.000082, 1.000082, 1.000082, 1.000082, 1.000082, 1.000082, 1.000082, 1.000082, 1.000082, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, 1.001154, },
    { 0.920871, 0.989518, 0.996647, 0.997549, 0.998742, 1.000943, 1.000874, 1.001488, 1.001089, 1.000924, 1.000418, 1.000218, 0.999888, 0.999827, 0.999459, 0.999532, 0.999514, 0.999490, 0.999290, 0.999342, 0.999446, 0.999536, 0.999412, 0.999405, 0.999531, 0.999554, 0.999526, 0.999648, 0.999569, 0.999591, 0.999564, 0.999553, 0.999626, 0.999667, 0.999671, 0.999539, 0.999683, 0.999676, 0.999702, 0.999697, 0.999717, 0.999760, 0.999754, 0.999807, 0.999786, 0.999830, 0.999758, 0.999716, 0.999755, 0.999823, 0.999932, 0.999887, 0.999905, 0.999868, 0.999858, 0.999822, 0.999884, 1.000041, 0.999881, 0.999880, 1.000030, 0.999878, 0.999975, 0.999914, 0.999847, 0.999974, 0.999851, 0.999855, 0.999881, 1.000058, 0.999940, 1.000075, 0.999833, 0.999786, 0.999887, 0.999897, 0.999671, 1.000026, 0.999860, 0.999627, 0.999917, 0.999961, 0.999614, 0.999897, 0.999509, 0.999874, 1.000254, 0.999772, 0.999761, 1.000059, 0.999613, 0.999925, 0.999479, 0.999945, 0.999423, 0.999651, 1.000066, 0.999763, 1.000078, 0.999873, 0.999871, 1.000126, 0.999602, 0.999646, 0.999434, 0.999696, 0.999213, 1.000221, 1.000273, 0.999856, 1.000287, 1.000048, 0.999923, 0.999587, 0.999996, 0.998859, 0.999870, 1.000013, 1.000513, 0.999477, 0.999637, 1.000142, 0.999760, 0.999749, 0.999794, 1.000090, 0.999062, 0.998599, 0.999196, 0.998599, 0.999449, 1.000884, 1.001418, 1.001911, 1.000091, 0.999568, 0.998772, 0.998567, 1.000621, 0.999673, 1.000687, 1.002959, 0.999669, 0.999334, 1.000141, 0.998551, 0.999158, 0.999158, 0.999158, 0.998715, 0.999914, 1.000906, 1.000649, 1.000755, 1.000378, 1.000378, 0.999512, 0.999759, 0.999759, 0.999425, 0.998542, 0.999474, 0.999610, 0.999685, 1.000120, 1.000120, 1.000669, 1.000669, 1.000547, 1.000547, 1.000547, 1.000547, 0.999443, 0.999911, 0.999911, 0.999911, 1.001443, 1.001443, 1.000810, 1.000810, 1.000810, 0.999297, 0.999297, 0.999297, 0.999297, 0.999950, 0.999950, 0.999188, 0.999188, 0.999188, 0.999188, 0.999188, 0.999188, 0.999188, 0.999188, 0.999188, 0.999188, 0.999188, 0.999188, 0.999188, 1.000086, 1.000086, 1.000086, 1.000086, 1.000086, 1.000086, 1.000086, 1.000086, 1.000086, 1.000086, 1.000164, 1.000164, 1.000164, 1.000164, 1.000164, 1.000164, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, 0.999236, },
    { 0.983884, 1.009527, 0.998399, 0.998548, 0.998817, 0.999316, 0.999543, 0.996498, 0.999865, 1.000339, 0.999933, 0.999915, 0.999840, 1.000045, 1.000348, 1.000024, 0.999951, 1.000038, 0.999801, 1.000194, 1.000213, 1.000145, 1.000086, 1.000056, 1.000119, 0.999890, 0.999941, 0.999898, 0.999950, 0.999867, 1.000043, 0.999971, 0.999986, 1.000027, 1.000016, 0.999969, 0.999999, 0.999975, 0.999970, 0.999990, 0.999974, 0.999990, 1.000003, 0.999955, 0.999985, 0.999990, 0.999973, 0.999986, 0.999996, 1.000011, 1.000029, 0.999961, 0.999968, 1.000010, 0.999949, 0.999984, 0.999970, 0.999959, 0.999986, 1.000006, 0.999956, 1.000019, 0.999980, 0.999974, 1.000037, 1.000024, 0.999996, 0.999963, 1.000020, 0.999996, 1.000023, 1.000038, 1.000023, 0.999969, 0.999985, 0.999986, 1.000033, 0.999991, 1.000006, 1.000031, 0.999973, 1.000074, 0.999942, 0.999926, 0.999948, 1.000055, 0.999984, 0.999867, 0.999994, 0.999941, 1.000031, 0.999998, 1.000054, 1.000011, 1.000009, 0.999933, 0.999837, 1.000151, 0.999973, 1.000008, 1.000081, 0.999886, 1.000129, 1.000051, 0.999748, 0.999908, 1.000367, 1.000060, 1.000032, 1.000296, 1.000238, 1.000135, 1.000086, 1.000070, 0.999961, 0.999999, 0.999738, 0.999696, 1.000215, 1.000302, 1.000066, 1.000019, 0.999921, 0.999859, 0.999876, 0.999814, 0.999672, 0.999922, 1.000232, 1.000249, 1.000077, 0.999522, 0.999170, 1.000412, 1.000480, 1.000544, 1.000280, 0.999999, 1.000061, 1.000291, 1.000023, 0.999751, 0.999210, 0.999799, 0.999731, 1.000166, 0.999796, 1.000074, 0.999907, 0.999443, 1.000727, 1.000373, 0.999860, 1.000092, 0.999796, 1.000332, 0.999885, 1.000012, 1.000141, 0.999420, 1.000435, 0.999961, 1.000131, 0.999702, 0.999281, 0.999257, 1.000092, 0.999929, 1.000442, 1.000034, 0.999452, 0.999570, 0.999108, 0.999829, 0.999834, 0.999734, 0.999914, 0.999008, 0.998763, 0.999507, 0.999716, 0.999819, 1.000297, 0.999654, 1.000330, 1.000227, 1.000450, 1.000444, 1.000000, 1.000000, 1.000000, 1.000899, 0.999760, 0.999760, 1.000840, 1.000459, 0.999433, 0.999433, 0.999933, 0.999753, 1.000344, 1.000348, 1.000501, 1.000219, 1.000771, 1.000624, 1.000413, 1.000203, 0.999734, 1.000613, 1.000494, 0.999514, 1.000282, 1.000038, 1.000317, 1.000192, 0.999972, 0.999738, 0.999804, 1.000320, 1.000031, 1.000031, 1.000031, 1.000031, 1.000031, 1.000031, 1.000031, 1.000013, 0.999737, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, 0.999692, },
    { 0.972613, 1.005636, 1.000563, 1.000465, 0.999341, 1.000017, 0.999630, 0.999826, 1.000067, 1.000026, 0.999776, 1.000350, 1.000098, 0.999771, 1.000017, 0.999927, 1.000153, 1.000053, 1.000045, 1.000025, 1.000057, 1.000000, 0.999953, 0.999978, 0.999879, 1.000067, 1.000001, 1.000033, 1.000003, 1.000129, 1.000133, 0.999988, 1.000043, 1.000061, 0.999960, 1.000029, 1.000011, 1.000043, 0.999970, 0.999969, 1.000078, 1.000021, 0.999938, 0.999995, 1.000016, 0.999960, 0.999931, 0.999965, 0.999993, 1.000002, 0.999980, 0.999972, 0.999960, 0.999952, 1.000024, 0.999992, 0.999965, 1.000005, 0.999979, 0.999994, 0.999951, 0.999982, 0.999927, 0.999977, 0.999969, 0.999953, 1.000000, 1.000026, 1.000007, 1.000084, 1.000018, 0.999933, 0.999953, 1.000088, 0.999969, 1.000011, 1.000112, 0.999922, 1.000015, 1.000099, 0.999974, 1.000027, 1.000068, 1.000036, 1.000059, 1.000073, 0.999891, 0.999927, 1.000089, 1.000148, 1.000019, 1.000053, 0.999965, 1.000004, 1.000009, 1.000013, 1.000036, 0.999920, 0.999922, 1.000045, 0.999952, 0.999985, 0.999909, 0.999912, 1.000083, 1.000111, 0.999937, 0.999965, 1.000067, 0.999992, 1.000182, 1.000169, 1.000110, 0.999965, 0.999937, 0.999688, 1.000110, 0.999912, 1.000067, 1.000033, 0.999755, 0.999927, 1.000160, 1.000469, 1.000122, 1.000154, 1.000144, 1.000154, 0.999902, 0.999619, 0.999788, 0.999892, 0.999974, 0.999919, 1.000067, 1.000289, 0.999877, 0.999938, 1.000251, 1.000306, 1.000398, 1.000140, 0.999697, 1.000048, 0.999990, 1.000091, 0.999976, 1.000639, 1.000194, 1.000138, 1.000310, 0.999639, 0.999651, 0.999889, 0.999977, 1.000589, 1.000297, 1.000558, 1.000342, 0.999972, 1.000066, 0.999743, 0.999917, 0.999895, 0.999860, 1.000289, 1.000542, 1.000366, 0.999994, 0.999970, 0.999884, 1.000112, 0.999925, 0.999863, 1.000140, 1.000035, 0.999967, 1.000013, 0.999705, 1.000061, 0.999820, 1.000120, 1.000329, 0.999935, 0.999759, 1.000075, 0.999780, 0.999872, 1.000153, 0.999895, 0.999917, 0.999848, 0.999907, 0.999650, 0.999864, 1.000030, 0.999972, 0.999892, 1.000175, 0.999824, 0.999844, 1.000162, 0.999860, 0.999860, 0.999860, 0.999931, 0.999865, 1.000174, 1.000353, 1.000186, 1.000186, 1.000101, 1.000069, 0.999987, 1.000273, 1.000374, 1.000190, 0.999860, 0.999860, 0.999860, 0.999860, 0.999790, 1.000435, 1.000435, 1.000435, 1.000482, 1.000482, 1.000417, 1.000319, 1.000286, 1.000353, 1.000574, 1.000574, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, 1.000371, },
    { 0.969643, 0.995186, 0.999637, 1.000524, 0.999958, 0.999958, 1.000003, 0.999882, 0.999914, 1.000140, 0.999899, 0.999910, 1.000087, 0.999961, 1.000175, 0.999951, 0.999953, 1.000086, 1.000040, 1.000061, 1.000059, 1.000057, 1.000023, 0.999947, 0.999984, 1.000004, 1.000044, 0.999992, 1.000007, 1.000009, 1.000021, 1.000054, 1.000038, 1.000030, 0.999997, 1.000020, 0.999975, 1.000000, 0.999983, 1.000027, 1.000026, 1.000042, 1.000023, 1.000009, 1.000054, 0.999938, 1.000027, 0.999986, 0.999916, 0.999953, 0.999992, 0.999979, 1.000049, 0.999955, 0.999968, 1.000013, 0.999996, 0.999961, 1.000015, 0.999975, 0.999987, 0.999966, 1.000013, 0.999965, 0.999989, 0.999976, 0.999998, 1.000023, 1.000043, 1.000031, 0.999963, 0.999975, 0.999964, 0.999953, 1.000050, 1.000048, 1.000004, 1.000007, 0.999973, 0.999938, 0.999985, 1.000016, 0.999983, 1.000007, 1.000065, 1.000030, 1.000012, 0.999927, 0.999978, 0.999998, 1.000026, 1.000004, 1.000014, 0.999979, 0.999934, 1.000009, 1.000060, 1.000016, 0.999951, 1.000031, 1.000074, 0.999946, 1.000027, 1.000027, 0.999956, 0.999998, 0.999914, 1.000032, 0.999988, 1.000005, 0.999905, 0.999891, 1.000047, 0.999804, 0.999948, 1.000019, 0.999941, 1.000052, 1.000015, 0.999903, 0.999844, 0.999907, 1.000020, 1.000077, 0.999830, 1.000096, 1.000254, 0.999959, 0.999860, 1.000008, 0.999844, 1.000119, 1.000277, 1.000211, 1.000230, 0.999929, 1.000405, 1.000142, 1.000270, 1.000255, 1.000137, 1.000228, 0.999847, 0.999916, 0.999787, 0.999866, 1.000208, 0.999924, 1.000359, 1.000178, 1.000075, 1.000027, 1.000003, 0.999950, 1.000024, 1.000054, 1.000042, 0.999851, 1.000153, 1.000090, 0.999910, 1.000029, 1.000052, 1.000131, 1.000080, 1.000192, 1.000076, 1.000029, 1.000209, 1.000044, 0.999959, 0.999974, 0.999847, 0.999951, 1.000046, 0.999922, 1.000044, 0.999857, 0.999907, 0.999974, 1.000027, 1.000016, 1.000086, 1.000045, 1.000058, 1.000000, 0.999747, 0.999829, 0.999894, 0.999832, 0.999818, 0.999790, 0.999954, 1.000020, 0.999994, 1.000041, 0.999971, 1.000042, 1.000043, 1.000025, 1.000088, 0.999924, 0.999881, 0.999942, 1.000044, 0.999982, 0.999825, 1.000037, 1.000019, 1.000103, 1.000011, 1.000004, 0.999973, 0.999980, 0.999997, 1.000004, 0.999952, 1.000045, 1.000048, 1.000048, 1.000048, 1.000048, 1.000105, 1.000111, 1.000089, 1.000089, 1.000089, 1.000089, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, 1.000106, },
    { 0.993031, 1.003014, 0.999715, 0.999715, 0.999715, 0.999945, 0.999993, 1.000025, 0.999986, 0.999976, 1.000036, 1.000081, 1.000039, 0.999983, 0.999929, 0.999946, 0.999991, 1.000067, 1.000040, 1.000040, 1.000016, 1.000029, 1.000012, 1.000033, 0.999997, 1.000045, 1.000016, 1.000057, 1.000028, 1.000021, 1.000007, 1.000023, 0.999971, 1.000047, 0.999960, 1.000017, 0.999967, 1.000008, 1.000007, 0.999969, 0.999993, 1.000043, 1.000023, 1.000030, 0.999991, 0.999995, 1.000001, 1.000036, 1.000003, 0.999981, 1.000031, 1.000027, 1.000033, 1.000000, 0.999931, 0.999958, 1.000011, 1.000004, 1.000012, 1.000008, 1.000023, 1.000075, 1.000014, 1.000033, 1.000072, 1.000052, 1.000039, 0.999999, 1.000060, 1.000013, 1.000001, 1.000033, 1.000006, 1.000052, 1.000036, 0.999992, 0.999966, 0.999977, 1.000008, 1.000014, 0.999963, 1.000022, 0.999981, 0.999970, 0.999988, 0.999998, 1.000002, 1.000023, 1.000015, 0.999974, 0.999990, 0.999978, 1.000011, 0.999977, 1.000008, 1.000042, 1.000017, 1.000012, 0.999998, 1.000041, 1.000032, 0.999981, 1.000063, 1.000000, 1.000017, 0.999949, 0.999952, 0.999963, 0.999961, 1.000037, 0.999985, 1.000009, 1.000075, 1.000029, 1.000030, 1.000046, 0.999920, 0.999930, 1.000005, 0.999908, 0.999880, 1.000008, 1.000111, 1.000044, 0.999912, 1.000011, 1.000090, 1.000026, 0.999871, 0.999857, 0.999971, 1.000252, 1.000148, 1.000154, 1.000110, 1.000110, 1.000153, 1.000022, 1.000170, 1.000071, 1.000021, 1.000024, 1.000022, 0.999902, 0.999962, 0.999925, 1.000006, 1.000006, 1.000006, 1.000030, 1.000030, 0.999999, 0.999952, 0.999952, 0.999952, 0.999952, 1.000013, 0.999988, 1.000027, 1.000014, 1.000014, 1.000014, 1.000014, 1.000014, 1.000014, 1.000014, 1.000059, 1.000059, 1.000059, 0.999999, 0.999999, 0.999969, 0.999969, 0.999969, 0.999955, 0.999955, 0.999981, 0.999981, 0.999995, 0.999995, 0.999995, 0.999995, 0.999995, 0.999995, 0.999995, 0.999995, 0.999995, 0.999964, 0.999964, 0.999964, 0.999964, 0.999964, 0.999964, 0.999964, 0.999964, 1.000012, 0.999992, 1.000015, 1.000002, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, },
    { 0.998593, 1.002169, 0.999993, 0.999993, 0.999993, 0.999993, 1.000001, 1.000005, 1.000023, 1.000007, 1.000019, 1.000017, 1.000002, 1.000024, 1.000000, 1.000031, 1.000005, 1.000006, 1.000024, 0.999972, 0.999952, 1.000000, 1.000028, 1.000031, 1.000016, 1.000006, 1.000005, 1.000000, 0.999994, 0.999994, 1.000021, 1.000012, 0.999990, 1.000005, 0.999996, 0.999990, 0.999971, 0.999997, 0.999989, 1.000009, 0.999998, 0.999990, 0.999966, 1.000010, 1.000015, 0.999989, 1.000003, 1.000000, 1.000024, 1.000003, 0.999990, 0.999979, 1.000020, 0.999932, 0.999972, 0.999973, 0.999964, 0.999936, 0.999924, 0.999951, 1.000024, 1.000024, 0.999983, 1.000005, 1.000026, 0.999964, 1.000050, 1.000011, 0.999988, 0.999928, 0.999972, 0.999991, 0.999970, 0.999946, 0.999956, 0.999923, 0.999969, 1.000032, 1.000037, 1.000071, 1.000031, 0.999988, 1.000004, 0.999989, 1.000034, 0.999981, 1.000016, 0.999999, 1.000039, 0.999984, 0.999970, 1.000029, 0.999987, 1.000014, 0.999996, 0.999993, 0.999968, 0.999994, 0.999982, 0.999971, 0.999975, 0.999956, 0.999966, 1.000079, 1.000025, 1.000022, 1.000018, 0.999850, 0.999961, 0.999955, 0.999996, 0.999997, 1.000061, 0.999991, 0.999957, 1.000009, 1.000001, 1.000042, 1.000002, 1.000025, 0.999935, 1.000025, 1.000028, 0.999935, 1.000019, 0.999984, 1.000034, 1.000019, 1.000070, 0.999994, 0.999993, 0.999993, 0.999983, 0.999983, 0.999942, 0.999985, 0.999988, 1.000059, 1.000035, 0.999973, 0.999975, 1.000004, 1.000019, 1.000019, 1.000000, 0.999986, 0.999947, 0.999947, 0.999947, 0.999966, 0.999966, 1.000014, 1.000014, 1.000014, 1.000019, 1.000032, 1.000032, 1.000034, 1.000034, 1.000029, 1.000029, 1.000029, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, 1.000258, },
    { 1.008129, 0.999989, 0.999989, 0.999989, 0.999989, 0.999989, 0.999988, 1.000001, 0.999985, 0.999992, 0.999998, 0.999985, 0.999980, 1.000013, 0.999993, 1.000005, 0.999978, 0.999975, 0.999990, 1.000001, 1.000002, 1.000004, 0.999995, 1.000006, 0.999986, 1.000003, 0.999995, 0.999992, 0.999995, 0.999988, 0.999998, 0.999996, 0.999991, 1.000002, 1.000006, 0.999996, 0.999997, 1.000005, 0.999984, 0.999991, 1.000004, 1.000000, 1.000002, 1.000008, 1.000015, 0.999996, 0.999976, 0.999983, 1.000013, 1.000001, 0.999984, 1.000007, 0.999998, 1.000004, 0.999983, 0.999979, 0.999964, 0.999977, 1.000041, 1.000075, 1.000015, 1.000020, 1.000025, 1.000071, 0.999968, 0.999994, 1.000008, 0.999938, 0.999969, 0.999996, 1.000016, 0.999966, 0.999935, 0.999973, 0.999970, 0.999950, 1.000004, 0.999986, 1.000021, 1.000066, 1.000004, 1.000031, 0.999954, 1.000035, 1.000018, 1.000041, 0.999997, 1.000004, 1.000050, 1.000059, 1.000012, 0.999986, 1.000012, 1.000017, 0.999953, 0.999981, 1.000027, 1.000002, 1.000030, 0.999960, 1.000021, 0.999991, 1.000008, 1.000018, 0.999994, 0.999986, 1.000042, 0.999968, 0.999986, 0.999971, 1.000005, 1.000015, 1.000025, 0.999999, 1.000033, 1.000003, 0.999995, 1.000037, 1.000022, 0.999998, 1.000006, 1.000047, 1.000012, 0.999965, 0.999983, 0.999954, 1.000019, 0.999976, 0.999996, 1.000003, 0.999958, 0.999998, 0.999992, 1.000010, 1.000010, 1.000006, 1.000003, 1.000003, 1.000033, 1.000006, 0.999984, 0.999980, 0.999971, 0.999961, 0.999998, 1.000033, 1.000044, 1.000016, 1.000007, 1.000048, 1.000009, 1.000009, 0.999991, 0.999944, 0.999960, 0.999952, 1.000004, 1.000007, 1.000007, 1.000021, 1.000009, 1.000054, 1.000008, 1.000018, 1.000011, 1.000011, 1.000011, 1.000030, 1.000045, 1.000045, 1.000101, 1.000085, 1.000043, 1.000020, 1.000029, 0.999964, 0.999964, 0.999964, 0.999964, 1.000050, 1.000018, 1.000018, 1.000018, 1.000010, 1.000043, 1.000043, 1.000043, 1.000043, 1.000018, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, 1.000017, },
    { 0.981024, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 0.999999, 1.000004, 0.999994, 0.999995, 1.000007, 1.000003, 1.000003, 0.999996, 0.999997, 1.000001, 0.999991, 0.999990, 0.999997, 1.000007, 1.000000, 1.000001, 1.000002, 1.000002, 1.000005, 1.000006, 1.000006, 1.000006, 1.000003, 1.000001, 1.000004, 1.000001, 1.000000, 0.999998, 0.999999, 1.000006, 1.000006, 0.999994, 1.000000, 0.999997, 0.999993, 0.999995, 0.999995, 1.000003, 1.000001, 1.000000, 1.000000, 0.999998, 1.000005, 1.000002, 1.000010, 1.000000, 1.000002, 0.999999, 0.999999, 1.000002, 0.999996, 0.999994, 0.999989, 0.999994, 0.999986, 0.999995, 1.000006, 0.999998, 1.000002, 1.000010, 1.000009, 1.000002, 1.000017, 1.000004, 1.000011, 1.000021, 0.999997, 0.999997, 0.999997, 0.999969, 0.999989, 0.999999, 0.999989, 0.999984, 1.000037, 1.000029, 1.000001, 0.999936, 0.999952, 0.999994, 0.999973, 0.999987, 1.000006, 1.000039, 0.999993, 0.999990, 1.000004, 1.000015, 0.999996, 1.000020, 0.999999, 0.999991, 0.999977, 0.999999, 1.000023, 0.999983, 1.000004, 1.000000, 0.999980, 0.999990, 1.000009, 0.999986, 0.999978, 0.999970, 0.999996, 0.999985, 1.000005, 0.999988, 0.999992, 1.000019, 1.000006, 1.000000, 1.000005, 1.000007, 1.000009, 1.000018, 1.000015, 1.000022, 1.000017, 1.000023, 1.000010, 0.999993, 1.000010, 1.000005, 1.000023, 0.999990, 1.000007, 1.000008, 0.999996, 0.999976, 0.999967, 0.999985, 0.999982, 0.999993, 0.999998, 1.000006, 0.999987, 0.999995, 0.999986, 1.000005, 1.000006, 1.000019, 1.000010, 0.999996, 1.000033, 1.000019, 1.000003, 1.000013, 0.999991, 0.999997, 0.999992, 0.999995, 0.999990, 0.999998, 0.999996, 0.999983, 0.999984, 0.999989, 0.999996, 0.999998, 1.000019, 1.000056, 1.000006, 1.000018, 1.000018, 1.000018, 1.000012, 1.000032, 1.000001, 1.000001, 1.000001, 0.999961, 0.999961, 0.999961, 0.999979, 0.999979, 0.999979, 0.999979, 0.999979, 0.999998, 0.999998, 0.999998, 0.999992, 0.999992, 0.999986, 0.999986, 0.999986, 0.999986, 0.999986, 0.999996, 0.999996, 0.999996, 0.999996, 0.999996, 0.999996, 0.999996, 0.999996, 0.999996, 0.999996, 0.999996, 0.999996, 0.999996, 0.999996, 0.999996, 0.999996, 0.999992, 0.999992, 0.999992, 0.999992, 0.999992, 0.999992, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, 1.000006, },
    { 0.993343, 0.999978, 1.000002, 0.999995, 0.999998, 1.000002, 0.999999, 1.000000, 1.000001, 1.000001, 1.000001, 1.000001, 0.999999, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000000, 1.000000, 1.000001, 1.000002, 1.000000, 1.000001, 0.999999, 0.999999, 1.000000, 0.999999, 0.999999, 0.999999, 0.999999, 1.000001, 1.000001, 1.000000, 1.000000, 0.999999, 1.000000, 1.000003, 1.000000, 0.999999, 1.000000, 1.000000, 1.000004, 0.999998, 1.000000, 0.999996, 0.999998, 1.000003, 0.999999, 1.000000, 0.999998, 1.000002, 1.000001, 1.000003, 0.999998, 1.000000, 1.000000, 1.000002, 1.000002, 1.000000, 0.999997, 0.999998, 0.999998, 1.000000, 0.999998, 0.999992, 0.999997, 0.999997, 0.999996, 0.999996, 0.999992, 0.999982, 0.999994, 1.000000, 0.999996, 0.999999, 1.000006, 0.999998, 0.999991, 0.999999, 1.000015, 1.000015, 1.000001, 1.000010, 1.000005, 0.999994, 1.000003, 0.999995, 0.999989, 0.999996, 1.000010, 1.000014, 1.000000, 1.000007, 1.000001, 1.000008, 1.000002, 0.999999, 1.000003, 1.000002, 0.999997, 1.000002, 1.000012, 1.000008, 1.000009, 0.999999, 1.000001, 0.999998, 0.999995, 0.999994, 0.999998, 1.000002, 0.999999, 0.999991, 0.999985, 0.999998, 1.000001, 0.999993, 0.999999, 1.000007, 0.999998, 0.999995, 1.000006, 1.000004, 1.000007, 0.999997, 1.000001, 0.999999, 1.000001, 0.999996, 0.999977, 0.999978, 0.999986, 0.999996, 0.999995, 0.999994, 0.999991, 0.999992, 0.999997, 1.000002, 1.000003, 1.000001, 1.000009, 0.999996, 1.000003, 1.000003, 1.000011, 1.000011, 1.000011, 1.000011, 1.000008, 1.000007, 1.000001, 1.000000, 0.999993, 0.999993, 0.999995, 0.999995, 1.000004, 1.000004, 1.000004, 1.000004, 1.000004, 1.000004, 0.999996, 0.999996, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, 1.000001, },
    { 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, },
    { 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, },
#endif
};


void
NoiseInjectionComp ( void )
{
    int  i;

    for ( i = 0; i < sizeof(NoiseInjectionCompensation1D)/sizeof(*NoiseInjectionCompensation1D); i++ )
        NoiseInjectionCompensation1D [i] = 1.f;
    for ( i = 0; i < sizeof(NoiseInjectionCompensation2D)/sizeof(**NoiseInjectionCompensation2D); i++ )
        NoiseInjectionCompensation2D [0][i] = 1.f;
}


// Quantizes a subband and calculates iSNR
float
ISNR_Schaetzer ( const float* input, const float SNRcomp, const int res )
{
    int    k;
    float  fac    = A [res];
    float  invfac = C [res];
    float  Signal = 1.e-30f;
    float  Fehler = 1.e-30f;
    float  tmp ;
    float  tmp2 ;
    int    idx;

    tmp = 0.;
    for ( k = 0; k < 36; k++ )
        tmp += input[k] * input[k];
    tmp *= QUANT / 36. / 32768 / 32768 ;
    idx  = tmp;

    // Summation of the absolute power and the quadratic error
    for ( k = 0; k < 36; k++ ) {
        tmp2    = input[k] * NoiseInjectionCompensation2D [res] [idx];
        Signal += tmp2 * tmp2;

        // q = ftol(in), correct rounding
        tmp = tmp2 * fac + 0xFF8000;
        tmp = (*(int*) & tmp - 0x4B7F8000) * invfac - tmp2;

        Fehler += tmp * tmp;
    }

    // Utilization of SNRcomp only if SNR > 1 !!!
    return Signal > Fehler  ?  Fehler / (SNRcomp * Signal)  :  Fehler / Signal;
}


#ifdef BUGBUG
double _old;
double _new;
double _tmp;

double _Sum [18];
long   _Cnt [18];

double __Sum [18] [QUANT];
long   __Cnt [18] [QUANT];

void rep ( double _old, double _new, int res )
{
    int    i;
    _Sum [res] += sqrt (_old / _new );
    _Cnt [res] ++ ;
    i = _old * (  QUANT / 36. / 32768 / 32768 );
    // printf ("Res=%u, old=%f, new=%f, X=%f, %3u:", res, _old, _new, X[res], i ); fflush (stdout);
    __Sum [res][i] += sqrt (_old / _new );
    __Cnt [res][i] ++ ;
}

void reppr ( void )
{
    int i, j;
    printf ("\n\n==================\n");
    for ( i = 0; i < 18; i++ )
        if ( _Cnt[i] )
            printf ("%2u: %12.6f\n", i, _Sum[i]/_Cnt[i] * NoiseInjectionCompensation1D[i] );
    for ( i = 0; i < 18; i++ )
        for ( j = 0; j < QUANT; j++ )
            if ( __Cnt[i][j] )
                printf ("%2u[%3u]: %9.6f (%8lu)\n", i, j, __Sum[i][j]/__Cnt[i][j] * NoiseInjectionCompensation2D [i][j], __Cnt[i][j] );

}
#endif

// Linear quantizer for a subband
void
QuantizeSubband ( unsigned int* qu_output, const float* input, const int res )
{
    int    n;
    int    offset = D [res];
    float  mult   = A [res];
    float  tmp;
    int    idx;

    tmp = 0.;
    for ( n = 0; n < 36; n++ )
        tmp += input[n] * input[n];
    tmp *=  QUANT / 36. / 32768 / 32768 ;
    idx = tmp;

    mult   *= NoiseInjectionCompensation2D [res][idx];

    for ( n = 0; n < 36; n++, input++, qu_output++ ) {
        // q = ftol(in), correct rounding
        tmp = *input * mult + 0xFF8000;
        *qu_output  = (unsigned int)(*(int*) & tmp - 0x4B7F8000 + offset);

        // Limitation to 0...2D
        if ((unsigned int)*qu_output > (unsigned int)2*offset ) {
            *qu_output = mini( *qu_output, 2*offset);
            *qu_output = maxi( *qu_output,        0);
        }
#ifdef BUGBUG
        _old += *input * *input;
        _tmp  = (int)(*qu_output - offset) * C[res];
        _new += _tmp * _tmp;
#endif
    }
#ifdef BUGBUG
    rep ( _old, _new, res );
    _old = _new = 0;
#endif
}


// NoiseShaper for a subband
void
QuantizeSubbandWithNoiseShaping ( unsigned int* qu_output, const float* input, const int res, const float* FIR, float* errors )
{
#define E(x) *((int*)errors+(x))

    float  signal;
    float  tmp;
    float  mult    = A [res];
    float  invmult = C [res];
    int    offset  = D [res];
    int    n;
    int    quant;
    int    idx;

    tmp = 0.;
    for ( n = 0; n < 36; n++ )
        tmp += input[n] * input[n];
    tmp *=  QUANT / 36. / 32768 / 32768 ;
    idx = tmp;

    E(0) = E(1) = E(2) = E(3) = E(4) = 0;       // arghh, it produces pops on each frame boundary!

    for ( n = 0; n < 36; n++, input++, qu_output++ ) {
        signal = *input * NoiseInjectionCompensation2D [res][idx] - (FIR[4]*errors[n+0] + FIR[3]*errors[n+1] + FIR[2]*errors[n+2] + FIR[1]*errors[n+3] + FIR[0]*errors[n+4]);

        // quant = ftol(signal), correct rounding
        tmp   = signal * mult + 0xFF8000;
        quant = *(int*) & tmp - 0x4B7F8000;

        // calculate the current error and save it for error refeeding
        errors [n + 5] = invmult * quant - signal;

        //  limitation to +/-D
        quant = minf ( quant, +offset );
        quant = maxf ( quant, -offset );

        *qu_output = (unsigned int)(quant + offset);
#ifdef BUGBUG
        _old += *input * *input;
        _tmp  = invmult * quant;
        _new += _tmp * _tmp;
#endif
    }
#ifdef BUGBUG
    rep ( _old, _new, res );
    _old = _new = 0;
#endif
}

/* end of quant.c */
