/*====================================================================
 *
 *                          Copyright (C) 1999 by
 *             Digital Equipment Corporation, Maynard, Massachusetts
 *
 * This software is furnished under a license and may be used and  copied
 * only  in  accordance  with  the  terms  of  such  license and with the
 * inclusion of the above copyright notice.  This software or  any  other
 * copies  thereof may not be provided or otherwise made available to any
 * other person.  No title to and ownership of  the  software  is  hereby
 * transferred.
 *
 * The information in this software is subject to change  without  notice
 * and  should  not  be  construed  as  a commitment by Digital Equipment
 * Corporation.
 *
 * DIGITAL assumes no responsibility for the use or  reliability  of  its
 * software on equipment that is not supplied by DIGITAL.
 *
 *
 *
 *  FACILITY:
 *        INSTALL
 *
 *
 *  ABSTRACT:
 *        This is an example of a UDP/IP server using the IPC
 *        socket interface.
 *
 *
 *  ENVIRONMENT:
 *        UCX V1.2 or higher, VMS V5.2 or higher
 *
 *        This example is portable to ULTRIX. The include
 *        files are conditionally defined for both systems, and
 *        "perror" is used for error reporting.
 *  BUILD INSTRUCTIONS:
 *
 *       To link in VAXC/VMS you must have the following
 *       entries in your .opt file:
 *          sys$library:ucx$ipc.olb/lib
 *          sys$share:vaxcrtl.exe/share
 *
 *       For Compaq C or Compaq C++, compile /PREFIX=ALL and link via
 *          $ link UCX$UDP_SERVER_IPC
 *
 *    To build this example program, use commands of the following form:
 *
 *        using the Compaq C compiler:
 *
 *            $ cc/prefix=all UCX$UDP_SERVER_IPC.C
 *            $ link UCX$UDP_SERVER_IPC
 *
 *        using the Compaq C++ compiler:
 *
 *            $ cxx/prefix=all/define=VMS UCX$UDP_SERVER_IPC.C
 *            $ link UCX$UDP_SERVER_IPC
 *        using the VAX C compiler:
 *
 *            $  cc /vaxc UCX$UDP_SERVER_IPC.C
 *            $  link UCX$UDP_SERVER_IPC, -
 *                    SYS$LIBRARY:UCX$IPC/LIB, -
 *                    SYS$INPUT/OPTIONS
 *            SYS$SHARE:UCX$IPC_SHR/SHARE
 *            SYS$SHARE:VAXCRTL.EXE/SHARE
 *
 *
 *  AUTHORS:
 *        UCX Developer
 *
 *  CREATION DATE: May 23, 1989
 *
 *  MODIFICATION HISTORY:
 *
 *       16 May 1996 Joseph J. Vlcek
 *       Make compatible with the Compaq C and Compaq C++ compilers.
 *       Add directions on how to build this example modules.
 *
 */

/*
 *
 *  INCLUDE FILES
 *
 */

#ifdef VMS
# include <descrip.h>        /* VMS descriptor stuff */
# include <errno.h>          /* Unix style error codes for IO routines. */
# include <in.h>             /* internet system Constants and structures. */
# include <inet.h>           /* Network address info. */
# include <iodef.h>          /* I/O FUNCTION CODE DEFS */
# include <lib$routines.h>   /* LIB$ RTL-routine signatures. */
# include <netdb.h>          /* Network database library info. */
# include <signal.h>         /* UNIX style Signal Value Definitions */
# include <socket.h>         /* TCP/IP socket definitions. */
# include <ssdef.h>          /* SS$_<xyz> sys ser return statistics */
# include <starlet.h>        /* Sys ser calls */
# include <stdio.h>          /* UNIX 'Standard I/O' Definitions   */
# include <stdlib.h>         /* General Utilities */
# include <string.h>         /* String handling function definitions */
# include <ucx$inetdef.h>    /* UCX network definitions */
# include <unixio.h>         /* Prototypes for UNIX emulation functions */
#else
# include <errno.h>
# include <sys/types.h>
# include <stdio.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <arpa/inet.h>
# include <sys/uio.h>
# include <time.h>               /* timeval declared here */
#endif

static void
cleanup ( int socket )
{
    int  retval;

    /* Shutdown socket completely */
    retval = shutdown ( socket, 2 );
    if ( retval == -1 )
        perror ("shutdown");

    /* Close socket */
    retval = close (socket);
    if (retval)
        perror ("close");

    return 1;
} /* end cleanup */

/*
 * Functional Description
 *
 *        This example creates a socket of type SOCK_DGRAM (UDP), binds
 *        it, and selects to receive a message on the socket.
 *        Error messages are printed to the screen.
 *
 *        IPC calls used:
 *        bind
 *        close
 *        gethostbyname
 *        recvfrom
 *        select
 *        shutdown
 *        socket
 *
 *
 * Formal Parameters
 *        The server program expects one parameter:
 *        portnumber ... port where it is listening
 *
 *
 * Routine Value
 *
 *        Status
 */

/*--------------------------------------------------------------------*/
int
main ( int argc, char** argv )
{
    struct sockaddr_in  sock1_name;       /* Address struct for socket1 */
    struct sockaddr_in  sock2_name;       /* Address struct for socket2 */
    struct hostent      hostentstruct;    /* Storage for hostent data.  */
    struct hostent*     hostentptr;       /* Pointer to hostent data.   */
    struct timeval      timeout;
    int     rmask;
    int     wmask;
    int     emask;
    int     sock_2;                       /* Socket2  descriptor.       */
    int     buflen;
    int     fromlen;
    char    recvbuf [BUFSIZ];
    int     namelength;
    char    hostname [256];               /* Name of local host.        */
    int     retval;
    int     flag;

    /* Check input parameters */
    if ( argc != 2 ) {
        fprintf ( stderr, "Usage: server portnumber.\n");
        return 1;
    }

    /* Open socket 2: AF_INET, SOCK_DGRAM. */
    if ((sock_2 = socket (AF_INET, SOCK_DGRAM, 0)) == -1) {
        perror( "socket");
        return 1;
    }

    /* Get the local host name. */
    retval = gethostname ( hostname, sizeof hostname );
    if ( retval != 0 ) {
        perror ("gethostname");
        return cleanup ( sock_2 );
    }

    /* Get pointer to network data structure for local host. */
    if ( (hostentptr = gethostbyname (hostname)) == NULL ) {
        perror ("gethostbyname");
        return cleanup (sock_2);
    }

    /* Copy hostent data to safe storage. */
    hostentstruct = *hostentptr;

    /* Fill in the address structure for socket 2 */
    sock2_name.sin_family = hostentstruct.h_addrtype;
    sock2_name.sin_port   = htons(atoi(argv[1]));
    sock2_name.sin_addr   = *((struct in_addr*) hostentstruct.h_addr);

    /* Bind name to socket 2. */
    retval = bind ( sock_2, (struct sockaddr*) & sock2_name, sizeof sock2_name );
    if ( retval != 0 ) {
        perror ("bind");
        return cleanup (sock_2);
    }

    /*
     * Select socket to receive message.
     */
    emask           = 0;
    wmask           = 0;
    rmask           = 1 << sock_2;  /* set read mask */
    timeout.tv_sec  = 30;
    timeout.tv_usec =  0;

    retval = select ( 32, &rmask, &wmask, &emask, &timeout );
    switch ( retval ) {
    case -1:
        perror ("select");
        return cleanup (sock_2);
    case 0:
        fprintf ( stderr,  "Select timed out with status 0.\n" );
        return cleanup ( sock_2 );
    default:
        if ( (rmask & (1 << sock_2)) == 0 ) {
            fprintf ( stderr, "Select not reading on sock_2.\n");
            return cleanup (sock_2);
        }
    } /* switch */

    /* Recvfrom buffer - from sock1 on sock2. */
    buflen  = sizeof recvbuf;
    fromlen = sizeof sock1_name;
    flag    = 0;        /* flag may be MSG_OOB and/or MSG_PEEK */

    retval = recvfrom ( sock_2, recvbuf, buflen, flag, (struct sockaddr*) & sock1_name, &fromlen );
    if ( retval == -1 )
        perror ( "recvfrom" );
    else
        fprintf ( stderr, " %s\n", recvbuf);

    /* Call cleanup to shut down and close socket. */
    return cleanup (sock_2);

} /* end main */





/*====================================================================
 *
 *                          Copyright (C) 1999 by
 *             Digital Equipment Corporation, Maynard, Massachusetts
 *
 * This software is furnished under a license and may be used and  copied
 * only  in  accordance  with  the  terms  of  such  license and with the
 * inclusion of the above copyright notice.  This software or  any  other
 * copies  thereof may not be provided or otherwise made available to any
 * other person.  No title to and ownership of  the  software  is  hereby
 * transferred.
 *
 * The information in this software is subject to change  without  notice
 * and  should  not  be  construed  as  a commitment by Digital Equipment
 * Corporation.
 *
 * DIGITAL assumes no responsibility for the use or  reliability  of  its
 * software on equipment that is not supplied by DIGITAL.
 *
 *
 *
 *  FACILITY:
 *        INSTALL
 *
 *
 *  ABSTRACT:
 *        This is an example of a UDP/IP client using the IPC
 *        socket interface.
 *
 *
 *  ENVIRONMENT:
 *        UCX V1.2 or higher, VMS V5.2 or higher
 *
 *        This example is portable to ULTRIX. The include
 *        files are conditionally defined for both systems, and
 *        "perror" is used for error reporting.
 *
 *  BUILD INSTRUCTIONS:
 *
 *       To link in VAXC/VMS you must have the following
 *       entries in your .opt file:
 *          sys$library:ucx$ipc.olb/lib
 *          sys$share:vaxcrtl.exe/share
 *
 *       For Compaq C or Compaq C++, compile /PREFIX=ALL and link via
 *          $ link UCX$UDP_CLIENT_IPC
 *
 *    To build this example program, use commands of the following form:
 *
 *        using the Compaq C compiler:
 *
 *            $ cc/prefix=all UCX$UDP_CLIENT_IPC.C
 *            $ link UCX$UDP_CLIENT_IPC
 *
 *        using the Compaq C++ compiler:
 *
 *            $ cxx/prefix=all/define=VMS UCX$UDP_CLIENT_IPC.C
 *            $ link UCX$UDP_CLIENT_IPC
 *        using the VAX C compiler:
 *
 *            $  cc /vaxc UCX$UDP_CLIENT_IPC.C
 *            $  link UCX$UDP_CLIENT_IPC, -
 *                    SYS$LIBRARY:UCX$IPC/LIB, -
 *                    SYS$INPUT/OPTIONS
 *            SYS$SHARE:UCX$IPC_SHR/SHARE
 *            SYS$SHARE:VAXCRTL.EXE/SHARE
 *
 *  AUTHORS:
 *        UCX Developer
 *
 *  CREATION DATE: May 23, 1989
 *
 *  MODIFICATION HISTORY:
 *
 *       16 May 1996 Joseph J. Vlcek
 *       Make compatible with the Compaq C and Compaq C++ compilers.
 *       Add directions on how to build this example modules.
 */

/*
 *
 *  INCLUDE FILES
 *
 */

#ifdef VMS
# include <descrip.h>        /* VMS descriptor stuff */
# include <errno.h>          /* Unix style error codes for IO routines. */
# include <in.h>             /* internet system Constants and structures. */
# include <inet.h>           /* Network address info. */
# include <iodef.h>          /* I/O FUNCTION CODE DEFS */
# include <lib$routines.h>   /* LIB$ RTL-routine signatures. */
# include <netdb.h>          /* Network database library info. */
# include <signal.h>         /* UNIX style Signal Value Definitions */
# include <socket.h>         /* TCP/IP socket definitions. */
# include <ssdef.h>          /* SS$_<xyz> sys ser return statistics */
# include <starlet.h>        /* Sys ser calls */
# include <stdio.h>          /* UNIX 'Standard I/O' Definitions   */
# include <stdlib.h>         /* General Utilities */
# include <string.h>         /* String handling function definitions */
# include <ucx$inetdef.h>    /* UCX network definitions */
# include <unixio.h>         /* Prototypes for UNIX emulation functions */
#else
# include <errno.h>
# include <sys/types.h>
# include <stdio.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <arpa/inet.h>
# include <sys/uio.h>
#endif

/*-----------------------------------------------------------*/
static void
cleanup ( int socket )
{
    int  retval;

    /* Shutdown socket completely */
    retval = shutdown ( socket, 2 );
    if ( retval == -1 )
        perror ("shutdown");

    /* Close socket */
    retval = close (socket);
    if (retval)
        perror ("close");

    return 1;
} /* end cleanup */

/*
 * Functional Description
 *
 *        This example creates a socket of type SOCK_DGRAM (UDP),
 *        binds it, and sends a message to the given host and port number.
 *        Error messages are printed to the screen.
 *
 *        IPC calls used:
 *        bind
 *        close
 *        gethostbyname
 *        sendto
 *        shutdown
 *        socket
 *
 * Formal Parameters
 *        The client program expects two parameters:
 *        hostname ... name of remote host
 *        portnumber ... port where remote host(server) is listening
 *
 *
 * Routine Value
 *
 *        Status
 */

/*--------------------------------------------------------------------*/
int
main ( int argc, char **argv )
{
    static  char         sendbuf[] = "Hi there.";
    struct  hostent      hostentstruct;      /* Storage for hostent data.  */
    struct  hostent*     hostentptr;         /* Pointer to hostent data.   */
    struct  sockaddr_in  sock2_name;         /* Address struct for socket2.*/
    int     sock_1;                          /* Socket 1 descriptor.       */
    int     sendlen;
    int     tolen;
    int     namelength;
    char    hostname[256];                   /* Name of local host.        */
    int     flag;
    int     retval;

    /* Check input parameters. */
    if (argc != 3 ) {
        fprintf ( stderr, "Usage: client hostname portnumber.\n");
        return 1;
    }

    /* Open socket 1: AF_INET, SOCK_DGRAM. */
    if ((sock_1 = socket (AF_INET, SOCK_DGRAM, 0)) == -1) {
        perror( "socket");
        return 1;
    }

    /* Get pointer to network data structure for given host. */
    if ( (hostentptr = gethostbyname (argv[1])) == NULL ) {
        perror( "gethostbyname");
        return cleanup (sock_1);
    }

    /* Copy hostent data to safe storage. */
    hostentstruct         = *hostentptr;

    /* Fill in the address structure for socket 2 (to receive message). */
    sock2_name.sin_family = hostentstruct.h_addrtype;
    sock2_name.sin_port   = htons ( atoi (argv[2]) );
    sock2_name.sin_addr   = *((struct in_addr*) hostentstruct.h_addr);

    /* Initialize send block. */
    sendlen = sizeof sendbuf;
    tolen   = sizeof sock2_name;
    flag    = 0;                /* flag may be MSG_OOB */

    /* Send message from socket 1 to socket 2. */
    retval = sendto ( sock_1, sendbuf, sendlen, flag, (struct sockaddr*) & sock2_name, tolen );
    if ( retval == -1 ) {
        perror ( "sendto");
        return cleanup (sock_1);
    }

    /* Call cleanup to shut down and close socket. */
    return cleanup (sock_1);

} /* end main */
