#include <stdio.h>
#include <stdlib.h>

#ifndef __TURBOC__
# define MB      1
# define SIZE    ((MB)*256*1024)
#else
# include <io.h>
# define KB      48
# define SIZE    ((KB)*256)
#endif


static signed short   buff1 [SIZE];
static signed short   buff2 [SIZE];


const char* diff ( unsigned long x1, unsigned long x2, unsigned long mult )     // x1*mult/x2
{
    static char    tmp [128];
    int            expo = -16;
    unsigned long  val;
    unsigned long  integ;
    unsigned long  fract;

    if (x2 == 0)
        return "?";

    while ( x1    &&  x1   < 0x8000000 ) x1   <<= 1, expo++;
    while ( mult  &&  mult < 0x8000000 ) mult <<= 1, expo++;
    while ( x2    &&  x2   < 0x8000000 ) x2   <<= 1, expo--;

    val = (x1 >> 16) * (mult >> 16)
        + ((x1 & 0xFFFF) * (mult >> 16) >> 16)
        + ((x1 >> 16) * (mult & 0xFFFF) >> 16);
    while ( val   &&  val  < 0x8000000 ) val  <<= 1, expo++;
    val = val / ((x2+0x8000) >> 16);
    while ( val   &&  val  < 0x8000000 ) val  <<= 1, expo++;

    integ = val >> expo/2 >> (expo-expo/2);
    fract = val - (integ << expo/2 << (expo - expo/2));
    fract = ((fract >> 10) * 1000 + (1LU << (expo-11))) >> (expo-10);
    sprintf ( tmp, "%lu.%03lu", integ, fract );
    return tmp;
}

void  compare ( FILE* fp1, FILE* fp2 )
{
    unsigned char  char1 [44];
    unsigned char  char2 [44];
    size_t         i;
    unsigned long  error1 = 0;
    unsigned long  errorn = 0;
    size_t         len1;
    size_t         len2;
    size_t         len;
    long           size1 = 0;
    long           size2 = 0;
    long           offs  = 0;

    fread ( char1, 1, 44, fp1 );
    fread ( char2, 1, 44, fp2 );
    for ( i = 0; i < 44; i++ )
        if ( char1[i] != char2[i] )
            printf ( "%2u: %3u %3u\n", i, char1[i], char2[i] );


    while ( 1 ) {
#ifdef __TURBOC__
        len1 = _read ( fileno(fp1), buff1, 2*SIZE ) / 2;
        len2 = _read ( fileno(fp2), buff2, 2*SIZE ) / 2;
#else
        len1 = fread ( buff1, 2, SIZE, fp1 );
        len2 = fread ( buff2, 2, SIZE, fp2 );
#endif
        size1 += len1;
        size2 += len2;
        if ( len1==0  &&  len2==0 )
            break;
        len = len1 < len2  ?  len1  :  len2;

        for ( i = 0; i < len; i++ ) {
            if ( buff1 [i] == buff2 [i] )
                continue;
            if ( abs (buff1 [i] - buff2 [i]) == 1 ) {
                error1++;
                continue;
            }
            printf ( "%8lu %6d %6d\n", offs + i, buff1 [i], buff2 [i] );
            fflush (stdout);
            errorn++;
        }
        offs += len;
    }

    if ( error1 + errorn )
        printf ("\n");

    if ( size1 != size2 )
        printf ("file sizes are different: %lu bytes <-> %lu bytes (%s%%)\n", (long)size1, (long)size2, diff (labs(size1-size2),size1+size2,200) );
    if ( error1 )
        printf ("%lu samples are differing by 1 (%s%%).\n", error1, diff (error1,offs,100) );
    if ( errorn ) {
        printf ("%lu samples are differing by more than 1 (%s ppm).\n", errorn, diff (errorn,offs,1000000) );
        fprintf (stderr, "\a");
    }
    if ( error1 + errorn )
        printf ("\n");

    fflush (stdout);
    return;
}

int  main ( int argc, char** argv )
{
    FILE*  fp1;
    FILE*  fp2;

    switch (argc) {
    case 2:
        fp2 = stdin;
        break;
    case 3:
        if ( (fp2 = fopen ( argv[2], "rb" )) == NULL ) {
            fprintf ( stderr, "Can't open '%s'\n", argv[2] );
            return 2;
        }
        break;
    default:
        fprintf (stderr, "usage: wavcmp file       \tcompares file and <stdin>\n"
                         "         or\n"
                         "       wavcmp file1 file2\tcompares 2 files\n\n" );
        return 1;
    }
    if ( (fp1 = fopen ( argv[1], "rb" )) == NULL ) {
        fprintf ( stderr, "Can't open '%s'\n", argv[1] );
        return 3;
    }

    setvbuf ( fp1, NULL, _IONBF, 0 );
    setvbuf ( fp2, NULL, _IONBF, 0 );

    compare ( fp1, fp2 );

    fclose ( fp1 );
    fclose ( fp2 );

    return 0;
}

/* end of wavcmp.c */
