//-----------------------------------------------------------------------------
//
//	Musepack Demuxer
//
//	Author : Igor Janos
//
//-----------------------------------------------------------------------------
#pragma once

class CMPCReader;


//-----------------------------------------------------------------------------
//
//	CMPCFile class
//
//-----------------------------------------------------------------------------

class CMPCFile
{
public:

	// stream header
	__int64			duration_10mhz;			// total file duration
	int				stream_version;			// 7, 8 are supported
	int				sample_rate;
	int				channels;
	int				audio_block_frames;
	int				block_pwr;				
	int				seek_pwr;
	int64			total_samples;

	// replay gain
	float			gain_title_db;
	float			gain_title_peak_db;
	float			gain_album_db;
	float			gain_album_peak_db;

	// seeking table
	int64			seek_table_position;		// position of seeking table in file
	int64			header_position;
	uint32			*seek_table;
	int64			seek_table_size;

	// internals
	CMPCReader		*reader;				// file reader interface

	// packet parsing
	int				key;					// key for current packet
	uint8			*packet;				// packet payload
	int				packet_max_size;		// maximum allowed packet size
	int				packet_size;			// size of currently loaded payload
	int64			packet_pos;				// absolute position in file
	
public:
	CMPCFile();
	virtual ~CMPCFile();

	// I/O for MPC file
	int Open(CMPCReader *reader);
	int ReadNextPacket();

	// parsing packets
	int ReadStreamHeader();
	int ReadReplaygain();
	int ReadSeekOffset();
	int ReadSeekTable();

};
