//-----------------------------------------------------------------------------
//
//	Musepack Demuxer
//
//	Author : Igor Janos
//
//-----------------------------------------------------------------------------
#include "stdafx.h"

#pragma warning(disable: 4996)

//-----------------------------------------------------------------------------
//
//	Registry Information
//
//-----------------------------------------------------------------------------


const AMOVIESETUP_MEDIATYPE sudPinTypes[] =   
		{ 
			{
				&MEDIATYPE_Audio,
				&MEDIASUBTYPE_MusepackPacket
			},
			{
				&MEDIATYPE_Audio,
				&MEDIASUBTYPE_PCM
			}
		};

const AMOVIESETUP_PIN psudPins[] = 
		{ 
			{ 
				L"Input",
				FALSE,              // bRendered
                FALSE,              // bOutput
                FALSE,              // bZero
                FALSE,              // bMany
                &CLSID_NULL,        // clsConnectsToFilter
                NULL,               // strConnectsToPin
                1,                  // nTypes
                &sudPinTypes[0]		// lpTypes
			}      
             , 
			{ 
				L"Output",          // strName
                FALSE,              // bRendered
                TRUE,               // bOutput
                FALSE,              // bZero
                FALSE,	            // bMany
                &CLSID_NULL,        // clsConnectsToFilter
                NULL,	            // strConnectsToPin
                1,                  // nTypes
                &sudPinTypes[1]		// lpTypes
			} 
		};   


const AMOVIESETUP_FILTER sudMPCDecoder = 
		{ 
			&CLSID_MusepackDecoder,			// clsID
            L"MONOGRAM Musepack Decoder",	// strName
            MERIT_NORMAL,					// dwMerit
            2,								// nPins
            psudPins						// lpPin 
		};                     

CFactoryTemplate g_Templates[]=
		{
			{
				L"MONOGRAM Musepack Decoder",
				&CLSID_MusepackDecoder,
				NULL, //CMPCDemux::CreateInstance, 
				NULL,
				&sudMPCDecoder 
			},
			{
				L"MONOGRAM Musepack Decoder",
				&CLSID_MusepackDecoderPage,
				NULL, //CMPCPropertyPage::CreateInstance
			}
		};

int g_cTemplates = sizeof(g_Templates)/sizeof(g_Templates[0]);


//-----------------------------------------------------------------------------
//
//	DLL Entry Points
//
//-----------------------------------------------------------------------------

STDAPI DllRegisterServer() 
{
	return AMovieDllRegisterServer2(TRUE);
}

STDAPI DllUnregisterServer()
{
	return AMovieDllRegisterServer2(FALSE);
}

