//-----------------------------------------------------------------------------
//
//	Musepack Decoder
//
//	Author : Igor Janos
//
//-----------------------------------------------------------------------------
#pragma once

#define CMD_EXIT		0
#define CMD_STOP		1
#define CMD_RUN			2

//-----------------------------------------------------------------------------
//
//	CMPCReader class
//
//-----------------------------------------------------------------------------
class CMPCReader
{
public:
	BYTE		*buf;		// out internal buffer
	int			size;		// also the size
	int			pos;		// position
	mpc_reader	rd;			// this is the interface for libmpc

public:
	CMPCReader();
	virtual ~CMPCReader();

	// I/O methods
	int Read(void *buf, int size);		// read data
	bool Seek(int offset);				// seek to position
	int Tell();							// tell current position
	int GetSize();						// get total size
	bool CanSeek();						// is seekable ?

	// pass buffers to reader
	void SetData(BYTE *data, int size);
	void AppendSE();
};


//-----------------------------------------------------------------------------
//
//	CMPCDecoder class
//
//-----------------------------------------------------------------------------
class CMPCDecoder : 
	public CTransformFilter,
	public ISpecifyPropertyPages
{
public:

	CCritSec			lock_filter;
	WAVEFORMATEX		wfOut;

	// comes in media type
	CMediaType			mtIn;
	BYTE				*decoder_specific;
	int					decoder_specific_size;

	// musepack internals
	CMPCReader			reader;
	mpc_streaminfo		stream_info;
	mpc_bits_reader		bits;
	mpc_demux			*demux;

public:
	// constructor
	CMPCDecoder(LPUNKNOWN pUnk, HRESULT *phr);
	virtual ~CMPCDecoder();
	static CUnknown * WINAPI CreateInstance(LPUNKNOWN pUnk, HRESULT *phr);

	// override this to publicise our interfaces
	DECLARE_IUNKNOWN;
	STDMETHODIMP NonDelegatingQueryInterface(REFIID riid, void **ppv);

    // ISpecifyPropertyPages interface
    STDMETHODIMP GetPages(CAUUID *pPages);

	// Pure virtual methods
	virtual HRESULT CheckInputType(const CMediaType *mtIn);
	virtual HRESULT CheckTransform(const CMediaType *mtIn, const CMediaType *mtOut);
	virtual HRESULT DecideBufferSize(IMemAllocator *pAlloc, ALLOCATOR_PROPERTIES *pProp);
	virtual HRESULT GetMediaType(int iPosition, CMediaType *pmt);
	virtual HRESULT SetMediaType(PIN_DIRECTION direction, const CMediaType *pmt);
	virtual HRESULT BreakConnect(PIN_DIRECTION dir);

	// activate/deactivate decoder
	virtual HRESULT StartStreaming();
	virtual HRESULT StopStreaming();

	// decoding input packets
	virtual HRESULT Receive(IMediaSample *pSample);
	virtual HRESULT GetDeliveryBuffer(IMediaSample **sample);

	// Initialization from decoder_specific
	int OpenDemux(mpc_demux **dmx, mpc_streaminfo *si);

};












