//-----------------------------------------------------------------------------
//
//	Musepack Demuxer
//
//	Author : Igor Janos
//
//-----------------------------------------------------------------------------
#include "stdafx.h"

#pragma warning(disable: 4996)

//-----------------------------------------------------------------------------
//
//	Registry Information
//
//-----------------------------------------------------------------------------


const AMOVIESETUP_MEDIATYPE sudPinTypes[] =   
		{ 
			{
				&MEDIATYPE_Stream,
				&MEDIASUBTYPE_None
			},
			{
				&MEDIATYPE_Stream,
				&MEDIASUBTYPE_MusepackStream
			},
			{
				&MEDIATYPE_Audio,
				&MEDIASUBTYPE_MusepackPacket
			}
		};

const AMOVIESETUP_PIN psudPins[] = 
		{ 
			{ 
				L"Input",
				FALSE,              // bRendered
                FALSE,              // bOutput
                FALSE,              // bZero
                FALSE,              // bMany
                &CLSID_NULL,        // clsConnectsToFilter
                NULL,               // strConnectsToPin
                2,                  // nTypes
                &sudPinTypes[0]		// lpTypes
			}      
             , 
			{ 
				L"Output",          // strName
                FALSE,              // bRendered
                TRUE,               // bOutput
                FALSE,              // bZero
                TRUE,	            // bMany
                &CLSID_NULL,        // clsConnectsToFilter
                NULL,	            // strConnectsToPin
                1,                  // nTypes
                &sudPinTypes[2]		// lpTypes
			} 
		};   


const AMOVIESETUP_FILTER sudMPCDemuxer = 
		{ 
			&CLSID_MusepackDemuxer,			// clsID
            L"MONOGRAM Musepack Splitter",	// strName
            MERIT_NORMAL,					// dwMerit
            2,								// nPins
            psudPins						// lpPin 
		};                     

CFactoryTemplate g_Templates[]=
		{
			{
				L"MONOGRAM Musepack Splitter",
				&CLSID_MusepackDemuxer,
				CMPCDemux::CreateInstance, 
				NULL,
				&sudMPCDemuxer 
			},
			{
				L"MONOGRAM Musepack Splitter",
				&CLSID_MusepackDemuxPage,
				CMPCPropertyPage::CreateInstance
			}
		};

int g_cTemplates = sizeof(g_Templates)/sizeof(g_Templates[0]);


//-----------------------------------------------------------------------------
//
//	DLL Entry Points
//
//-----------------------------------------------------------------------------


HRESULT Register_MPC_Types()
{
	CRegKey	r;
	if (r.Create(HKEY_CLASSES_ROOT, _T("Media Type\\{E436EB83-524F-11CE-9F53-0020AF0BA770}\\{229F9AD7-2F4D-4b45-B858-A3F434E7179A}")) != ERROR_SUCCESS) {
		return E_FAIL;
	}

	// write the string
	r.SetStringValue(_T("0"), _T("0,4,,4D50434B"));											// MPCK
	r.SetStringValue(_T("Source Filter"), _T("{E436EBB5-524F-11CE-9F53-0020AF0BA770}"));	// file source async
	r.Close();

	return NOERROR;
}

HRESULT Unregister_MPC_Types()
{
	CRegKey	r;
	if (r.Create(HKEY_CLASSES_ROOT, _T("Media Type\\{E436EB83-524F-11CE-9F53-0020AF0BA770}")) == ERROR_SUCCESS) {
		r.DeleteSubKey(_T("{229F9AD7-2F4D-4b45-B858-A3F434E7179A}"));
		r.Close();
	}

	return NOERROR;
}

STDAPI DllRegisterServer() 
{
	HRESULT hr = Register_MPC_Types();
	if (FAILED(hr)) return hr;

	return AMovieDllRegisterServer2(TRUE);
}

STDAPI DllUnregisterServer()
{
	Unregister_MPC_Types();
	return AMovieDllRegisterServer2(FALSE);
}

// The one and only application object
CWinApp theApp;
using namespace std;


extern "C" BOOL WINAPI _DllMainCRTStartup(HINSTANCE, ULONG, LPVOID);
extern "C" BOOL WINAPI DllEntryPoint(HINSTANCE, ULONG, LPVOID);

BOOL APIENTRY FilterDllMain(HANDLE hModule, DWORD  dwReason, LPVOID lpReserved)
{
	_DllMainCRTStartup((HINSTANCE)hModule, dwReason, lpReserved);
	return DllEntryPoint((HINSTANCE)(hModule), dwReason, lpReserved);
}
