//-----------------------------------------------------------------------------
//
//	Musepack Decoder
//
//	Author : Igor Janos
//
//-----------------------------------------------------------------------------
#include "stdafx.h"

#include "..\resource.h"


#define ITEM(x)					GetDlgItem(m_Dlg, x)

void MakeNiceTime(int time_ms, CString &v)
{
	int		ms = time_ms%1000;	
	time_ms -= ms;
	time_ms /= 1000;

	int		h, m, s;
	h = time_ms / 3600;		time_ms -= h*3600;
	m = time_ms / 60;		time_ms -= m*60;
	s = time_ms;

	v.Format(_T("%.2d:%.2d:%.2d,%.3d"), h, m, s, ms);
}

void MakeNiceSpeed(__int64 bps, CString &v)
{
	int r=0;
	__int64	c=bps;
	LPCTSTR		rady[] = {
		_T("bps"),
		_T("kbps"),
		_T("mbps"),
		_T("gbps"),
		_T("tbps")
	};

	// spocitame rad
	while (c > 1000 && r<4) {
		r++;
		c = c / 1000;
	}

	c=bps;
	for (int i=1; i<r; i++) { c = c/1000; }
	double d=c / 1000.0;

	v.Format(_T("%5.3f %s"), (float)d, rady[r]);
}


//-----------------------------------------------------------------------------
//
//	CMPCPropertyPage class
//
//-----------------------------------------------------------------------------

CUnknown *CMPCPropertyPage::CreateInstance(LPUNKNOWN lpUnk, HRESULT *phr)
{
	return new CMPCPropertyPage(lpUnk, phr);
}

CMPCPropertyPage::CMPCPropertyPage(LPUNKNOWN lpUnk, HRESULT *phr) :
	CBasePropertyPage(NAME("MPC Property Page"), lpUnk, IDD_PAGE_DECODER, IDS_PAGE_DECODER),
	decoder(NULL)
{
}

CMPCPropertyPage::~CMPCPropertyPage()
{
}

HRESULT CMPCPropertyPage::OnConnect(IUnknown *pUnknown)
{
	// hold a pointer
	ASSERT(!decoder);
	HRESULT hr = pUnknown->QueryInterface(IID_IMusepackDecoder, (void**)&decoder);
	if (FAILED(hr)) return hr;

	// okej
	return NOERROR;
}

HRESULT CMPCPropertyPage::OnDisconnect()
{
	if (decoder) { decoder->Release(); decoder = NULL; }
	return NOERROR;
}

HRESULT CMPCPropertyPage::OnActivate()
{
	SetTimer(m_Dlg, 0, 1000, NULL);
	UpdateVisual();
	return NOERROR;
}

HRESULT CMPCPropertyPage::OnDeactivate()
{
	KillTimer(m_Dlg, 0);
	return NOERROR;
}

void CMPCPropertyPage::UpdateVisual()
{
	// update visuals
	CString	tmp;
	HRESULT hr;
	int		val;
	float	fval;

	if (!decoder) return ;

	// stream version
	if (SUCCEEDED(decoder->GetStreamVersion(&val))) { tmp.Format(_T("SV%d"), val); } else { tmp = _T("Unknown"); }
	Static_SetText(ITEM(IDC_STATIC_VERSION), tmp);

	// samplerate
	if (SUCCEEDED(decoder->GetSamplerate(&val))) { tmp.Format(_T("%d Hz"), val); } else { tmp = _T("Unknown"); }
	Static_SetText(ITEM(IDC_STATIC_SAMPLERATE), tmp);
	
	// channels
	if (SUCCEEDED(decoder->GetChannels(&val))) {
		switch (val) {
		case 1:	tmp = _T("Mono (1)"); break;
		case 2: tmp = _T("Stereo (2)"); break;
		default: tmp.Format(_T("Other (%d)"), val); break;
		}
	} else {
		tmp = _T("Unknown");
	}
	Static_SetText(ITEM(IDC_STATIC_CHANNELS), tmp);

	// so far only one output type
	Static_SetText(ITEM(IDC_STATIC_OUTPUT), _T("16-bit Integer"));

	// replay gain
	if (SUCCEEDED(decoder->GetReplaygain(&fval))) {
		tmp.Format(_T("%4.2f dB"), fval);
	} else {
		tmp = _T("0.00 dB");
	}
	Static_SetText(ITEM(IDC_STATIC_REPLAYGAIN), tmp);

	// decoded frames
	__int64 frames;
	decoder->GetFramesDecoded(&frames);
	tmp.Format(_T("%I64d"), frames);
	Static_SetText(ITEM(IDC_STATIC_FRAMES), tmp);

	// bitrate
	decoder->GetBitrate(&fval);
	MakeNiceSpeed((__int64)fval, tmp);
	Static_SetText(ITEM(IDC_STATIC_BITRATE), tmp);
}

INT_PTR CMPCPropertyPage::OnReceiveMessage(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
	case WM_TIMER: UpdateVisual(); break;
	}
	return __super::OnReceiveMessage(hwnd, uMsg, wParam, lParam);
}

