/*
 * Musepack audio compression
 * Copyright (C) 1999-2004 Buschmann/Klemm/Piecha/Wolf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


// fast but maybe more inaccurate, use if you need speed
#if defined(__GNUC__) && !defined(__APPLE__)
#  define SIN(x)      sinf ((float)(x))
#  define COS(x)      cosf ((float)(x))
#  define ATAN2(x,y)  atan2f ((float)(x), (float)(y))
#  define SQRT(x)     sqrtf ((float)(x))
#  define LOG(x)      logf ((float)(x))
#  define LOG10(x)    log10f ((float)(x))
#  define POW(x,y)    expf (logf(x) * (y))
#  define POW10(x)    expf (M_LN10 * (x))
#  define FLOOR(x)    floorf ((float)(x))
#  define IFLOOR(x)   (int) floorf ((float)(x))
#  define FABS(x)     fabsf ((float)(x))
#else
# define SIN(x)      (float) sin (x)
# define COS(x)      (float) cos (x)
# define ATAN2(x,y)  (float) atan2 (x, y)
# define SQRT(x)     (float) sqrt (x)
# define LOG(x)      (float) log (x)
# define LOG10(x)    (float) log10 (x)
# define POW(x,y)    (float) pow (x,y)
# define POW10(x)    (float) pow (10., (x))
# define FLOOR(x)    (float) floor (x)
# define IFLOOR(x)   (int)   floor (x)
# define FABS(x)     (float) fabs (x)
#endif

#define SQRTF(x)      SQRT (x)
#ifdef FAST_MATH
# define TABSTEP      64
# define COSF(x)      my_cos ((float)(x))
# define ATAN2F(x,y)  my_atan2 ((float)(x), (float)(y))
# define IFLOORF(x)   my_ifloor ((float)(x))
#else
# undef  TABSTEP
# define COSF(x)      COS (x)
# define ATAN2F(x,y)  ATAN2 (x,y)
# define IFLOORF(x)   IFLOOR (x)
#endif

#if 1
# define ROUND32(x)   ( floattmp = (x) + (int)0x00FD8000L, *(int*)(&floattmp) - (int)0x4B7D8000L )
#else
# define ROUND32(x)   ( (int) floor ((x) + 0.5) )
#endif

#ifdef FAST_MATH

static __inline float
my_atan2 ( float x, float y )
{
    float  t;
    int    i;
    float  ret;
    float  floattmp;

    if ( (*(int*)&x & 0x7FFFFFFF) < (*(int*)&y & 0x7FFFFFFF) ) {
        i   = ROUND32 (t = TABSTEP * (x / y));
        ret = tabatan2 [1*TABSTEP+i][0] + tabatan2 [1*TABSTEP+i][1] * (t-i);
        if ( *(int*)&y < 0 )
           ret = (float)(ret - M_PI);
    }
    else if ( *(int*)&x < 0) {
        i   = ROUND32 (t = TABSTEP * (y / x));
        ret = - M_PI/2 - tabatan2 [1*TABSTEP+i][0] + tabatan2 [1*TABSTEP+i][1] * (i-t);
    }
    else if ( *(int*)&x > 0) {
        i   = ROUND32 (t = TABSTEP * (y / x));
        ret = + M_PI/2 - tabatan2 [1*TABSTEP+i][0] + tabatan2 [1*TABSTEP+i][1] * (i-t);
    }
    else {
        ret = 0.;
    }
    return ret;
}


static __inline float
my_cos ( float x )
{
    float  t;
    int    i;
    float  ret;
    float  floattmp;

    i   = ROUND32 (t = TABSTEP * x);
    ret = tabcos [13*TABSTEP+i][0] + tabcos [13*TABSTEP+i][1] * (t-i);
    return ret;
}


static __inline int
my_ifloor ( float x )
{
    x = x + (0x0C00000L + 0.500000001);
    return *(int*)&x - 1262485505;
}


static __inline float
my_sqrt ( float x )
{
    float  ret;
    int    i;
    int    ex = *(int*)&x >> 23;                                // get the exponent
    float  floattmp;

    *(int*)&x = (*(int*)&x & 0x7FFFFF) | 0x42800000;            // delete the exponent
    i    = ROUND32 (x);                                         // Integer-part of the mantissa  (round ????????????)
    ret  = tabsqrt_m [i-TABSTEP][0] + tabsqrt_m [i-TABSTEP][1] * (x-i); // calculate value
    ret *= tabsqrt_ex [ex];
    return ret;
}

#endif
