/*
 * Musepack audio compression
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// psy_tab.h
#define PART_LONG          57                   // number of partitions for long
#define PART_SHORT     (PART_LONG / 3)          // number of partitions for short
#define MAX_SPL            20                   // maximum assumed Sound Pressure Level

// psy.c
#define SHORTFFT_OFFSET   168                   // fft-offset for short FFT's
#define PREFAC_LONG        10                   // preecho-factor for long partitions


#define MAX_CVD_LINE      300                   // maximum FFT-Index for CVD
#define CVD_UNPRED          0.040f              // unpredictability (cw) for CVD-detected bins, e33 (04)
#define MIN_ANALYZED_IDX   12                   // maximum base-frequency = 44100/MIN_ANALYZED_IDX ^^^^^^
#define MED_ANALYZED_IDX   50                   // maximum base-frequency = 44100/MED_ANALYZED_IDX ^^^^^^
#define MAX_ANALYZED_IDX  900                   // minimum base-frequency = 44100/MAX_ANALYZED_IDX  (816 for Amnesia)


#define MAX_NS_ORDER        6                   // maximum order of the Adaptive Noise Shaping Filter (IIR)
#define MAX_ANS_BANDS      16
#define MAX_ANS_LINES    (32 * MAX_ANS_BANDS)   // maximum number of noiseshaped FFT-lines
///////// 16 * MAX_ANS_BANDS not sufficient? //////////////////
#define MS2SPAT1             0.5f
#define MS2SPAT2             0.25f
#define MS2SPAT3             0.125f
#define MS2SPAT4             0.0625f

// common ?
#ifndef M_PI
# define M_PI            3.1415926535897932384626433832795029     // 4*atan(1)
# define M_PIl           3.1415926535897932384626433832795029L
# define M_LN2           0.6931471805599453094172321214581766     // ln(2)
# define M_LN2l          0.6931471805599453094172321214581766L
# define M_LN10          2.3025850929940456840179914546843642     // ln 10 */
# define M_LN10l         2.3025850929940456840179914546843642L
#endif

// mppenc.h
#define CENTER            448                   // offset for centering current data in Main-array
#define BLOCK            1152                   // blocksize
#define ANABUFFER    (BLOCK + CENTER)           // size of PCM-data array for analysis


#define KBD1	2.
#define KBD2	-1.

typedef struct {
    float  L [32];
	float  R [32];
	float  M [32];
	float  S [32];
} SMRTyp;

typedef struct {
	float  L [36];
	float  R [36];
} SubbandFloatTyp;

typedef struct {
	float  L [ANABUFFER];
	float  R [ANABUFFER];
	float  M [ANABUFFER];
	float  S [ANABUFFER];
} PCMDataTyp;

typedef struct {
	int           Max_Band;                    // maximum bandwidth
	float         SampleFreq;
	float         Bandwidth;

	/* further switches for the psymodel */
	unsigned int  CVD_used;         // global flag for ClearVoiceDetection
	float         varLtq;           // variable threshold in quiet
	unsigned int  tmpMask_used;     // global flag for temporal masking
	float         ShortThr;         // Factor to calculate the masking threshold with transients
	float         minSMR;           // minimum SMR for all subbands

	unsigned int  MS_Channelmode;

	float         a          [PART_LONG];
	float         b          [PART_LONG];
	float         c          [PART_LONG];
	float         d          [PART_LONG];           // Integrations for tmpMask
	float         T_L        [PART_LONG];
	float         T_R        [PART_LONG];           // time-constants for tmpMask
	float         pre_erg_L[2][PART_SHORT];
	float         pre_erg_R[2][PART_SHORT];          // Preecho-control short
	float         PreThr_L   [PART_LONG];
	float         PreThr_R   [PART_LONG];           // for Pre-Echo-control L/R
	float         tmp_Mask_L [PART_LONG];
	float         tmp_Mask_R [PART_LONG];           // for Post-Masking L/R
	int           Vocal_L    [MAX_CVD_LINE + 4];
	int           Vocal_R    [MAX_CVD_LINE + 4];    // FFT-Line belongs to harmonic?

	/* V A R I A B L E S */
	float  MinVal   [PART_LONG];               // contains minimum tonality soffsets
	float  Loudness [PART_LONG];               // weighting factors for loudness calculation
	float  SPRD     [PART_LONG] [PART_LONG];   // tabulated spreading function
	float  O_MAX;
	float  O_MIN;
	float  FAC1;
	float  FAC2;                               // constants for offset calculation
	float  partLtq  [PART_LONG];               // threshold in quiet (partitions)
	float  invLtq   [PART_LONG];               // inverse threshold in quiet (partitions, long)
	float  fftLtq   [512];                     // threshold in quiet (FFT)
	float  Ltq_offset;                         // Offset for threshold in quiet
	float  Ltq_max;                            // maximum level for threshold in quiet
	float  TMN;
	float  NMT;
	float  TransDetect;
	unsigned int    EarModelFlag;
	int    MinValChoice;

	// ans.h
	unsigned int  NS_Order;                         // Maximum order for ANS
	unsigned int  NS_Order_L [32];
	unsigned int  NS_Order_R [32];                  // frame-wise order of the Noiseshaping (0: off, 1...5: on)
	float         FIR_L      [32] [MAX_NS_ORDER];
	float         FIR_R      [32] [MAX_NS_ORDER];   // contains FIR-Filter for NoiseShaping
	float         ANSspec_L  [MAX_ANS_LINES];
	float         ANSspec_R  [MAX_ANS_LINES];       // L/R-masking thresholds for ANS
	float         ANSspec_M  [MAX_ANS_LINES];
	float         ANSspec_S  [MAX_ANS_LINES];       // M/S-masking thresholds for ANS
	float         SNR_comp_L [32];
	float         SNR_comp_R [32];             // SNR-compensation after SCF-combination and ANS-gain

	// FIXME : remove this :
	int            SCF_Index_L [32] [3];
	int            SCF_Index_R [32] [3];              // Scalefactor-index for Bitstream

} PsyModel;


// w_low for long               0    1    2    3    4    5    6    7    8    9   10   11   12   13   14   15   16   17   18   19   20   21   22   23   24   25   26   27   28   29   30   31   32   33   34   35   36   37   38   39   40   41   42   43   44   45   46   47   48   49   50   51   52   53   54   55   56
const int   wl [PART_LONG] = {  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  13,  15,  17,  19,  21,  23,  25,  27,  29,  31,  33,  35,  38,  41,  44,  47,  50,  54,  58,  62,  67,  72,  78,  84,  91,  98, 106, 115, 124, 134, 145, 157, 170, 184, 199, 216, 234, 254, 276, 301, 329, 360, 396, 437, 485 };
const int   wh [PART_LONG] = {  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  12,  14,  16,  18,  20,  22,  24,  26,  28,  30,  32,  34,  37,  40,  43,  46,  49,  53,  57,  61,  66,  71,  77,  83,  90,  97, 105, 114, 123, 133, 144, 156, 169, 183, 198, 215, 233, 253, 275, 300, 328, 359, 395, 436, 484, 511 };
// Width:                       1    1    1    1    1    1    1    1    1    1    1    2    2    2    2    2    2    2    2    2    2    2    2    3    3    3    3    3    4    4    4    5    5    6    6    7    7    8    9    9   10   11   12   13   14   15   17   18   20   22   25   28   31   36   41   48   27

// inverse partition-width for long
const float iw [PART_LONG] = { 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f, 1.f/2, 1.f/2, 1.f/2, 1.f/2, 1.f/2, 1.f/2, 1.f/2, 1.f/2, 1.f/2, 1.f/2, 1.f/2, 1.f/2, 1.f/3, 1.f/3, 1.f/3, 1.f/3, 1.f/3, 1.f/4, 1.f/4, 1.f/4, 1.f/5, 1.f/5, 1.f/6, 1.f/6, 1.f/7, 1.f/7, 1.f/8, 1.f/9, 1.f/9, 1.f/10, 1.f/11, 1.f/12, 1.f/13, 1.f/14, 1.f/15, 1.f/17, 1.f/18, 1.f/20, 1.f/22, 1.f/25, 1.f/28, 1.f/31, 1.f/36, 1.f/41, 1.f/48, 1.f/27 };

// w_low for short                    0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15  16  17   18
const int   wl_short [PART_SHORT] = { 0,  1,  2,  3,  4,  5,  6,  8, 10, 12, 15, 18, 23, 29, 36, 46, 59, 75,  99 };
const int   wh_short [PART_SHORT] = { 0,  1,  2,  3,  5,  6,  7,  9, 12, 14, 18, 23, 29, 36, 46, 58, 75, 99, 127 };

// inverse partition-width for short
const float iw_short [PART_SHORT] = { 1.f, 1.f, 1.f, 1.f, 1.f/2, 1.f/2, 1.f/2, 1.f/2, 1.f/3, 1.f/3, 1.f/4, 1.f/6, 1.f/7, 1.f/8, 1.f/11, 1.f/13, 1.f/17, 1.f/25, 1.f/29 };
