/*
 * Musepack audio compression
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// psy_tab.h
#define PART_LONG          57                   // number of partitions for long
#define PART_SHORT     (PART_LONG / 3)          // number of partitions for short
#define MAX_SPL            20                   // maximum assumed Sound Pressure Level

// psy.c
#define SHORTFFT_OFFSET   168                   // fft-offset for short FFT's
#define PREFAC_LONG        10                   // preecho-factor for long partitions


#define MAX_CVD_LINE      300                   // maximum FFT-Index for CVD
#define CVD_UNPRED          0.040f              // unpredictability (cw) for CVD-detected bins, e33 (04)
#define MIN_ANALYZED_IDX   12                   // maximum base-frequency = 44100/MIN_ANALYZED_IDX ^^^^^^
#define MED_ANALYZED_IDX   50                   // maximum base-frequency = 44100/MED_ANALYZED_IDX ^^^^^^
#define MAX_ANALYZED_IDX  900                   // minimum base-frequency = 44100/MAX_ANALYZED_IDX  (816 for Amnesia)


#define MAX_NS_ORDER        6                   // maximum order of the Adaptive Noise Shaping Filter (IIR)
#define MAX_ANS_BANDS      16
#define MAX_ANS_LINES    (32 * MAX_ANS_BANDS)   // maximum number of noiseshaped FFT-lines
///////// 16 * MAX_ANS_BANDS not sufficient? //////////////////
#define MS2SPAT1             0.5f
#define MS2SPAT2             0.25f
#define MS2SPAT3             0.125f
#define MS2SPAT4             0.0625f

typedef struct {
    float  L [32];
	float  R [32];
	float  M [32];
	float  S [32];
} SMRTyp;

typedef struct {
	int           Max_Band;                    // maximum bandwidth
	float         SampleFreq;
	float         Bandwidth;

	/* further switches for the psymodel */
	unsigned int  CVD_used;         // global flag for ClearVoiceDetection
	float         varLtq;           // variable threshold in quiet
	unsigned int  tmpMask_used;     // global flag for temporal masking
	float         ShortThr;         // Factor to calculate the masking threshold with transients
	float         minSMR;           // minimum SMR for all subbands

	unsigned int  MS_Channelmode;

	float         a          [PART_LONG];
	float         b          [PART_LONG];
	float         c          [PART_LONG];
	float         d          [PART_LONG];           // Integrations for tmpMask
	float         T_L        [PART_LONG];
	float         T_R        [PART_LONG];           // time-constants for tmpMask
	float         pre_erg_L[2][PART_SHORT];
	float         pre_erg_R[2][PART_SHORT];          // Preecho-control short
	float         PreThr_L   [PART_LONG];
	float         PreThr_R   [PART_LONG];           // for Pre-Echo-control L/R
	float         tmp_Mask_L [PART_LONG];
	float         tmp_Mask_R [PART_LONG];           // for Post-Masking L/R
	int           Vocal_L    [MAX_CVD_LINE + 4];
	int           Vocal_R    [MAX_CVD_LINE + 4];    // FFT-Line belongs to harmonic?

	/* V A R I A B L E S */
	float  MinVal   [PART_LONG];               // contains minimum tonality soffsets
	float  Loudness [PART_LONG];               // weighting factors for loudness calculation
	float  SPRD     [PART_LONG] [PART_LONG];   // tabulated spreading function
	float  O_MAX;
	float  O_MIN;
	float  FAC1;
	float  FAC2;                               // constants for offset calculation
	float  partLtq  [PART_LONG];               // threshold in quiet (partitions)
	float  invLtq   [PART_LONG];               // inverse threshold in quiet (partitions, long)
	float  fftLtq   [512];                     // threshold in quiet (FFT)
	float  Ltq_offset;                         // Offset for threshold in quiet
	float  Ltq_max;                            // maximum level for threshold in quiet
	float        TMN;                        // Offset for purely sinusoid components
	float        NMT;                        // Offset for purely noisy components
	float        TransDetect;                // minimum slewrate for transient detection
	unsigned int    EarModelFlag;
	int    MinValChoice;

	// ans.h
	unsigned int  NS_Order;                         // Maximum order for ANS
	unsigned int  NS_Order_L [32];
	unsigned int  NS_Order_R [32];                  // frame-wise order of the Noiseshaping (0: off, 1...5: on)
	float         FIR_L      [32] [MAX_NS_ORDER];
	float         FIR_R      [32] [MAX_NS_ORDER];   // contains FIR-Filter for NoiseShaping
	float         ANSspec_L  [MAX_ANS_LINES];
	float         ANSspec_R  [MAX_ANS_LINES];       // L/R-masking thresholds for ANS
	float         ANSspec_M  [MAX_ANS_LINES];
	float         ANSspec_S  [MAX_ANS_LINES];       // M/S-masking thresholds for ANS
	float         SNR_comp_L [32];
	float         SNR_comp_R [32];             // SNR-compensation after SCF-combination and ANS-gain

	float KBD1; // = 2.
	float KBD2; // = -1.

	// FIXME : remove this :
	int            SCF_Index_L [32] [3];
	int            SCF_Index_R [32] [3];              // Scalefactor-index for Bitstream

} PsyModel;

