/*
 * Musepack audio compression
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma once

#include "config_types.h"

// FIXME : define this somewhere else
#ifndef NULL
#define NULL 0
#endif

// FIXME : remove MPPENC_VERSION from here
#ifndef MPPENC_VERSION
# define MPPENC_VERSION   "1.15w-6"
#endif

// bitstream.c
#define BUFFER_ALMOST_FULL  8192
#define BUFFER_FULL         (BUFFER_ALMOST_FULL + 4352)         // 34490 bit/frame  1320.3 kbps

#ifndef ENDIAN
#define HAVE_LITTLE_ENDIAN  1234
#define HAVE_BIG_ENDIAN     4321

#define ENDIAN              HAVE_LITTLE_ENDIAN
#endif

// bitstream.c
typedef struct {
	mpc_uint32_t*	ptr;
	unsigned int	bit;
} BitstreamPos;

typedef struct {
	unsigned int  L [36];
	unsigned int  R [36];
} SubbandQuantTyp;

// TODO : enc/dec common struct
// just the same struct as below, dup ?
typedef struct {
	mpc_uint16_t	Length;  // >=  4 bit
	mpc_uint16_t	Code;  // >= 14 bit
} HuffSrc_t ;

typedef struct {
	mpc_uint16_t	Length;      // >=  4 bit
	mpc_uint16_t	Code;        // >= 14 bit
} Huffman_t ;

// TODO : match with mpc_decoder_t
// FIXME : add init code
typedef struct {
	mpc_uint32_t	Buffer [BUFFER_FULL];    // Buffer for bitstream-file
	mpc_uint32_t	dword; //         =  0;      // 32-bit-Word for Bitstream-I/O
	mpc_int32_t		filled; //        = 32;      // Position in the the 32-bit-word that's currently about to be filled
	mpc_uint32_t	Zaehler; //       =  0;      // Position pointer for the processed bitstream-word (32 bit)
	mpc_uint64_t	BufferedBits; //  =  0;      // Counter for the number of written bits in the bitstream

	unsigned int  MS_Channelmode;
	unsigned int  Overflows; //       = 0;      // number of internal (filterbank) clippings
} mpc_encoder_t;

