/*
 * Musepack audio compression
 * Copyright (C) 1999-2004 Buschmann/Klemm/Piecha/Wolf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MPPENC_MPPENC_H
#define MPPENC_MPPENC_H

#ifdef _WIN32
# define CVD_FASTLOG
#endif

#include "libmpcenc.h"
#include "libmpcpsy.h"
#include "datatypes.h"
#include "minimax.h"

#include "mppdec.h"

#define WIN32_MESSAGES      1                   // support Windows-Messaging to Frontend

// analyse_filter.c
#define X_MEM            1152

// quant.h
#define SCFfac              0.832980664785f     // = SCF[n-1]/SCF[n]

// wave_in.h

typedef struct {
    FILE*         fp;                   // File pointer to read data
    Ulong         PCMOffset;            // File offset of PCM data
    long double   SampleFreq;           // Sample frequency in Hz
    Uint          BitsPerSample;        // used bits per sample, 8*BytesPerSample-7 <= BitsPerSample <= BytesPerSample
    Uint          BytesPerSample;       // allocated bytes per sample
    Uint          Channels;             // Number of channels, 1...8
    UintMax_t     PCMBytes;             // PCM Samples (in 8 bit units)
    UintMax_t     PCMSamples;           // PCM Samples per Channel
    Bool_t        raw;                  // raw: headerless format
} wave_t;

// FIXME : put in lib header

void   Init_FFT      ( PsyModel* );

// FIXME : put in lib header
void   Init_Psychoakustik       ( PsyModel* );
SMRTyp Psychoakustisches_Modell ( PsyModel *, const int, const PCMDataTyp*, int* TransientL, int* TransientR );
void   TransientenCalc          ( int* Transient, const int* TransientL, const int* TransientR );
void   RaiseSMR                 ( PsyModel*, const int, SMRTyp* );
void   MS_LR_Entscheidung       ( const int, unsigned char* MS, SMRTyp*, SubbandFloatTyp* );
void   Init_Psychoakustiktabellen ( PsyModel* );

void   NS_Analyse (PsyModel*, const int, const unsigned char* MS, const SMRTyp, const int* Transient );

void   Analyse_Filter(const PCMDataTyp*, SubbandFloatTyp*, const int);
void   Analyse_Init ( float Left, float Right, SubbandFloatTyp* out, const int MaxBand );

void SetQualityParams (PsyModel *, float );
int TestProfileParams ( PsyModel* );

extern const float  Butfly    [7];              // Antialiasing to calculate the subband powers
extern const float  InvButfly [7];              // Antialiasing to calculate the masking thresholds
extern const float  iw        [PART_LONG];      // inverse partition-width for long
extern const float  iw_short  [PART_SHORT];     // inverse partition-width for short
extern const int    wl        [PART_LONG];      // w_low  for long
extern const int    wl_short  [PART_SHORT];     // w_low  for short
extern const int    wh        [PART_LONG];      // w_high for long
extern const int    wh_short  [PART_SHORT];     // w_high for short


// quant.c
extern float __invSCF [128 + 6];        // tabulated scalefactors (inverted)
#define invSCF  (__invSCF + 6)

float  ISNR_Schaetzer                  ( const float* samples, const float comp, const int res);
float  ISNR_Schaetzer_Trans            ( const float* samples, const float comp, const int res);
void   QuantizeSubband                 ( unsigned int* qu_output, const float* input, const int res, float* errors, const int maxNsOrder );
void   QuantizeSubbandWithNoiseShaping ( unsigned int* qu_output, const float* input, const int res, float* errors, const float* FIR );

void   NoiseInjectionComp ( void );


// FIXME : no more globals
// encode_sv7.c
extern unsigned char  MS_Flag     [32];                  // subband-wise mid/side flag
extern int            Res_L       [32];
extern int            Res_R       [32];                  // resolution steps of the subbands
extern int            SCF_Index_L [32] [3];
extern int            SCF_Index_R [32] [3];              // Scalefactor-index for Bitstream

// FIXME : put in lib header
void         Init_SV8             ( mpc_encoder_t* );
void WriteHeader_SV8 ( mpc_encoder_t*e, const unsigned int  MaxBand,
					   const unsigned int  MS_on,
					   const unsigned int  SamplesCount,
					   const unsigned int  StreamVersion,
					   const unsigned int  PNS_on,
					   const unsigned int  SampleFreq,
					   const unsigned int  ChannelCount);
void writeBlock ( mpc_encoder_t * e, const char * key, const mpc_bool_t addCRC);
void writeMagic(mpc_encoder_t * e);
void         WriteBitstream_SV7   ( mpc_encoder_t*, const int, const SubbandQuantTyp* );




void    Huffman_SV7_Encoder ( void );


// keyboard.c
int    WaitKey      ( void );
int    CheckKeyKeep ( void );
int    CheckKey     ( void );


// regress.c
void    Regression       ( float* const _r, float* const _b, const float* p, const float* q );


// tags.c
void    Init_Tags        ( void );
int     FinalizeTags     ( FILE* fp, unsigned int Version );
int     addtag           ( const char* key, size_t keylen, const char* value, size_t valuelen, int converttoutf8, int flags );
int     gettag           ( const char* key, char* dst, size_t len );
int     CopyTags         ( const char* filename );


// wave_in.c
int     Open_WAV_Header  ( wave_t* type, const char* name );
size_t  Read_WAV_Samples ( wave_t* t, const size_t RequestedSamples, PCMDataTyp* data, const ptrdiff_t offset, const float scalel, const float scaler, int* Silence );
int     Read_WAV_Header  ( wave_t* type );


// winmsg.c
#ifdef _WIN32
int    SearchForFrontend   ( void );
void   SendQuitMessage     ( void );
void   SendModeMessage     ( const int );
void   SendStartupMessage  ( const char*, const int, const char* );
void   SendProgressMessage ( const int, const float, const float );
#else
# undef  WIN32_MESSAGES
# define WIN32_MESSAGES                 0
# define SearchForFrontend()            (0)
# define SendQuitMessage()              (void)0
# define SendModeMessage(x)             (void)0
# define SendStartupMessage(x,y,s)      (void)0
# define SendProgressMessage(x,y,z)     (void)0
#endif /* _WIN32 */


#define MPPENC_DENORMAL_FIX_BASE ( 32. * 1024. /* normalized sample value range */ / ( (float) (1 << 24 /* first bit below 32-bit PCM range */ ) ) )
#define MPPENC_DENORMAL_FIX_LEFT ( MPPENC_DENORMAL_FIX_BASE )
#define MPPENC_DENORMAL_FIX_RIGHT ( MPPENC_DENORMAL_FIX_BASE * 0.5f )


#endif /* MPPENC_MPPENC_H */

#if 0
# define LAST_HUFFMAN   15
# define DUMP_HIGHRES
#endif

#if 0
# define DUMP_RES15
#endif

#ifndef LAST_HUFFMAN
# define LAST_HUFFMAN    7
#endif

/* end of mppenc.h */
