/*
 * Musepack audio compression
 * Copyright (C) 1999-2004 Buschmann/Klemm/Piecha/Wolf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#if 1
# define ROUND32(x)   ( floattmp = (x) + (int)0x00FD8000L, *(int*)(&floattmp) - (int)0x4B7D8000L )
#else
# define ROUND32(x)   ( (int) floor ((x) + 0.5) )
#endif

#ifdef FAST_MATH

static __inline float
my_atan2 ( float x, float y )
{
    float  t;
    int    i;
    float  ret;
    float  floattmp;

    if ( (*(int*)&x & 0x7FFFFFFF) < (*(int*)&y & 0x7FFFFFFF) ) {
        i   = ROUND32 (t = TABSTEP * (x / y));
        ret = tabatan2 [1*TABSTEP+i][0] + tabatan2 [1*TABSTEP+i][1] * (t-i);
        if ( *(int*)&y < 0 )
           ret = (float)(ret - M_PI);
    }
    else if ( *(int*)&x < 0) {
        i   = ROUND32 (t = TABSTEP * (y / x));
        ret = - M_PI/2 - tabatan2 [1*TABSTEP+i][0] + tabatan2 [1*TABSTEP+i][1] * (i-t);
    }
    else if ( *(int*)&x > 0) {
        i   = ROUND32 (t = TABSTEP * (y / x));
        ret = + M_PI/2 - tabatan2 [1*TABSTEP+i][0] + tabatan2 [1*TABSTEP+i][1] * (i-t);
    }
    else {
        ret = 0.;
    }
    return ret;
}


static __inline float
my_cos ( float x )
{
    float  t;
    int    i;
    float  ret;
    float  floattmp;

    i   = ROUND32 (t = TABSTEP * x);
    ret = tabcos [13*TABSTEP+i][0] + tabcos [13*TABSTEP+i][1] * (t-i);
    return ret;
}


static __inline int
my_ifloor ( float x )
{
    x = x + (0x0C00000L + 0.500000001);
    return *(int*)&x - 1262485505;
}


static __inline float
my_sqrt ( float x )
{
    float  ret;
    int    i;
    int    ex = *(int*)&x >> 23;                                // get the exponent
    float  floattmp;

    *(int*)&x = (*(int*)&x & 0x7FFFFF) | 0x42800000;            // delete the exponent
    i    = ROUND32 (x);                                         // Integer-part of the mantissa  (round ????????????)
    ret  = tabsqrt_m [i-TABSTEP][0] + tabsqrt_m [i-TABSTEP][1] * (x-i); // calculate value
    ret *= tabsqrt_ex [ex];
    return ret;
}

#endif
